/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.print.misc;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import oracle.ide.print.misc.Util;

public final class Percent
extends JComboBox
implements ActionListener {
    private Listener myListener;
    private String[] myCustoms;
    private String myCurrentText;
    private double myCurrentValue;
    private boolean myDoChanges;
    private static final int LO_BOUND = 1000;
    private static final int HI_BOUND = 2000;
    private static final double THRESHOLD = 0.2;
    private static final double SUBTRAHEND = 0.01;
    private static final double MIN_VALUE = 0.01;
    private static final double MAX_VALUE = 15.0;
    private static final String NORMAL = "normal";
    private static final String CUSTOM = "custom";
    private static final String INCREASE = "increase";
    private static final String DECREASE = "decrease";
    private static final String PERCENT = "%";
    private static final double YUZ = 100.0;
    public static final double FACTOR = 1.05;

    public Percent(boolean doChanges, Listener listener, double initValue, int[] values, int defaultCustomIndex, String[] customs, String toolTip) {
        for (int value : values) {
            this.addItem(value + PERCENT);
        }
        if (customs != null) {
            for (String custom : customs) {
                this.addItem(custom);
            }
        }
        this.myDoChanges = doChanges;
        this.setToolTipText(toolTip);
        this.setEditable(true);
        this.myCustoms = customs;
        this.myListener = listener;
        JTextComponent jTextComponent = (JTextComponent)this.getEditor().getEditorComponent();
        InputMap inputMap = jTextComponent.getInputMap();
        ActionMap actionMap = jTextComponent.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke('+'), INCREASE);
        inputMap.put(KeyStroke.getKeyStroke('='), INCREASE);
        inputMap.put(KeyStroke.getKeyStroke('-'), DECREASE);
        inputMap.put(KeyStroke.getKeyStroke('_'), DECREASE);
        inputMap.put(KeyStroke.getKeyStroke('/'), CUSTOM);
        inputMap.put(KeyStroke.getKeyStroke('*'), NORMAL);
        actionMap.put(INCREASE, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (Percent.this.myDoChanges) {
                    Percent.this.increaseValue();
                }
            }
        });
        actionMap.put(DECREASE, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (Percent.this.myDoChanges) {
                    Percent.this.decreaseValue();
                }
            }
        });
        actionMap.put(CUSTOM, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        });
        actionMap.put(NORMAL, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (Percent.this.myDoChanges) {
                    Percent.this.normalValue();
                }
            }
        });
        this.addActionListener(this);
        this.setValue(initValue);
        this.selectValue();
    }

    public static boolean isZoomPage(double zoom) {
        return zoom == 0.0;
    }

    public static double getZoomFactor(double zoom, double defaultValue) {
        if (0.0 < zoom && zoom <= 15.0) {
            return zoom;
        }
        return defaultValue;
    }

    public static int getZoomWidth(double zoom, int defaultValue) {
        if (1000.0 <= zoom && zoom < 2000.0) {
            return Util.round(zoom - 1000.0);
        }
        return defaultValue;
    }

    public static int getZoomHeight(double zoom, int defaultValue) {
        if (2000.0 <= zoom) {
            return Util.round(zoom - 2000.0);
        }
        return defaultValue;
    }

    public static boolean isZoomFactor(double zoom) {
        return zoom < 1000.0;
    }

    public static boolean isZoomWidth(double zoom) {
        return 1000.0 <= zoom && zoom < 2000.0;
    }

    public static boolean isZoomHeight(double zoom) {
        return 2000.0 <= zoom;
    }

    public static double createZoomWidth(double zoom) {
        return 1000.0 + zoom;
    }

    public static double createZoomHeight(double zoom) {
        return 2000.0 + zoom;
    }

    private void selectValue() {
        String text = this.getEditorItem();
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!text.equals(this.getItemAt(i))) continue;
            this.setSelectedIndex(i);
        }
    }

    public boolean isCustomValue() {
        return this.getCustomIndex(this.getEditorItem()) != -1;
    }

    public String getEditorItem() {
        return this.getEditor().getItem().toString();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String value = this.getEditorItem();
        int k = this.getCustomIndex(value);
        if (k != -1) {
            this.valueChanged(this.getCustomValue(k), k);
            return;
        }
        double percent = this.parsePercent(value);
        if (this.isValid(percent)) {
            int i = this.getCustomIndex(percent);
            if (i != -1) {
                this.setValue(percent, i);
            } else {
                this.valueChanged(percent, i);
            }
        } else {
            this.myListener.invalidValue(value);
            this.setText(this.myCurrentText);
        }
    }

    private int getCustomIndex(String value) {
        if (this.myCustoms == null) {
            return -1;
        }
        for (int i = 0; i < this.myCustoms.length; ++i) {
            if (!this.myCustoms[i].equals(value)) continue;
            return i;
        }
        return -1;
    }

    public double getValue() {
        return this.myCurrentValue;
    }

    public void increaseValue() {
        if (this.myCurrentValue < 0.2) {
            this.setValue(this.myCurrentValue + 0.01);
        } else {
            this.setValue(this.myCurrentValue * 1.05);
        }
    }

    public void decreaseValue() {
        if (this.myCurrentValue > 0.2) {
            this.setValue(this.myCurrentValue / 1.05);
        } else {
            this.setValue(this.myCurrentValue - 0.01);
        }
    }

    public void normalValue() {
        this.setValue(1.0);
    }

    public void customValue(int index) {
        this.setValue(this.getCustomValue(index %= this.myCustoms.length), index);
    }

    public void setValue(double value) {
        this.setValue(value, this.getCustomIndex(value));
    }

    private void setValue(double value, int index) {
        String text = this.valueChanged(value, index);
        if (text != null) {
            this.setText(text);
        }
    }

    private String valueChanged(double value, int index) {
        boolean isCustomValue;
        boolean bl = isCustomValue = index != -1;
        if (!isCustomValue && !this.isValid(value)) {
            return null;
        }
        this.myCurrentValue = value;
        this.myCurrentText = isCustomValue && this.myCustoms != null ? this.myCustoms[index] : this.getPercent(value);
        this.myListener.valueChanged(value, index);
        return this.myCurrentText;
    }

    private void setText(String text) {
        this.getEditor().setItem(text);
    }

    private int getCustomIndex(double value) {
        if (this.myCustoms == null) {
            return -1;
        }
        for (int i = 0; i < this.myCustoms.length; ++i) {
            if (!this.getPercent(value).equals(this.getPercent(this.getCustomValue(i)))) continue;
            return i;
        }
        return -1;
    }

    private boolean isValid(double value) {
        return 0.01 <= value && value <= 15.0;
    }

    private double getCustomValue(int index) {
        return this.myListener.getCustomValue(index);
    }

    private double parsePercent(String text) {
        String value = text;
        if (value.endsWith(PERCENT)) {
            value = value.substring(0, value.length() - 1);
        }
        return (double)Util.getInt(value.trim()) / 100.0;
    }

    private String getPercent(double value) {
        return Util.round(100.0 * value) + PERCENT;
    }

    public static interface Listener {
        public double getCustomValue(int var1);

        public void valueChanged(double var1, int var3);

        public void invalidValue(String var1);
    }
}

