/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.print.misc;

import java.awt.Color;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.print.attribute.PrintRequestAttributeSet;
import oracle.ide.print.misc.Area;
import oracle.ide.print.misc.Ide;
import oracle.ide.print.misc.Macro;
import oracle.ide.print.misc.Util;

public final class Config {
    private Area myArea;
    private Preferences myPreferences = Ide.getIde().createPreferences();
    private static final Config INSTANCE = new Config();
    private static final double INCH_TO_PT = 72.0;
    private static final Font DEFAULT_TITLE_FONT = new Font("Serif", 0, 12);
    private static final Color DEFAULT_BACGROUND_COLOR = new Color(255, 255, 255);
    private static final String COMMA = ",";
    private static final String EMPTY = "";
    private static final String HEADER_LEFT_TEXT = Macro.NAME.getName();
    private static final String HEADER_CENTER_TEXT = "";
    private static final String HEADER_RIGHT_TEXT = "";
    private static final String FOOTER_LEFT_TEXT = Macro.ROW.getName() + "." + Macro.COLUMN.getName() + " / " + Macro.COUNT.getName();
    private static final String FOOTER_CENTER_TEXT = "";
    private static final String FOOTER_RIGHT_TEXT = Macro.DATE.getName() + " " + Macro.TIME.getName();
    private static final String SELECTION = "print.text.selection";
    private static final String PRINT_AS_SHOWN_IN_EDITOR = "print.text.as.shown.in.editor";
    private static final String WRAP_LONG_LINES = "print.text.wrap.long.lines";
    private static final String LINE_NUMBERS = "print.text.line.numbers";
    private static final String FONT_STYLE = "print.text.font.style";
    private static final String FOREGROUND_COLORS = "print.text.foreground.colors";
    private static final String TEXT_COLOR = "print.text.color";
    private static final String TEXT_FONT = "print.text.font";
    private static final String LINE_SPACING = "print.text.line.spacing";
    private static final String BACKGROUND_COLOR = "print.text.background.color";
    private static final String ZOOM = "print.zoom";
    private static final String BORDER = "print.border";
    private static final String BORDER_COLOR = "print.border.color";
    private static final String HEADER = "print.header";
    private static final String HEADER_LEFT = "print.header.left";
    private static final String HEADER_CENTER = "print.header.center";
    private static final String HEADER_RIGHT = "print.header.right";
    private static final String HEADER_COLOR = "print.header.color";
    private static final String HEADER_FONT = "print.header.font";
    private static final String FOOTER = "print.footer";
    private static final String FOOTER_LEFT = "print.footer.left";
    private static final String FOOTER_CENTER = "print.footer.center";
    private static final String FOOTER_RIGHT = "print.footer.right";
    private static final String FOOTER_COLOR = "print.footer.color";
    private static final String FOOTER_FONT = "print.footer.font";
    private static final String PAPER_ORIENTATION = "print.paper.orientation";
    private static final String PAPER_MEDIA = "print.paper.media";
    private static final String AREA_X = "print.page.x";
    private static final String AREA_Y = "print.page.y";
    private static final String AREA_WIDTH = "print.page.width";
    private static final String AREA_HEIGHT = "print.page.height";
    public static final Font DEFAULT_TEXT_FONT = new Font("Monospaced", 0, 12);
    public static final FontRenderContext FONT_RENDER_CONTEXT = new FontRenderContext(null, true, true);

    public static Config getConfig() {
        return INSTANCE;
    }

    private Config() {
        this.myArea = new Area(this.get(PAPER_MEDIA, -1), this.get(PAPER_ORIENTATION, -1), this.get(AREA_X, -1.0f), this.get(AREA_Y, -1.0f), this.get(AREA_WIDTH, -1.0f), this.get(AREA_HEIGHT, -1.0f));
    }

    public boolean openPageSetup() {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.lookupPrintServices();
        if (job.pageDialog(this.getAttributes()) == null) {
            return false;
        }
        this.set(PAPER_ORIENTATION, this.myArea.getOrientation());
        this.set(PAPER_MEDIA, this.myArea.getPaperMedia());
        this.set(AREA_X, this.myArea.getX());
        this.set(AREA_Y, this.myArea.getY());
        this.set(AREA_WIDTH, this.myArea.getWidth());
        this.set(AREA_HEIGHT, this.myArea.getHeight());
        return true;
    }

    public PageFormat getPageFormat() {
        return PrinterJob.getPrinterJob().getPageFormat(this.getAttributes());
    }

    public PrintRequestAttributeSet getAttributes() {
        return this.myArea.getAttributes();
    }

    public int getPaperWidth() {
        return Util.round((double)this.myArea.getPaperWidth() * 72.0);
    }

    public int getPaperHeight() {
        return Util.round((double)this.myArea.getPaperHeight() * 72.0);
    }

    public int getPageX() {
        return Util.round((double)this.myArea.getX() * 72.0);
    }

    public int getPageY() {
        int y = Util.round((double)this.myArea.getY() * 72.0);
        if (this.hasHeader()) {
            y = (int)((double)y + this.getBound(this.getHeaderFont()).getHeight());
        }
        return y;
    }

    public int getPageWidth() {
        return Util.round((double)this.myArea.getWidth() * 72.0);
    }

    public int getPageHeight() {
        int height = Util.round((double)this.myArea.getHeight() * 72.0);
        if (this.hasHeader()) {
            height = (int)((double)height - this.getBound(this.getHeaderFont()).getHeight());
        }
        if (this.hasFooter()) {
            height = (int)((double)height - this.getBound(this.getFooterFont()).getHeight());
        }
        return height;
    }

    public int getHeaderY() {
        return this.getPageY() - Util.round(this.getBound(this.getHeaderFont()).getMaxY());
    }

    public int getFooterY() {
        return this.getPageY() + this.getPageHeight() + Util.round(this.getBound(this.getFooterFont()).getHeight() - this.getBound(this.getFooterFont()).getMaxY());
    }

    public boolean hasBorder() {
        return this.get(BORDER, true);
    }

    public void setBorder(boolean value) {
        this.set(BORDER, value);
    }

    public boolean hasSelection() {
        return this.get(SELECTION, false);
    }

    public void setSelection(boolean value) {
        this.set(SELECTION, value);
    }

    public boolean isPrintAsShownInEditor() {
        return this.get(PRINT_AS_SHOWN_IN_EDITOR, false);
    }

    public void setPrintAsShownInEditor(boolean value) {
        this.set(PRINT_AS_SHOWN_IN_EDITOR, value);
    }

    public Color getBorderColor() {
        return this.getColor(this.get(BORDER_COLOR, null), Color.black);
    }

    public void setBorderColor(Color value) {
        this.set(BORDER_COLOR, this.getString(value));
    }

    public boolean hasHeader() {
        return this.get(HEADER, true);
    }

    public void setHeader(boolean value) {
        this.set(HEADER, value);
    }

    public String getHeaderLeft() {
        return this.get(HEADER_LEFT, HEADER_LEFT_TEXT);
    }

    public String getHeaderCenter() {
        return this.get(HEADER_CENTER, "");
    }

    public String getHeaderRight() {
        return this.get(HEADER_RIGHT, "");
    }

    public void setHeaderLeft(String value) {
        this.set(HEADER_LEFT, value);
    }

    public void setHeaderCenter(String value) {
        this.set(HEADER_CENTER, value);
    }

    public void setHeaderRight(String value) {
        this.set(HEADER_RIGHT, value);
    }

    public Color getHeaderColor() {
        return this.getColor(this.get(HEADER_COLOR, null), Color.black);
    }

    public Font getHeaderFont() {
        return this.getFont(this.get(HEADER_FONT, null), DEFAULT_TITLE_FONT);
    }

    public void setHeaderColor(Color value) {
        this.set(HEADER_COLOR, this.getString(value));
    }

    public void setHeaderFont(Font value) {
        this.set(HEADER_FONT, this.getString(value));
    }

    public boolean hasFooter() {
        return this.get(FOOTER, true);
    }

    public void setFooter(boolean value) {
        this.set(FOOTER, value);
    }

    public String getFooterLeft() {
        return this.get(FOOTER_LEFT, FOOTER_LEFT_TEXT);
    }

    public String getFooterCenter() {
        return this.get(FOOTER_CENTER, "");
    }

    public String getFooterRight() {
        return this.get(FOOTER_RIGHT, FOOTER_RIGHT_TEXT);
    }

    public void setFooterLeft(String value) {
        this.set(FOOTER_LEFT, value);
    }

    public void setFooterCenter(String value) {
        this.set(FOOTER_CENTER, value);
    }

    public void setFooterRight(String value) {
        this.set(FOOTER_RIGHT, value);
    }

    public Color getFooterColor() {
        return this.getColor(this.get(FOOTER_COLOR, null), Color.black);
    }

    public Font getFooterFont() {
        return this.getFont(this.get(FOOTER_FONT, null), DEFAULT_TITLE_FONT);
    }

    public void setFooterColor(Color value) {
        this.set(FOOTER_COLOR, this.getString(value));
    }

    public void setFooterFont(Font value) {
        this.set(FOOTER_FONT, this.getString(value));
    }

    public void setWrapLongLines(boolean value) {
        this.set(WRAP_LONG_LINES, value);
    }

    public boolean isWrapLongLines() {
        return this.get(WRAP_LONG_LINES, false);
    }

    public boolean hasLineNumbers() {
        return this.get(LINE_NUMBERS, false);
    }

    public void setLineNumbers(boolean value) {
        this.set(LINE_NUMBERS, value);
    }

    public boolean hasFontStyle() {
        return this.get(FONT_STYLE, true);
    }

    public void setFontStyle(boolean value) {
        this.set(FONT_STYLE, value);
    }

    public boolean hasForegroundColors() {
        return this.get(FOREGROUND_COLORS, true);
    }

    public void setForegroundColors(boolean value) {
        this.set(FOREGROUND_COLORS, value);
    }

    public Color getTextColor() {
        return this.getColor(this.get(TEXT_COLOR, null), Color.black);
    }

    public void setTextColor(Color value) {
        this.set(TEXT_COLOR, this.getString(value));
    }

    public Font getTextFont() {
        return this.getFont(this.get(TEXT_FONT, null), DEFAULT_TEXT_FONT);
    }

    public void setTextFont(Font value) {
        this.set(TEXT_FONT, this.getString(value));
    }

    public Color getBackgroundColor() {
        return this.getColor(this.get(BACKGROUND_COLOR, null), DEFAULT_BACGROUND_COLOR);
    }

    public void setBackgroundColor(Color value) {
        this.set(BACKGROUND_COLOR, this.getString(value));
    }

    public double getLineSpacing() {
        return this.get(LINE_SPACING, 1.0);
    }

    public void setLineSpacing(double value) {
        this.set(LINE_SPACING, value);
    }

    public void setZoom(double value) {
        this.set(ZOOM, value);
    }

    public double getZoom() {
        return this.get(ZOOM, 1.0);
    }

    private String get(String name, String defaultValue) {
        return this.myPreferences.get(name, defaultValue);
    }

    private boolean get(String name, boolean defaultValue) {
        return this.myPreferences.getBoolean(name, defaultValue);
    }

    private int get(String name, int defaultValue) {
        return this.myPreferences.getInt(name, defaultValue);
    }

    private double get(String name, double defaultValue) {
        return this.myPreferences.getDouble(name, defaultValue);
    }

    private float get(String name, float defaultValue) {
        return this.myPreferences.getFloat(name, defaultValue);
    }

    private void set(String name, String value) {
        this.myPreferences.put(name, value);
    }

    private void set(String name, boolean value) {
        this.myPreferences.putBoolean(name, value);
    }

    private void set(String name, double value) {
        this.myPreferences.putDouble(name, value);
    }

    private void set(String name, float value) {
        this.myPreferences.putFloat(name, value);
    }

    private void set(String name, int value) {
        this.myPreferences.putInt(name, value);
    }

    private String getString(Color value) {
        return value.getRed() + COMMA + value.getGreen() + COMMA + value.getBlue();
    }

    private String getString(Font value) {
        return value.getName() + COMMA + value.getStyle() + COMMA + value.getSize();
    }

    private Color getColor(String value, Color defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        StringTokenizer stk = new StringTokenizer(value, COMMA);
        int red = this.integer(stk);
        int green = this.integer(stk);
        int blue = this.integer(stk);
        if (red == -1 || green == -1 || blue == -1) {
            return defaultValue;
        }
        return new Color(red, green, blue);
    }

    private Font getFont(String value, Font defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        StringTokenizer stk = new StringTokenizer(value, COMMA);
        String name = this.getString(stk);
        int style = this.integer(stk);
        int size = this.integer(stk);
        if (name == null || style == -1 || size == -1) {
            return defaultValue;
        }
        return new Font(name, style, size);
    }

    private int integer(StringTokenizer stk) {
        if (!stk.hasMoreTokens()) {
            return -1;
        }
        return Util.getInt(stk.nextToken());
    }

    private String getString(StringTokenizer stk) {
        if (!stk.hasMoreTokens()) {
            return null;
        }
        return stk.nextToken();
    }

    private Rectangle2D getBound(Font font) {
        return font.getMaxCharBounds(FONT_RENDER_CONTEXT);
    }
}

