/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.print.misc;

import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.util.Locale;
import javax.print.attribute.EnumSyntax;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;

final class Area
extends MediaSizeName {
    private static final OrientationRequested[] ORIENTATION = new OrientationRequested[]{OrientationRequested.LANDSCAPE, OrientationRequested.PORTRAIT, OrientationRequested.REVERSE_LANDSCAPE};
    private static final OrientationRequested[] ORIENTATION_REQUESTED = new OrientationRequested[]{OrientationRequested.PORTRAIT, OrientationRequested.LANDSCAPE, OrientationRequested.REVERSE_LANDSCAPE, OrientationRequested.REVERSE_PORTRAIT};
    private PrintRequestAttributeSet myAttributes = new HashPrintRequestAttributeSet();
    private static final double PT_TO_INCH = 72.0;
    private static final int ORIENTATION_OFFSET = 3;

    Area(int media, int orientation, float x, float y, float width, float height) {
        super(0);
        PageFormat pageFormat = PrinterJob.getPrinterJob().defaultPage();
        if (0 <= (orientation -= 3) && orientation < ORIENTATION_REQUESTED.length) {
            this.myAttributes.add(ORIENTATION_REQUESTED[orientation]);
        } else {
            this.myAttributes.add(this.getOrientationFromPageFormat(pageFormat));
        }
        if ((media -= this.getOffset()) < 0 || media >= this.getEnumValueTable().length) {
            MediaSizeName size = MediaSize.findMedia(this.toInch(pageFormat.getWidth()), this.toInch(pageFormat.getHeight()), 25400);
            if (size == null) {
                size = Locale.getDefault() == Locale.US ? MediaSizeName.NA_LETTER : MediaSizeName.ISO_A4;
            }
            media = size.getValue();
        }
        this.myAttributes.add((Media)this.getEnumValueTable()[media]);
        if (x >= 0.0f && y >= 0.0f && width >= 0.0f && height >= 0.0f) {
            if (this.isReverseOrientation()) {
                this.myAttributes.add(new MediaPrintableArea(x, y, height, width, 25400));
            } else {
                this.myAttributes.add(new MediaPrintableArea(x, y, width, height, 25400));
            }
        } else {
            this.myAttributes.add(new MediaPrintableArea(this.toInch(pageFormat.getImageableX()), this.toInch(pageFormat.getImageableY()), this.toInch(pageFormat.getImageableWidth()), this.toInch(pageFormat.getImageableHeight()), 25400));
        }
    }

    PrintRequestAttributeSet getAttributes() {
        return this.myAttributes;
    }

    int getOrientation() {
        return ((OrientationRequested)this.myAttributes.get(OrientationRequested.class)).getValue();
    }

    private boolean isReverseOrientation() {
        OrientationRequested orientation = (OrientationRequested)this.myAttributes.get(OrientationRequested.class);
        return orientation == OrientationRequested.LANDSCAPE || orientation == OrientationRequested.REVERSE_LANDSCAPE;
    }

    float getPaperWidth() {
        return this.isReverseOrientation() ? this.getMediaSize().getY(25400) : this.getMediaSize().getX(25400);
    }

    float getPaperHeight() {
        return this.isReverseOrientation() ? this.getMediaSize().getX(25400) : this.getMediaSize().getY(25400);
    }

    int getPaperMedia() {
        return ((EnumSyntax)((Object)this.myAttributes.get(Media.class))).getValue();
    }

    private MediaSize getMediaSize() {
        MediaSizeName name = (MediaSizeName)this.getEnumValueTable()[this.getPaperMedia()];
        return MediaSize.getMediaSizeForName(name);
    }

    float getX() {
        return this.getArea().getX(25400);
    }

    float getY() {
        return this.getArea().getY(25400);
    }

    float getWidth() {
        return this.isReverseOrientation() ? this.getArea().getHeight(25400) : this.getArea().getWidth(25400);
    }

    float getHeight() {
        return this.isReverseOrientation() ? this.getArea().getWidth(25400) : this.getArea().getHeight(25400);
    }

    private MediaPrintableArea getArea() {
        return (MediaPrintableArea)this.myAttributes.get(MediaPrintableArea.class);
    }

    private float toInch(double pt) {
        return (float)(pt / 72.0);
    }

    private OrientationRequested getOrientationFromPageFormat(PageFormat pageFormat) {
        if (pageFormat == null) {
            return OrientationRequested.PORTRAIT;
        }
        int orientation = pageFormat.getOrientation();
        if (0 <= orientation && orientation < ORIENTATION.length) {
            return ORIENTATION[orientation];
        }
        return OrientationRequested.PORTRAIT;
    }
}

