/*
 * Decompiled with CFR 0.152.
 */
package oracle.viz.util.svg.internal;

import oracle.viz.util.svg.internal.SVGStyle;

public class SVGText
extends SVGStyle {
    int x;
    int y;
    double[] transformMatrix = null;
    String text = null;
    public String userScript = null;

    public void setUserScript(String userScript) {
        this.userScript = userScript;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setTransformMatrix(double[] matrix) {
        this.transformMatrix = (double[])(matrix == null ? null : (double[])(matrix[0] != 1.0 || matrix[3] != 1.0 ? matrix : null));
    }

    public String getSVG() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<text");
        if (this.userScript != null) {
            sbuf.append(this.userScript);
        }
        sbuf.append(" x=\"").append(this.x).append("\"");
        sbuf.append(" y=\"").append(this.y).append("\"");
        sbuf.append(" xml:space=\"preserve\"");
        sbuf.append(this.getSVGInline());
        if (this.transformMatrix != null) {
            sbuf.append(" transform=\"matrix( ");
            sbuf.append(this.transformMatrix[0]).append(" ");
            sbuf.append(this.transformMatrix[1]).append(" ");
            sbuf.append(this.transformMatrix[2]).append(" ");
            sbuf.append(this.transformMatrix[3]).append(" ");
            sbuf.append(this.transformMatrix[4]).append(" ");
            sbuf.append(this.transformMatrix[5]).append(" )\"");
        }
        sbuf.append(">");
        if (this.text != null) {
            sbuf.append(this.text);
        }
        sbuf.append("</text>\n");
        return sbuf.toString();
    }
}

