/*
 * Decompiled with CFR 0.152.
 */
package oracle.viz.util.codec;

import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import oracle.viz.util.codec.ChunkStream;

public class PNGEncoder {
    private static final boolean DEBUG = false;
    private static final byte[] PNG_MAGIC = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final int COLOR_GRAY = 0;
    private static final int COLOR_RGB = 2;
    private static final int COLOR_PALETTE = 3;
    private static final int COLOR_GRAY_ALPHA = 4;
    private static final int COLOR_RGB_ALPHA = 6;
    private static final int COMPRESSION_DEFLATE = 0;
    private static final int FILTER_ADAPTIVE = 0;
    private static final int INTERLACE_NONE = 0;
    private static final int INTERLACE_ADAM7 = 1;
    private static final int ROW_FILTER_NONE = 0;
    private static final int ROW_FILTER_SUB = 1;
    private static final int ROW_FILTER_UP = 2;
    private static final int ROW_FILTER_AVERAGE = 3;
    private static final int ROW_FILTER_PAETH = 4;
    private DataOutputStream dos = null;
    private RenderedImage image = null;
    private Deflater deflater = null;
    private int width = 0;
    private int height = 0;
    private int bitDepth = 0;
    private int colorType = 0;
    private int numOutBands = 0;
    private SampleModel sm = null;
    private ColorModel cm = null;

    public PNGEncoder(OutputStream output) {
        this.dos = new DataOutputStream(output);
        this.deflater = new Deflater(3);
    }

    public PNGEncoder(OutputStream output, int level) {
        this.dos = new DataOutputStream(output);
        this.deflater = new Deflater(level);
    }

    public PNGEncoder(OutputStream output, Deflater deflater) {
        this.dos = new DataOutputStream(output);
        this.deflater = deflater;
    }

    public void encode(RenderedImage im) throws IOException {
        this.image = im;
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
        this.sm = this.image.getSampleModel();
        this.cm = this.image.getColorModel();
        if (this.cm instanceof IndexColorModel) {
            this.colorType = 3;
            this.bitDepth = ((IndexColorModel)this.cm).getPixelSize();
            this.numOutBands = 1;
        } else if (this.sm.getNumBands() < 3) {
            this.bitDepth = this.cm instanceof ComponentColorModel ? this.cm.getComponentSize(0) : this.sm.getSampleSize(0);
            if (this.cm.hasAlpha()) {
                this.colorType = 4;
                this.numOutBands = 2;
            } else {
                this.colorType = 0;
                this.numOutBands = 1;
            }
        } else {
            this.bitDepth = this.sm.getSampleSize(0);
            if (this.cm.hasAlpha()) {
                this.colorType = 6;
                this.numOutBands = 4;
            } else {
                this.colorType = 2;
                this.numOutBands = 3;
            }
        }
        if (this.bitDepth > 2 && this.bitDepth <= 4) {
            this.bitDepth = 4;
        } else if (this.bitDepth > 4 && this.bitDepth <= 8) {
            this.bitDepth = 8;
        } else if (this.bitDepth > 8 && this.bitDepth <= 16) {
            this.bitDepth = 16;
        } else if (this.bitDepth > 16) {
            throw new RuntimeException("Bit depth too large for PNG encoding");
        }
        this.writeMagic();
        this.writeIHDR();
        this.writePLTE();
        this.writeTRNS();
        this.writeIDAT();
        this.writeIEND();
        this.dos.flush();
        this.dos.close();
    }

    private void writeMagic() throws IOException {
        this.dos.write(PNG_MAGIC);
    }

    private void writeIHDR() throws IOException {
        ChunkStream cs = new ChunkStream("IHDR");
        cs.writeInt(this.width);
        cs.writeInt(this.height);
        cs.writeByte(this.bitDepth);
        cs.writeByte(this.colorType);
        cs.writeByte(0);
        cs.writeByte(0);
        cs.writeByte(0);
        cs.writeToStream(this.dos);
    }

    private void writePLTE() throws IOException {
        if (this.colorType != 3) {
            return;
        }
        IndexColorModel icm = (IndexColorModel)this.cm;
        int size = icm.getMapSize();
        if (size > 256) {
            throw new RuntimeException("Palette too large for PNG encoding");
        }
        byte[] reds = new byte[size];
        icm.getReds(reds);
        byte[] greens = new byte[size];
        icm.getGreens(greens);
        byte[] blues = new byte[size];
        icm.getBlues(blues);
        ChunkStream cs = new ChunkStream("PLTE");
        int i = 0;
        while (i < size) {
            cs.writeByte(reds[i]);
            cs.writeByte(greens[i]);
            cs.writeByte(blues[i]);
            ++i;
        }
        cs.writeToStream(this.dos);
    }

    private void writeTRNS() throws IOException {
        if (this.colorType != 3) {
            return;
        }
        IndexColorModel icm = (IndexColorModel)this.cm;
        int size = icm.getMapSize();
        if (size > 256) {
            throw new RuntimeException("Alpha palette too large for PNG encoding");
        }
        byte[] alphas = new byte[size];
        icm.getAlphas(alphas);
        int lastAlpha = size - 1;
        while (lastAlpha >= 0) {
            if (alphas[lastAlpha] != -1) {
                ChunkStream cs = new ChunkStream("tRNS");
                int i = 0;
                while (i <= lastAlpha) {
                    cs.writeByte(alphas[i]);
                    ++i;
                }
                cs.writeToStream(this.dos);
                break;
            }
            --lastAlpha;
        }
    }

    private void writeIDAT() throws IOException {
        ChunkStream cs = new ChunkStream("IDAT");
        DeflaterOutputStream dfs = new DeflaterOutputStream((OutputStream)cs, this.deflater);
        Raster ras = this.image.getData();
        int minX = ras.getMinX();
        int minY = ras.getMinY();
        int samplesPerByte = 8 / this.bitDepth;
        int extraSamples = 0;
        if (this.bitDepth < 8) {
            extraSamples = samplesPerByte - this.width % samplesPerByte;
        }
        int[] samples = new int[this.width * this.sm.getNumBands() + extraSamples];
        int scanlineBytes = this.width * this.numOutBands;
        if (this.bitDepth < 8) {
            scanlineBytes = (this.width + samplesPerByte - 1) / samplesPerByte;
        } else if (this.bitDepth == 16) {
            scanlineBytes *= 2;
        }
        byte[] scanline = new byte[scanlineBytes];
        int row = 0;
        while (row < this.height) {
            this.getScanline(ras, minX, minY + row, samples, scanline);
            dfs.write(0);
            dfs.write(scanline);
            ++row;
        }
        dfs.finish();
        cs.writeToStream(this.dos);
    }

    private void writeIEND() throws IOException {
        ChunkStream cs = new ChunkStream("IEND");
        cs.writeToStream(this.dos);
    }

    private void getScanline(Raster ras, int x, int y, int[] samples, byte[] scanline) {
        ras.getPixels(x, y, this.width, 1, samples);
        int pos = 0;
        switch (this.bitDepth) {
            case 1: {
                int i = 0;
                while (i < scanline.length) {
                    scanline[i] = (byte)((samples[pos++] & 1) << 7 | (samples[pos++] & 1) << 6 | (samples[pos++] & 1) << 5 | (samples[pos++] & 1) << 4 | (samples[pos++] & 1) << 3 | (samples[pos++] & 1) << 2 | (samples[pos++] & 1) << 1 | samples[pos++] & 1);
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < scanline.length) {
                    scanline[i] = (byte)((samples[pos++] & 3) << 6 | (samples[pos++] & 3) << 4 | (samples[pos++] & 3) << 2 | samples[pos++] & 3);
                    ++i;
                }
                break;
            }
            case 4: {
                int i = 0;
                while (i < scanline.length) {
                    scanline[i] = (byte)((samples[pos++] & 0xF) << 4 | samples[pos++] & 0xF);
                    ++i;
                }
                break;
            }
            case 8: {
                int i = 0;
                while (i < scanline.length) {
                    scanline[i] = (byte)samples[i];
                    ++i;
                }
                break;
            }
            case 16: {
                int i = 0;
                while (i < samples.length) {
                    scanline[pos++] = (byte)(samples[i] >> 8);
                    scanline[pos++] = (byte)(samples[i] & 0xFF);
                    ++i;
                }
                break;
            }
        }
    }
}

