/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.types;

import java.awt.Color;
import java.util.Date;
import java.util.Vector;
import oracle.charts.types.ImageMapAreaDescSingle;
import oracle.charts.types.MarkerDesc;
import oracle.charts.types.TaskBase;

public class TaskDesc
extends TaskBase {
    public static final int NORMAL_TASK = 0;
    public static final int MILESTONE = 1;
    public static final int TASK_GROUP = 2;
    public static final int MARKER_DESC = 3;
    public static final Color defaultTaskBackgroundColor = new Color(230, 230, 230);
    String label;
    int style = 0;
    float completion = 0.0f;
    Color color = defaultTaskBackgroundColor;
    Color labelColor = Color.black;
    Color linkColor = new Color(64, 64, 64);
    Vector repeaters = null;
    MarkerDesc Marker = null;
    public ImageMapAreaDescSingle imapNavigator;
    public ImageMapAreaDescSingle imapTask;

    public TaskDesc() {
        this.label = null;
    }

    public TaskDesc(long id, String label, Date startDate, Date endDate) {
        super(id, startDate, endDate);
        this.label = label;
    }

    public TaskDesc(long id, String label) {
        super(id);
        this.label = label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setBackground(Color c) {
        this.color = c;
    }

    public void setLabelColor(Color c) {
        this.labelColor = c;
    }

    public void setLinkColor(Color c) {
        this.linkColor = c;
    }

    public void setCompletion(float completionFraction) {
        if ((double)completionFraction < 0.0 || (double)completionFraction > 1.0) {
            throw new IllegalArgumentException("Illegal completion completionFractionage");
        }
        this.completion = completionFraction;
    }

    public void setTaskStyle(int style) {
        switch (style) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.style = style;
            }
        }
        switch (style) {
            case 0: {
                this.color = defaultTaskBackgroundColor;
                break;
            }
            case 1: 
            case 2: {
                this.color = Color.black;
                break;
            }
        }
    }

    public void setTaskStyleMarker(MarkerDesc marker) {
        this.style = 3;
        this.Marker = marker;
    }

    public String getLabel() {
        return this.label;
    }

    public Color getBackground() {
        return this.color;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public Color getLinkColor() {
        return this.linkColor;
    }

    public float getCompletion() {
        return this.completion;
    }

    public int getTaskStyle() {
        return this.style;
    }

    public MarkerDesc getTaskStyleMarker() {
        return this.Marker;
    }

    public void addRepeat(long ID, Date start, Date end) {
        if (null == this.repeaters) {
            this.repeaters = new Vector();
        }
        this.repeaters.add(new TaskBase(ID, start, end));
    }

    public void addRepeat(long ID, Date start) {
        if (null == this.repeaters) {
            this.repeaters = new Vector();
        }
        this.repeaters.add(new TaskBase(ID, start, start));
    }

    public void addRepeat(long[] IDs, Date[] starts, Date[] ends) {
        if (IDs.length != starts.length || IDs.length != ends.length) {
            throw new IllegalArgumentException("Illegal repeating tasks specification");
        }
        int i = 0;
        while (i < IDs.length) {
            this.addRepeat(IDs[i], starts[i], ends[i]);
            ++i;
        }
    }

    public void addRepeat(long[] IDs, Date[] starts) {
        if (IDs.length != starts.length) {
            throw new IllegalArgumentException("Illegal repeating tasks specification");
        }
        int i = 0;
        while (i < IDs.length) {
            this.addRepeat(IDs[i], starts[i]);
            ++i;
        }
    }

    public int getNumRepeats() {
        if (null == this.repeaters) {
            return 0;
        }
        return this.repeaters.size();
    }

    public TaskBase getRepeat(int num) {
        return (TaskBase)this.repeaters.get(num);
    }

    public String toString() {
        String result = "Task " + this.ID;
        if (null != this.label) {
            result = result + ": " + this.label;
        }
        return result;
    }

    public ImageMapAreaDescSingle getIMapNavigator() {
        return this.imapNavigator;
    }

    public ImageMapAreaDescSingle getIMapTask() {
        return this.imapTask;
    }
}

