/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.internal;

import java.text.MessageFormat;

public final class TimeIntervalFormat {
    private static int MINUTE_NUM_SECONDS = 60;
    private static int HOUR_NUM_SECONDS = 3600;
    private static int DAY_NUM_SECONDS = 86400;

    public static String formatNumber(double number) {
        return TimeIntervalFormat.formatNumber(null, null, number);
    }

    public static String formatNumber(String posNLSDays, String negNLSDays, double value) {
        long fullValue = Math.round(value);
        long l = fullValue % (long)DAY_NUM_SECONDS;
        StringBuffer duration = new StringBuffer();
        long hours = l / (long)HOUR_NUM_SECONDS;
        if (Math.abs(hours) <= 9L) {
            duration.append("0");
        }
        duration.append(Long.toString(Math.abs(hours)));
        duration.append(":");
        long minutes = (l %= (long)HOUR_NUM_SECONDS) / (long)MINUTE_NUM_SECONDS;
        if (Math.abs(minutes) <= 9L) {
            duration.append("0");
        }
        duration.append(Long.toString(Math.abs(minutes)));
        duration.append(":");
        if (Math.abs(l %= (long)MINUTE_NUM_SECONDS) <= 9L) {
            duration.append("0");
        }
        duration.append(Long.toString(Math.abs(l)));
        String durationString = duration.toString();
        boolean isNegative = false;
        if (fullValue < 0L) {
            isNegative = true;
        }
        if (Math.abs(fullValue) >= (long)DAY_NUM_SECONDS) {
            long days = fullValue / (long)DAY_NUM_SECONDS;
            String dayString = Long.toString(Math.abs(days));
            String key = null;
            key = isNegative ? negNLSDays : posNLSDays;
            String retStr = null;
            if (key == null) {
                retStr = isNegative ? "-" : "";
                retStr = retStr + dayString + " " + durationString;
                return retStr;
            }
            retStr = TimeIntervalFormat.formatString(key, new Object[]{dayString, durationString});
            return retStr;
        }
        if (isNegative) {
            return "-" + durationString;
        }
        return durationString;
    }

    public static String formatString(String bundleString, Object[] args) {
        MessageFormat format = null;
        format = new MessageFormat(bundleString);
        if (format != null) {
            return format.format(args);
        }
        return null;
    }
}

