/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.axischart.internal;

import java.util.Date;
import oracle.charts.axischart.internal.MillisecondsCalendar;

public final class TimeAxisContinuous {
    public Date startTStamp;
    public Date endTStamp;
    public long xAxisSpanMillis = 0L;
    public long xAxisStartMillis = 0L;
    public long xAxisEndMillis = 0L;
    public MillisecondsCalendar millisC = new MillisecondsCalendar();

    public TimeAxisContinuous() {
    }

    public TimeAxisContinuous(Date startDate, Date endDate) {
        this.startTStamp = startDate;
        this.endTStamp = endDate;
        this.millisC.setTime(startDate);
        this.xAxisStartMillis = this.millisC.getTimeInMillis();
        this.millisC.setTime(endDate);
        this.xAxisEndMillis = this.millisC.getTimeInMillis();
        this.xAxisSpanMillis = this.xAxisEndMillis - this.xAxisStartMillis;
    }

    public double convertDateToDouble(Date d1) {
        this.millisC.setTime(d1);
        double dateFraction = this.getTimeLineFraction();
        return dateFraction;
    }

    public double getTimeLineFraction() {
        long dateMillis = this.millisC.getTimeInMillis();
        double dateFraction = dateMillis - this.xAxisStartMillis;
        return dateFraction /= (double)this.xAxisSpanMillis;
    }
}

