/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.axischart.internal;

import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;
import oracle.charts.axischart.internal.HorizontalLayout;
import oracle.charts.axischart.internal.LineDescription;
import oracle.charts.axischart.internal.MathUtil;
import oracle.charts.axischart.internal.NumAxisMetrics;
import oracle.charts.axischart.internal.NumericalFormat;
import oracle.charts.internal.Precision;
import oracle.charts.types.NumAxisDesc;

public final class NumAxisStretch {
    public Vector vgrid_y = new Vector();
    public Vector vgrid_y_raster = new Vector();
    public Vector vgrid_yString = new Vector();
    Locale chartLocale;

    public void setChartLocale(Locale chtLocale) {
        this.chartLocale = chtLocale;
    }

    private void dump_ygrid() {
        System.out.println("Diagnostic Compare ");
        System.out.println("grid_y ");
        int i = 0;
        while (i < this.vgrid_y.size()) {
            System.out.println(" vgrid " + this.vgrid_y.elementAt(i));
            ++i;
        }
        System.out.println("grid_y_raster ");
        i = 0;
        while (i < this.vgrid_y_raster.size()) {
            System.out.println(" vgrid " + this.vgrid_y_raster.elementAt(i));
            ++i;
        }
    }

    public void NumAxisStretch(Vector plotLineD, NumAxisMetrics yAxisMet, double yGridSpacing, boolean yGridAutoSpacing, boolean yGridisIntegerLabels, NumAxisDesc numAxisD, NumberFormat continuousAxisNumberFormat, double plotWindowHeight, double sc_Displayheight, double sc_Displaywidth, boolean sc_containsPointLabels, boolean sc_containsBarIcons, HorizontalLayout hLayout, boolean vertical) {
        double mult_factor;
        boolean test = false;
        boolean drawYLabel = numAxisD.getDrawLabel();
        if (continuousAxisNumberFormat != null) {
            drawYLabel = true;
        }
        if (yGridSpacing == 0.0) {
            return;
        }
        this.vgrid_y.removeAllElements();
        this.vgrid_yString.removeAllElements();
        this.vgrid_y_raster.removeAllElements();
        double newYmin = yAxisMet.Ymin_non_adjusted;
        double newYmax = yAxisMet.Ymax_non_adjusted;
        yAxisMet.Ymin = yAxisMet.Ymin_non_adjusted;
        yAxisMet.Ymax = yAxisMet.Ymax_non_adjusted;
        if (numAxisD.getLogScale()) {
            newYmin = MathUtil.log10(newYmin);
            newYmax = MathUtil.log10(newYmax);
        }
        if (plotWindowHeight <= 0.0) {
            plotWindowHeight = 5.0;
        }
        double verticalHeight = newYmax - newYmin;
        double verticalDelta = verticalHeight / plotWindowHeight * 5.0;
        double zeroAdjustFactor = 0.3;
        double zeroAdjustValue = verticalHeight * zeroAdjustFactor;
        if (yAxisMet.AutoExtentMin && newYmin != 0.0) {
            newYmin = newYmin > 0.0 ? (!drawYLabel ? 0.0 : (newYmin < zeroAdjustValue ? 0.0 : (newYmin -= verticalDelta))) : (newYmin -= verticalDelta);
        }
        if (yAxisMet.AutoExtentMax && newYmax != 0.0) {
            newYmax = newYmax < 0.0 ? (!drawYLabel ? 0.0 : (newYmax > -zeroAdjustValue ? 0.0 : (newYmax += verticalDelta))) : (newYmax += verticalDelta);
        }
        if (sc_containsPointLabels || sc_containsBarIcons) {
            if (vertical) {
                double pointLabelHeightWC = this.getPointLabelHeightWC(plotLineD, sc_Displayheight, newYmin, newYmax);
                if (pointLabelHeightWC != 0.0) {
                    if (yAxisMet.AutoExtentMax && newYmax > 0.0) {
                        newYmax += pointLabelHeightWC;
                    }
                    if (yAxisMet.AutoExtentMin && newYmin < 0.0) {
                        newYmin -= pointLabelHeightWC;
                    }
                }
            } else {
                double barIconWidthWC;
                double pointLabelWidthWC;
                if (yAxisMet.AutoExtentMax && newYmax > 0.0) {
                    if (sc_containsPointLabels) {
                        pointLabelWidthWC = this.getWidthWCHorizontal(hLayout.longestPosPointLabelWidth, newYmin, newYmax, sc_Displaywidth);
                        newYmax += pointLabelWidthWC;
                    } else if (sc_containsBarIcons) {
                        barIconWidthWC = this.getWidthWCHorizontal(hLayout.longestPosBarIconWidth, newYmin, newYmax, sc_Displaywidth);
                        newYmax += barIconWidthWC;
                    }
                }
                if (yAxisMet.AutoExtentMin && newYmin < 0.0) {
                    if (sc_containsPointLabels) {
                        pointLabelWidthWC = this.getWidthWCHorizontal(hLayout.longestNegPointLabelWidth, newYmin, newYmax, sc_Displaywidth);
                        newYmin -= pointLabelWidthWC;
                    } else if (sc_containsBarIcons) {
                        barIconWidthWC = this.getWidthWCHorizontal(hLayout.longestNegBarIconWidth, newYmin, newYmax, sc_Displaywidth);
                        newYmin -= barIconWidthWC;
                    }
                }
            }
        }
        int sigDigits = 0;
        if (yGridSpacing >= 1.0 && !Precision.isFraction(yGridSpacing)) {
            mult_factor = 1.0;
        } else {
            sigDigits = 1;
            mult_factor = 10.0;
            while (yGridSpacing * mult_factor < 1.0) {
                mult_factor *= 10.0;
                ++sigDigits;
            }
            int loopMax = 2;
            int loopCount = 0;
            while (yGridSpacing * mult_factor - (double)((long)(yGridSpacing * mult_factor)) > 0.0 && loopCount < loopMax) {
                mult_factor *= 10.0;
                ++sigDigits;
                ++loopCount;
            }
        }
        double spacing = yGridSpacing * mult_factor;
        double grid_y_start = (newYmin *= mult_factor) == 0.0 ? 0.0 : (newYmin > 0.0 ? (yAxisMet.AutoExtentMin || !yGridAutoSpacing ? newYmin / spacing : (newYmin + spacing) / spacing) : (yAxisMet.AutoExtentMin ? (newYmin - spacing) / spacing : newYmin / spacing));
        double grid_y_end = newYmax == 0.0 ? 0.0 : (newYmax < 0.0 ? (yAxisMet.AutoExtentMax ? newYmax / spacing : (newYmax - spacing) / spacing) : (yAxisMet.AutoExtentMax ? (newYmax + spacing) / spacing : (newYmax *= mult_factor) / spacing));
        long grid_y_start_long = (long)grid_y_start;
        long grid_y_end_long = (long)grid_y_end;
        grid_y_start_long = (long)((double)grid_y_start_long * spacing);
        grid_y_end_long = (long)((double)grid_y_end_long * spacing);
        grid_y_start = grid_y_start_long;
        grid_y_end = grid_y_end_long;
        grid_y_start /= mult_factor;
        grid_y_end /= mult_factor;
        if (numAxisD.getLogScale()) {
            if (grid_y_start < MathUtil.log10(yAxisMet.Ymin)) {
                yAxisMet.Ymin = MathUtil.pow10(grid_y_start);
                yAxisMet.y_coordinate_spread_log = MathUtil.log10(yAxisMet.Ymax) - MathUtil.log10(yAxisMet.Ymin);
            }
        } else if (grid_y_start < yAxisMet.Ymin) {
            yAxisMet.Ymin = grid_y_start;
            yAxisMet.y_coordinate_spread = yAxisMet.Ymax - yAxisMet.Ymin;
        }
        if (numAxisD.getLogScale()) {
            if (grid_y_end > MathUtil.log10(yAxisMet.Ymax)) {
                yAxisMet.Ymax = MathUtil.pow10(grid_y_end);
                yAxisMet.y_coordinate_spread_log = MathUtil.log10(yAxisMet.Ymax) - MathUtil.log10(yAxisMet.Ymin);
            }
        } else if (grid_y_end > yAxisMet.Ymax) {
            yAxisMet.Ymax = grid_y_end;
            yAxisMet.y_coordinate_spread = yAxisMet.Ymax - yAxisMet.Ymin;
        }
        long i = 0L;
        while (true) {
            Double gridvalue = new Double(Precision.roundNSig2(grid_y_start + (double)i * yGridSpacing, sigDigits));
            if (numAxisD.getLogScale()) {
                if (gridvalue > newYmax) break;
                if (gridvalue >= newYmin) {
                    if (gridvalue == 0.0) {
                        this.vgrid_y.addElement(gridvalue);
                    } else if (gridvalue < 0.0) {
                        double p = -MathUtil.pow10(Math.abs(gridvalue));
                        this.vgrid_y.addElement(new Double(p));
                    } else {
                        this.vgrid_y.addElement(new Double(MathUtil.pow10(gridvalue)));
                    }
                }
            } else {
                if (gridvalue > yAxisMet.Ymax) break;
                this.vgrid_y.addElement(gridvalue);
            }
            ++i;
        }
        int j = 0;
        while (j < this.vgrid_y.size()) {
            this.vgrid_y_raster.addElement(this.vgrid_y.elementAt(j));
            String tempLabel = NumericalFormat.formatNumber(this.chartLocale, numAxisD, continuousAxisNumberFormat, (Double)this.vgrid_y.elementAt(j), yGridisIntegerLabels, sigDigits);
            this.vgrid_yString.addElement(tempLabel);
            ++j;
        }
    }

    private double getWidthWCHorizontal(double widthDC, double ymin, double ymax, double sc_Displaywidth) {
        if (widthDC == 0.0) {
            return 0.0;
        }
        double widthWC = 0.0;
        double y_coordinate_spread = ymax - ymin;
        widthWC = widthDC * y_coordinate_spread / sc_Displaywidth;
        widthWC *= (y_coordinate_spread + widthWC) / y_coordinate_spread;
        return widthWC;
    }

    private double getPointLabelHeightWC(Vector plotLineD, double sc_Displayheight, double newYmin, double newYmax) {
        int pointLabelHeight = 0;
        boolean pointLabelsConsumeSpace = false;
        int s = 0;
        while (s < plotLineD.size()) {
            LineDescription line = (LineDescription)plotLineD.elementAt(s);
            if (line.pointLabelsOn && !line.pointLabelsInterior) {
                pointLabelsConsumeSpace = true;
                pointLabelHeight = line.fontmet.getHeight();
                break;
            }
            ++s;
        }
        double pointLabelHeightWC = 0.0;
        if (pointLabelsConsumeSpace) {
            pointLabelHeightWC = (double)pointLabelHeight * ((newYmax - newYmin) / sc_Displayheight);
        }
        return pointLabelHeightWC;
    }
}

