/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.axischart.internal;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.Vector;
import oracle.charts.axischart.internal.AxisTitle;
import oracle.charts.axischart.internal.ChartDescription;
import oracle.charts.axischart.internal.SvgUtil2;
import oracle.charts.types.NumAxisDesc;
import oracle.viz.util.svg.SVGChartGraphics;

public final class NumAxisLabel {
    public NumAxisDesc numAxisD = new NumAxisDesc();
    Font font = new Font("sansserif", 0, 11);
    public FontMetrics fontmet;

    private int getFontHeight() {
        int labelHeight = this.fontmet.getHeight();
        return labelHeight;
    }

    public boolean isIntegerLabels2(double ymin, double ymax) {
        return ymax - ymin >= 10.0;
    }

    public void drawBuffer(Graphics2D g2, SVGChartGraphics svgG, ChartDescription Ch, AxisTitle AxisT, int subchartXOrigin, Vector vgrid_y_raster, Vector vgrid_yString, int max_string_width) {
        boolean test = false;
        if (test) {
            System.out.println("drawBuffer: drawLabel " + this.numAxisD.getDrawLabel());
        }
        int labelHeight = this.fontmet.getHeight();
        int labelHeightSpace = labelHeight / 3;
        int x_offset = 0;
        int x_offset2 = 0;
        int x_offset_pre = 0;
        int x_offset_pre2 = 0;
        if (!this.numAxisD.getDrawLabel()) {
            return;
        }
        g2.setFont(this.numAxisD.getFont());
        g2.setColor(this.numAxisD.getColor());
        if (test) {
            System.out.println("drawBuffer: getMaxStringWidth() " + max_string_width);
            System.out.println("drawBuffer: vgrid_yString.size " + vgrid_yString.size());
        }
        int suffix_width = this.fontmet.stringWidth(this.numAxisD.getSuffix());
        int prefix_width = this.fontmet.stringWidth(this.numAxisD.getPrefix());
        int borderOffset = 0;
        if (AxisT.titleDescY.getTitle() != "") {
            borderOffset = AxisT.YAxisTitleFontmet.getHeight();
        }
        switch (this.numAxisD.getLabelLocation()) {
            default: {
                x_offset_pre = borderOffset / 2 + Ch.border_left / 2 - max_string_width / 2 - suffix_width / 2;
                break;
            }
            case 1: {
                x_offset_pre = Ch.displayWidth - Ch.border_right + ((Ch.border_right - Ch.legendWidth - max_string_width) / 2 - suffix_width);
                break;
            }
            case 2: {
                x_offset_pre = borderOffset / 2 + Ch.border_left / 2 - max_string_width / 2 - suffix_width / 2;
                x_offset_pre2 = Ch.displayWidth - Ch.border_right + ((Ch.border_right - Ch.legendWidth - max_string_width) / 2 - suffix_width);
            }
        }
        boolean testSVGClip = false;
        int plotHeight = Ch.displayHeight - Ch.border_bottom - Ch.border_top;
        int labelHeightHalf = labelHeight / 2;
        if (this.numAxisD.getLabelLocation() == 0 || this.numAxisD.getLabelLocation() == 2) {
            SvgUtil2.writeSVGClipWindow(svgG, Ch, "cb_YAxisClip", 0, Ch.border_top - labelHeightHalf, Ch.border_left, plotHeight + labelHeight);
        }
        if (this.numAxisD.getLabelLocation() == 1 || this.numAxisD.getLabelLocation() == 2) {
            // empty if block
        }
        int i = 0;
        while (i < vgrid_yString.size()) {
            int x_coord;
            String label;
            String NumAxisLabel2 = (String)vgrid_yString.elementAt(i);
            int string_width = this.fontmet.stringWidth(NumAxisLabel2);
            int delta_width = max_string_width - string_width;
            x_offset = x_offset_pre + delta_width;
            if (this.numAxisD.getLabelLocation() == 2) {
                x_offset2 = x_offset_pre2 + delta_width;
            }
            long grid_y_coordinate = ((Double)vgrid_y_raster.elementAt(i)).longValue();
            if (test) {
                System.out.println("drawBuffer: " + i + " " + NumAxisLabel2 + " " + x_offset + " " + grid_y_coordinate);
            }
            int x_coord2 = 0;
            if (i == vgrid_yString.size() - 1 && (this.numAxisD.getPrefix().length() > 0 || this.numAxisD.getSuffix().length() > 0)) {
                label = this.numAxisD.getPrefix() + NumAxisLabel2 + this.numAxisD.getSuffix();
                x_coord = subchartXOrigin + x_offset - prefix_width;
                if (this.numAxisD.getLabelLocation() == 2) {
                    x_coord2 = subchartXOrigin + x_offset2 - prefix_width;
                }
            } else {
                label = NumAxisLabel2;
                x_coord = subchartXOrigin + x_offset;
                if (this.numAxisD.getLabelLocation() == 2) {
                    x_coord2 = subchartXOrigin + x_offset2;
                }
            }
            g2.drawString(label, (float)x_coord, (float)(grid_y_coordinate + (long)labelHeightSpace));
            if (this.numAxisD.getLabelLocation() == 2) {
                g2.drawString(label, (float)x_coord2, (float)(grid_y_coordinate + (long)labelHeightSpace));
            }
            ++i;
        }
    }

    public void drawBufferHorizontal(Graphics2D g2, SVGChartGraphics svgG, ChartDescription Ch, int yBaseline, Vector vgrid_y, Vector vgrid_y_raster, Vector vgrid_yString) {
        boolean test = false;
        if (test) {
            System.out.println("drawBuffer: drawLabel " + this.numAxisD.getDrawLabel());
        }
        if (!this.numAxisD.getDrawLabel()) {
            return;
        }
        int labelHeight = this.fontmet.getHeight();
        if (!this.numAxisD.getDrawLabel()) {
            return;
        }
        g2.setFont(this.numAxisD.getFont());
        g2.setColor(this.numAxisD.getColor());
        if (test) {
            System.out.println("drawBuffer: vgrid_yString.size " + vgrid_yString.size());
        }
        int suffix_width = this.fontmet.stringWidth(this.numAxisD.getSuffix());
        int prefix_width = this.fontmet.stringWidth(this.numAxisD.getPrefix());
        int real_y_offset = Ch.displayHeight - Ch.border_bottom;
        int i = 0;
        while (i < vgrid_yString.size()) {
            String numAxisLabel = (String)vgrid_yString.elementAt(i);
            int string_width = this.fontmet.stringWidth(numAxisLabel);
            int string_width_half = string_width / 2;
            long grid_y_coordinate = ((Double)vgrid_y_raster.elementAt(i)).longValue();
            if (test) {
                System.out.println("drawBuffer: " + i + " " + numAxisLabel + " " + grid_y_coordinate);
            }
            String label = i == vgrid_yString.size() - 1 && (this.numAxisD.getPrefix().length() > 0 || this.numAxisD.getSuffix().length() > 0) ? this.numAxisD.getPrefix() + numAxisLabel + this.numAxisD.getSuffix() : numAxisLabel;
            string_width = this.fontmet.stringWidth(label);
            string_width_half = string_width / 2;
            long x_loc = (long)Ch.border_left + grid_y_coordinate;
            x_loc = grid_y_coordinate;
            int y_loc = real_y_offset + labelHeight;
            g2.drawString(label, (float)(x_loc - (long)string_width_half), (float)y_loc);
            ++i;
        }
        int lastIndex = vgrid_yString.size() - 1;
        int leftmost_grid_x = ((Double)vgrid_y_raster.elementAt(0)).intValue();
        int rightmost_grid_x = ((Double)vgrid_y_raster.elementAt(lastIndex)).intValue();
        g2.drawLine(leftmost_grid_x, real_y_offset, rightmost_grid_x, real_y_offset);
        Double minValueD = (Double)vgrid_y.elementAt(0);
        Double maxValueD = (Double)vgrid_y.elementAt(lastIndex);
        double minValue = minValueD;
        double maxValue = maxValueD;
        if (!Ch.vertical) {
            if (minValue >= 0.0) {
                g2.drawLine(leftmost_grid_x, real_y_offset, leftmost_grid_x, Ch.border_top);
            } else if (maxValue <= 0.0) {
                g2.drawLine(rightmost_grid_x, real_y_offset, rightmost_grid_x, Ch.border_top);
            } else {
                g2.drawLine(yBaseline, real_y_offset, yBaseline, Ch.border_top);
            }
        }
    }
}

