/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.dtd.parser;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import oracle.jdevimpl.xml.dtd.parser.ParserError;
import oracle.jdevimpl.xml.dtd.parser.XMLReader;
import org.xml.sax.SAXException;

class XMLOutputStream {
    public static int DEFAULT = 0;
    public static int PRETTY = 1;
    public static int COMPACT = 2;
    static final int UTF8 = 1;
    static final int ASCII = 2;
    static final int UCS2_LE = 3;
    static final int UCS2_BE = 4;
    static final int UCS4_LE = 5;
    static final int UCS4_BE = 6;
    static final int OUTPUTSW = 7;
    static final int BUFSIZE = 16384;
    private Writer outWriter;
    private OutputStream outStream;
    char[] charBuffer;
    int charIndex;
    byte[] byteBuffer;
    int byteIndex;
    private boolean localErr;
    ParserError err;
    private int wrtstate;
    private int indent;
    int outstyle;
    boolean mixed;
    private char[] nlChars;

    public XMLOutputStream(OutputStream outputstream) {
        this.outStream = outputstream;
        this.outstyle = PRETTY;
        this.mixed = false;
        this.indent = 0;
        String s = System.getProperty("line.separator");
        this.nlChars = s.toCharArray();
        this.wrtstate = 1;
        this.byteBuffer = new byte[16384];
    }

    public XMLOutputStream(PrintWriter printwriter) {
        this.outWriter = printwriter;
        this.outstyle = PRETTY;
        this.mixed = false;
        this.indent = 0;
        String s = System.getProperty("line.separator");
        this.nlChars = s.toCharArray();
        this.wrtstate = 7;
        this.charBuffer = new char[16384];
    }

    public void addIndent(int i) {
        this.indent += i;
    }

    public void close() throws IOException {
        this.flush();
        try {
            if (this.localErr) {
                this.err.flushErrors();
            }
        }
        catch (SAXException xmlparseexception) {
            throw new IOException(xmlparseexception.getMessage());
        }
    }

    void finalFlush() throws IOException {
        if (this.outWriter != null) {
            this.outWriter.flush();
        }
    }

    public void flush() throws IOException {
        if (this.wrtstate == 7) {
            this.outWriter.write(this.charBuffer, 0, this.charIndex);
            this.charIndex = 0;
        } else {
            this.outStream.write(this.byteBuffer, 0, this.byteIndex);
            this.byteIndex = 0;
        }
    }

    public int getOutputStyle() {
        return this.outstyle;
    }

    void pop(int i) throws IOException {
        if (this.wrtstate == 7) {
            if (this.charIndex < i) {
                throw new IOException("Internal error while writing file");
            }
            this.charIndex -= i;
        } else {
            if (this.byteIndex < i) {
                throw new IOException("Internal error while writing file");
            }
            this.byteIndex -= i;
        }
    }

    public void setEncoding(String s, boolean flag, boolean flag1) throws IOException {
        if (this.outWriter != null) {
            return;
        }
        if (s.equalsIgnoreCase("ISO-10646-UCS-2") || s.equalsIgnoreCase("UCS-2") || s.equalsIgnoreCase("UTF-16")) {
            this.wrtstate = flag ? 3 : 4;
            if (flag1) {
                if (flag) {
                    this.byteBuffer[this.byteIndex] = -2;
                    this.byteBuffer[this.byteIndex + 1] = -1;
                    this.byteIndex += 2;
                } else {
                    this.byteBuffer[this.byteIndex] = -1;
                    this.byteBuffer[this.byteIndex + 1] = -2;
                    this.byteIndex += 2;
                }
            }
            return;
        }
        if (s.equalsIgnoreCase("ISO-10646-UCS-4") || s.equalsIgnoreCase("UCS-4")) {
            this.wrtstate = flag ? 5 : 6;
            return;
        }
        if (s.toUpperCase().equals("ASCII")) {
            this.wrtstate = 2;
            return;
        }
        if (s.toUpperCase().equals("UTF-8")) {
            this.wrtstate = 1;
            return;
        }
        boolean flag2 = false;
        String s1 = (String)XMLReader.encodingMap.get(s.toUpperCase());
        if (s1 != null) {
            try {
                this.outWriter = new OutputStreamWriter(this.outStream, s1);
            }
            catch (Exception _ex) {
                flag2 = true;
            }
        }
        if (flag2 || s1 == null) {
            flag2 = false;
            s1 = (String)XMLReader.encodingMap116.get(s.toUpperCase());
            if (s1 != null) {
                try {
                    this.outWriter = new OutputStreamWriter(this.outStream, s1);
                }
                catch (Exception _ex) {
                    flag2 = true;
                }
            }
        }
        if (flag2 || s1 == null) {
            String s2 = s;
            try {
                this.outWriter = new OutputStreamWriter(this.outStream, s2);
            }
            catch (Exception _ex) {
                if (this.err == null) {
                    this.localErr = true;
                    this.err = new ParserError();
                }
                throw new IOException(this.err.getMessage1(231, s));
            }
        }
        this.wrtstate = 7;
        this.charBuffer = new char[16384];
        this.byteBuffer = null;
    }

    public void setOutputStyle(int i) {
        this.outstyle = i;
    }

    public void write(int i) throws IOException {
        try {
            switch (this.wrtstate) {
                default: {
                    break;
                }
                case 1: {
                    if (i < 128) {
                        this.byteBuffer[this.byteIndex] = (byte)i;
                        ++this.byteIndex;
                        break;
                    }
                    this.writeUTF8Bytes(i);
                    break;
                }
                case 2: {
                    this.byteBuffer[this.byteIndex] = (byte)i;
                    ++this.byteIndex;
                    break;
                }
                case 3: {
                    int j = i >> 8;
                    int l = i & 0xFF;
                    this.byteBuffer[this.byteIndex] = (byte)j;
                    this.byteBuffer[this.byteIndex + 1] = (byte)l;
                    this.byteIndex += 2;
                    break;
                }
                case 4: {
                    int k = i >> 8;
                    int i1 = i & 0xFF;
                    this.byteBuffer[this.byteIndex] = (byte)i1;
                    this.byteBuffer[this.byteIndex + 1] = (byte)k;
                    this.byteIndex += 2;
                    break;
                }
                case 5: {
                    int j1 = i >> 24;
                    int l1 = i >> 16 & 0xFF;
                    int j2 = i >> 8 & 0xFF;
                    int l2 = i & 0xFF;
                    this.byteBuffer[this.byteIndex] = (byte)l2;
                    this.byteBuffer[this.byteIndex + 1] = (byte)j2;
                    this.byteBuffer[this.byteIndex + 2] = (byte)l1;
                    this.byteBuffer[this.byteIndex + 3] = (byte)j1;
                    this.byteIndex += 4;
                    break;
                }
                case 6: {
                    int k1 = i >> 24;
                    int i2 = i >> 16 & 0xFF;
                    int k2 = i >> 8 & 0xFF;
                    int i3 = i & 0xFF;
                    this.byteBuffer[this.byteIndex] = (byte)k1;
                    this.byteBuffer[this.byteIndex + 1] = (byte)i2;
                    this.byteBuffer[this.byteIndex + 2] = (byte)k2;
                    this.byteBuffer[this.byteIndex + 3] = (byte)i3;
                    this.byteIndex += 4;
                    break;
                }
                case 7: {
                    this.charBuffer[this.charIndex] = (char)i;
                    ++this.charIndex;
                    break;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException _ex) {
            this.flush();
            this.write(i);
        }
    }

    public void writeChars(String s) throws IOException {
        int i = s.length();
        if (i == 0) {
            return;
        }
        if (i == 1) {
            char c = s.charAt(0);
            if (c == '\n') {
                this.writeNewLineChars();
            } else {
                this.write(c);
            }
            return;
        }
        int j = 0;
        char c1 = s.charAt(j);
        while (true) {
            char c2 = s.charAt(j + 1);
            while (c2 == '\n') {
                if (c1 != '\r') {
                    this.write(c1);
                }
                this.writeNewLineChars();
                if ((j += 2) < i) {
                    if (j == i - 1) {
                        c1 = s.charAt(j);
                        if (c1 == '\n') {
                            this.writeNewLineChars();
                        } else {
                            this.write(c1);
                        }
                        return;
                    }
                    c1 = s.charAt(j);
                    c2 = s.charAt(j + 1);
                    continue;
                }
                return;
            }
            this.write(c1);
            c1 = c2;
            if (++j + 1 >= i) break;
            c2 = s.charAt(j + 1);
        }
        this.write(c1);
    }

    public void writeIndent() throws IOException {
        if (this.outstyle == PRETTY && !this.mixed) {
            for (int i = 0; i < this.indent; ++i) {
                this.writeChars("   ");
            }
        }
    }

    public void writeNewLine() throws IOException {
        if (this.outstyle == PRETTY && !this.mixed) {
            this.writeNewLineChars();
        }
    }

    void writeNewLineChars() throws IOException {
        int i = this.nlChars.length;
        for (int j = 0; j < i; ++j) {
            this.write(this.nlChars[j]);
        }
    }

    public void writeQuotedString(String s) throws IOException {
        char byte0 = '\"';
        if (s.indexOf(34) >= 0 && s.indexOf(39) < 0) {
            byte0 = '\'';
        }
        this.write(byte0);
        int i = s.length();
        for (int j = 0; j < i; ++j) {
            char c = s.charAt(j);
            if (c == byte0) {
                if (byte0 == '\"') {
                    this.writeChars("&quot;");
                    continue;
                }
                this.writeChars("&apos;");
                continue;
            }
            this.write(c);
        }
        this.write(byte0);
    }

    void writeUTF8Bytes(int i) throws IOException {
        if (i < 2048) {
            this.byteBuffer[this.byteIndex] = (byte)(0xC0 | i >> 6);
            this.byteBuffer[this.byteIndex + 1] = (byte)(0x80 | i & 0x3F);
            this.byteIndex += 2;
        } else if (i < 65536) {
            this.byteBuffer[this.byteIndex] = (byte)(0xE0 | i >> 12);
            this.byteBuffer[this.byteIndex + 1] = (byte)(0x80 | i >> 6 & 0x3F);
            this.byteBuffer[this.byteIndex + 2] = (byte)(0x80 | i & 0x3F);
            this.byteIndex += 3;
        } else {
            this.byteBuffer[this.byteIndex] = (byte)(0xF0 | i >> 18);
            this.byteBuffer[this.byteIndex + 1] = (byte)(0x80 | i >> 12 & 0x3F);
            this.byteBuffer[this.byteIndex + 2] = (byte)(0x80 | i >> 6 & 0x3F);
            this.byteBuffer[this.byteIndex + 3] = (byte)(0x80 | i & 0x3F);
            this.byteIndex += 4;
        }
    }
}

