/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.dtd.parser;

import java.io.IOException;
import oracle.jdeveloper.xml.dtd.grammar.Notation;
import oracle.jdevimpl.xml.dtd.parser.XMLOutputStream;

class XMLNotation
implements Notation {
    private String _mName;
    String url;
    String pubid;
    int ntype;
    int flags;

    public XMLNotation(String name) {
        this._mName = name;
    }

    public String getName() {
        return this._mName;
    }

    public short getNodeType() {
        return 12;
    }

    public String getPublicId() {
        return this.pubid;
    }

    public String getSystemId() {
        return this.url;
    }

    void print(XMLOutputStream xmloutputstream, boolean flag) throws IOException {
        if (flag == this.isNodeFlag(64)) {
            xmloutputstream.writeChars("<!NOTATION ");
            xmloutputstream.writeChars(this.getName() + " ");
            if (this.pubid != null) {
                xmloutputstream.writeChars(" PUBLIC ");
                xmloutputstream.writeQuotedString(this.pubid);
                xmloutputstream.writeChars(" ");
                if (this.url != null) {
                    xmloutputstream.writeQuotedString(this.url);
                }
            } else {
                xmloutputstream.writeChars(" SYSTEM ");
                xmloutputstream.writeQuotedString(this.url);
            }
            xmloutputstream.writeChars(">");
            xmloutputstream.writeNewLine();
            xmloutputstream.flush();
        }
    }

    public void setPublicId(String s) {
        this.pubid = s;
    }

    public void setSystemId(String s) {
        this.url = s;
    }

    public boolean isNodeFlag(int i) {
        return (this.flags & i) == i;
    }

    public void resetNodeFlag(int i) {
        this.flags &= ~i;
    }

    public void setNodeFlag(int i) {
        this.flags |= i;
    }
}

