/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.dtd.parser;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.jdevimpl.xml.dtd.parser.ParserErrorMsg;
import org.xml.sax.Locator;

public class BaseParserError {
    Locale eLocale;
    ResourceBundle messages;
    protected int[] line;
    protected int[] col;
    protected int[] types;
    protected int[] errid;
    protected String[] mesg;
    protected String[] sysId;
    protected String[] pubId;
    protected Exception[] exp;
    int nerrors = 0;
    int firsterr = -1;
    int lasterr = -1;
    boolean warning = false;
    boolean flushed = false;
    Locator locator;
    Exception lastExp;
    Writer out;
    char[] errID = new char[]{'M', 'S', 'G', '-', '0', '0', '0', '0'};
    static final int ERRIDLEN = 8;
    static String eFilename = "oracle.jdevimpl.xml.dtd.parser.ParserErrorMsg";

    void alloc() {
        if (this.eLocale == null) {
            this.eLocale = new Locale("en", "US");
        }
        if (this.messages == null) {
            this.getMessageBundle();
        }
    }

    public void error(int i, int j, String s, int lineno, int colno) {
        if (this.mesg == null) {
            this.init();
        }
        if (this.nerrors == 1000) {
            return;
        }
        if (j == 2) {
            if (!this.warning) {
                return;
            }
            if (this.lasterr == -1 && this.nerrors == 999) {
                return;
            }
        } else {
            if (this.firsterr == -1) {
                this.firsterr = this.nerrors;
            }
            this.lasterr = this.nerrors;
        }
        if (this.locator != null) {
            this.line[this.nerrors] = lineno;
            this.col[this.nerrors] = colno;
            this.pubId[this.nerrors] = this.locator.getPublicId();
            this.sysId[this.nerrors] = this.locator.getSystemId();
        }
        this.mesg[this.nerrors] = s;
        this.errid[this.nerrors] = i;
        this.types[this.nerrors] = j;
        if (this.lastExp != null) {
            this.exp[this.nerrors] = this.lastExp;
            this.lastExp = null;
        }
        ++this.nerrors;
    }

    public void error(int i, int j, String s) {
        if (this.mesg == null) {
            this.init();
        }
        if (this.nerrors == 1000) {
            return;
        }
        if (j == 2) {
            if (!this.warning) {
                return;
            }
            if (this.lasterr == -1 && this.nerrors == 999) {
                return;
            }
        } else {
            if (this.firsterr == -1) {
                this.firsterr = this.nerrors;
            }
            this.lasterr = this.nerrors;
        }
        if (this.locator != null) {
            this.line[this.nerrors] = this.locator.getLineNumber();
            this.col[this.nerrors] = this.locator.getColumnNumber();
            this.pubId[this.nerrors] = this.locator.getPublicId();
            this.sysId[this.nerrors] = this.locator.getSystemId();
        }
        this.mesg[this.nerrors] = s;
        this.errid[this.nerrors] = i;
        this.types[this.nerrors] = j;
        if (this.lastExp != null) {
            this.exp[this.nerrors] = this.lastExp;
            this.lastExp = null;
        }
        ++this.nerrors;
    }

    public void error(int i, int j, String[] as) {
        this.error(i, j, this.getMessage(i, as));
    }

    public void error0(int i, int j) {
        this.error(i, j, this.getMessage0(i));
    }

    public void error1(int i, int j, String s) {
        this.error(i, j, this.getMessage1(i, s));
    }

    public void error1(int i, int j, String s, int lineno, int colno) {
        this.error(i, j, this.getMessage1(i, s), lineno, colno);
    }

    public void error2(int i, int j, String s, String s1) {
        this.error(i, j, this.getMessage2(i, s, s1));
    }

    public void error3(int i, int j, String s, String s1, String s2) {
        this.error(i, j, this.getMessage3(i, s, s1, s2));
    }

    public void flushErrorStream() throws IOException {
        if (this.nerrors == 0 || this.flushed) {
            return;
        }
        this.flushed = true;
        if (this.out != null) {
            for (int i = 0; i < this.nerrors; ++i) {
                this.out.write(System.getProperty("line.separator"));
                this.out.write(this.formatErrorMesg(i));
            }
            this.out.write(System.getProperty("line.separator"));
            this.out.flush();
        }
    }

    public String formatErrorMesg(int i) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append(this.mesg[i]);
        return stringbuffer.toString();
    }

    public int getColumnNumber(int i) {
        return this.col[i];
    }

    public int getColumnNumber() {
        return this.locator != null ? this.locator.getColumnNumber() : 0;
    }

    public Exception getException(int i) {
        return this.exp[i];
    }

    public int getFirstError() {
        return this.firsterr;
    }

    public int getLineNumber(int i) {
        return this.line[i];
    }

    public int getLineNumber() {
        return this.locator != null ? this.locator.getLineNumber() : 0;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public String getMessage(int i) {
        return this.mesg[i];
    }

    public String getMessage(int i, String[] as) {
        this.alloc();
        String s = this.idToString(i);
        String s1 = MessageFormat.format(this.messages.getString(s), as);
        return s1;
    }

    public String getMessage0(int i) {
        this.alloc();
        String s = this.idToString(i);
        return this.messages.getString(s);
    }

    public String getMessage1(int i, String s) {
        this.alloc();
        String s1 = this.idToString(i);
        Object[] as = new String[]{s};
        String s2 = MessageFormat.format(this.messages.getString(s1), as);
        return s2;
    }

    public String getMessage2(int i, String s, String s1) {
        this.alloc();
        String s2 = this.idToString(i);
        Object[] as = new String[]{s, s1};
        String s3 = MessageFormat.format(this.messages.getString(s2), as);
        return s3;
    }

    public String getMessage3(int i, String s, String s1, String s2) {
        this.alloc();
        String s3 = this.idToString(i);
        Object[] as = new String[]{s, s1, s2};
        String s4 = MessageFormat.format(this.messages.getString(s3), as);
        return s4;
    }

    public String getMessage4(int i, String s, String s1, String s2, String s3) {
        this.alloc();
        String s4 = this.idToString(i);
        Object[] as = new String[]{s, s1, s2, s3};
        String s5 = MessageFormat.format(this.messages.getString(s4), as);
        return s5;
    }

    public String getMessage5(int i, String s, String s1, String s2, String s3, String s4) {
        this.alloc();
        String s5 = this.idToString(i);
        Object[] as = new String[]{s, s1, s2, s3, s4};
        String s6 = MessageFormat.format(this.messages.getString(s5), as);
        return s6;
    }

    void getMessageBundle() {
        if (eFilename != null) {
            try {
                this.messages = ResourceBundle.getBundle(eFilename, this.eLocale);
            }
            catch (Exception _ex) {
                this.messages = new ParserErrorMsg();
            }
        } else {
            this.messages = new ParserErrorMsg();
        }
    }

    public int getMessageType(int i) {
        return this.types[i];
    }

    public int getNumMessages() {
        return this.nerrors;
    }

    public String getPublicId(int i) {
        return this.pubId[i];
    }

    public String getSystemId(int i) {
        return this.sysId[i];
    }

    String idToString(int i) {
        this.errID[0] = 77;
        this.errID[1] = 83;
        this.errID[2] = 71;
        for (int j = 1; j < 5; ++j) {
            this.errID[8 - j] = (char)(i % 10 + 48);
            i /= 10;
        }
        return new String(this.errID);
    }

    private void init() {
        this.line = new int[1001];
        this.col = new int[1001];
        this.types = new int[1001];
        this.errid = new int[1001];
        this.mesg = new String[1001];
        this.sysId = new String[1001];
        this.pubId = new String[1001];
        this.exp = new Exception[1001];
    }

    public void printErrorListener() throws IOException {
        if (this.nerrors == 0) {
            return;
        }
        this.flushed = true;
        if (this.out != null) {
            for (int i = 0; i < this.nerrors; ++i) {
                this.out.write(System.getProperty("line.separator"));
                this.out.write(this.formatErrorMesg(i));
            }
            this.out.write(System.getProperty("line.separator"));
            this.out.flush();
        }
    }

    public void reset() {
        this.lastExp = null;
        this.nerrors = 0;
        this.firsterr = -1;
        this.lasterr = -1;
        this.flushed = false;
    }

    public void setErrorStream(OutputStream outputstream) {
        this.out = new OutputStreamWriter(outputstream);
    }

    public void setErrorStream(OutputStream outputstream, String s) throws IOException {
        this.out = new OutputStreamWriter(outputstream, s);
    }

    public void setErrorStream(PrintWriter printwriter) {
        this.out = printwriter;
    }

    public void setException(Exception exception) {
        this.lastExp = exception;
    }

    public void setLocale(Locale locale) {
        this.eLocale = locale;
        this.getMessageBundle();
    }

    public void setLocator(Locator locator) {
        this.locator = locator;
    }

    public void showWarnings(boolean flag) {
        this.warning = flag;
    }

    public Writer getErrorStream() {
        return this.out;
    }

    String typeToString(int i) {
        switch (i) {
            case 0: {
                return this.getMessage0(1);
            }
            case 1: {
                return this.getMessage0(2);
            }
            case 2: {
                return this.getMessage0(3);
            }
        }
        return "";
    }
}

