/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.xml.dtd.grammar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import oracle.bali.xml.grammar.Annotation;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.Particle;
import oracle.jdeveloper.xml.dtd.grammar.DtdElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DtdContentGroup
implements ContentGroup {
    private int _variety = 9;
    private LinkedList<GrammarComponent> _components;
    private LinkedList<GrammarComponent> _explodedComponents;
    private boolean _extendedToAllowText;
    private Set<GrammarComponent> _includedElements;
    private Set<GrammarComponent> _excludedElements;
    private int _min = 0;
    private int _max = 1;

    public DtdContentGroup(int variety) {
        this._variety = variety;
    }

    @Override
    public final String getName() {
        return null;
    }

    @Override
    public final Annotation getAnnotation() {
        return null;
    }

    @Override
    public String getTargetNamespace() {
        return null;
    }

    @Override
    public int getMinOccurs() {
        return this._min;
    }

    @Override
    public int getMaxOccurs() {
        return this._max;
    }

    @Override
    public boolean isReference() {
        return false;
    }

    @Override
    public ContentGroup getReferencedContentGroup() {
        return null;
    }

    @Override
    public Collection getComponents() {
        if (this._components == null) {
            return Collections.EMPTY_LIST;
        }
        this._explodeComponents();
        return this._explodedComponents;
    }

    @Override
    public int getVariety() {
        return this._variety;
    }

    public void setOccurs(int min, int max) {
        this._min = min;
        this._max = max;
    }

    public void includeElements(Collection<GrammarComponent> elements) {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        if (this._includedElements == null) {
            this._includedElements = new HashSet<GrammarComponent>();
        }
        boolean added = this._includedElements.addAll(elements);
        if (this._excludedElements != null) {
            this._includedElements.removeAll(this._excludedElements);
        }
        if (added) {
            ArrayList contentElements = new ArrayList();
            DtdContentGroup._collectElements(this, contentElements);
            for (int i = 0; i < contentElements.size(); ++i) {
                ElementDef element = (ElementDef)contentElements.get(i);
                if (element.isReference()) {
                    element = element.getReferencedElementDef();
                }
                if (!(element instanceof DtdElement)) continue;
                DtdElement dtdElement = (DtdElement)element;
                dtdElement.includeElements(this._includedElements);
            }
        }
    }

    private static void _collectElements(DtdContentGroup group, Collection elements) {
        if (group == null || group._components == null) {
            return;
        }
        for (GrammarComponent component : group._components) {
            if (component instanceof ElementDef) {
                ElementDef element = (ElementDef)component;
                if (element.isReference()) {
                    element = element.getReferencedElementDef();
                }
                elements.add(element);
                continue;
            }
            if (!(component instanceof DtdContentGroup)) continue;
            DtdContentGroup._collectElements((DtdContentGroup)component, elements);
        }
    }

    public void excludeElements(List<GrammarComponent> elements) {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        if (this._excludedElements == null) {
            this._excludedElements = new HashSet<GrammarComponent>();
        }
        this._excludedElements.addAll(elements);
        if (this._includedElements != null) {
            this._includedElements.removeAll(this._excludedElements);
        }
        if (this._components == null || this._components.isEmpty()) {
            return;
        }
        ListIterator iter = this._components.listIterator();
        while (iter.hasNext()) {
            GrammarComponent component = (GrammarComponent)iter.next();
            if (component instanceof DtdContentGroup) {
                DtdContentGroup group = (DtdContentGroup)component;
                group.excludeElements(elements);
                if (group.getComponents().size() != 0) continue;
                iter.remove();
                continue;
            }
            if (!elements.contains(component)) continue;
            iter.remove();
        }
    }

    public void addComponent(GrammarComponent component) {
        if (this._components == null) {
            this._components = new LinkedList();
        }
        this._components.add(component);
    }

    public CharSequence asText() {
        StringBuffer buffer = new StringBuffer();
        LinkedList<GrammarComponent> components = this._components;
        if (components.size() == 1) {
            GrammarComponent next = (GrammarComponent)components.iterator().next();
            buffer.append(DtdContentGroup.toString(next));
        } else if (components.size() > 1) {
            Iterator elements = components.iterator();
            buffer.append("(");
            boolean first = true;
            while (elements.hasNext()) {
                if (!first) {
                    switch (this._variety) {
                        case 7: {
                            buffer.append(" & ");
                            break;
                        }
                        case 8: {
                            buffer.append(" | ");
                            break;
                        }
                        case 9: {
                            buffer.append(" , ");
                            break;
                        }
                        default: {
                            buffer.append(" ");
                        }
                    }
                }
                GrammarComponent next = (GrammarComponent)elements.next();
                buffer.append(DtdContentGroup.toString(next));
                first = false;
            }
            buffer.append(")");
        }
        buffer.append(DtdContentGroup.getOccursString(this));
        return buffer;
    }

    private static String toString(GrammarComponent gc) {
        if (gc instanceof ElementDef) {
            ElementDef e = (ElementDef)gc;
            if (e.isReference()) {
                return gc.getName() + DtdContentGroup.getOccursString(e);
            }
            return gc.getName();
        }
        return gc.toString();
    }

    private static String getOccursString(Particle p) {
        if (p.getMinOccurs() == 0) {
            if (p.getMaxOccurs() == 1) {
                return "?";
            }
            return "*";
        }
        if (p.getMinOccurs() == 1 && p.getMaxOccurs() == -1) {
            return "+";
        }
        return "";
    }

    public String toString() {
        return this.asText().toString();
    }

    boolean extendedToAllowText() {
        this._explodeComponents();
        return this._extendedToAllowText;
    }

    private synchronized void _explodeComponents() {
        if (this._components == null || this._explodedComponents != null) {
            return;
        }
        this._explodedComponents = new LinkedList<GrammarComponent>(this._components);
        int contentLength = this._explodedComponents.size();
        for (int i = 0; i < contentLength; ++i) {
            GrammarComponent currentComponent = this._explodedComponents.get(i);
            if (!(currentComponent instanceof ElementDef)) continue;
            ElementDef elementDef = (ElementDef)currentComponent;
            int minOccurs = elementDef.getMinOccurs();
            int maxOccurs = elementDef.getMaxOccurs();
            if (elementDef.isReference()) {
                elementDef = elementDef.getReferencedElementDef();
            }
            if (!(elementDef instanceof DtdElement) || !(elementDef.getType() instanceof ComplexType)) continue;
            DtdElement dtdElementDef = (DtdElement)elementDef;
            ComplexType dtdType = (ComplexType)dtdElementDef.getType();
            if (dtdElementDef.isStartTagRequired() || dtdElementDef.isEndTagRequired()) continue;
            if (dtdType.getVariety() == 5 || dtdType.getVariety() == 4) {
                this._extendedToAllowText = true;
            }
            DtdContentGroup explodedGroup = new DtdContentGroup(8);
            explodedGroup.setOccurs(minOccurs, maxOccurs);
            explodedGroup.addComponent(currentComponent);
            explodedGroup.addComponent(dtdType.getContentGroup());
            explodedGroup._explodedComponents = explodedGroup._components;
            this._explodedComponents.set(i, explodedGroup);
        }
        if (this._includedElements != null && !this._includedElements.isEmpty()) {
            DtdContentGroup includeGroup = new DtdContentGroup(7);
            includeGroup.setOccurs(0, -1);
            Iterator<GrammarComponent> extraEl = this._includedElements.iterator();
            while (extraEl.hasNext()) {
                includeGroup.addComponent(extraEl.next());
            }
            DtdContentGroup innerContentGroup = new DtdContentGroup(this._variety);
            innerContentGroup.setOccurs(this.getMinOccurs(), this.getMaxOccurs());
            innerContentGroup._components = this._components;
            innerContentGroup._explodedComponents = this._explodedComponents;
            this._components = new LinkedList();
            this._components.add(innerContentGroup);
            this._explodedComponents = new LinkedList();
            this._explodedComponents.add(innerContentGroup);
            this._explodedComponents.add(includeGroup);
            this.setOccurs(0, 1);
            this._variety = 7;
        }
    }
}

