/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLParseException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLUtils {
    public static RootElementPacket getXMLRootElement(URL url) throws XMLParseException, SAXException, IOException {
        return XMLUtils.getXMLRootElementImpl(url);
    }

    public static String getTargetNamespace(URL url) throws XMLParseException, SAXException, IOException {
        RootElementPacket root = XMLUtils.getXMLRootElement(url);
        if (root != null && root.attributes != null) {
            return root.attributes.getValue("namespace");
        }
        return null;
    }

    private static RootElementPacket getXMLRootElementImpl(URL url) throws XMLParseException, SAXException, IOException {
        SAXParser saxParser = new SAXParser();
        saxParser.setValidationMode(0);
        RootElementHandler handler = new RootElementHandler();
        saxParser.setContentHandler((ContentHandler)handler);
        saxParser.setEntityResolver((EntityResolver)handler);
        try {
            saxParser.parse(url);
        }
        catch (SAXParserDoneException sAXParserDoneException) {
            // empty catch block
        }
        RootElementPacket rootElement = handler.getRootElement();
        return rootElement;
    }

    public static class SAXParserDoneException
    extends SAXException {
        public SAXParserDoneException() {
            this("SAX parsing done.");
        }

        public SAXParserDoneException(Exception e) {
            super(e);
        }

        public SAXParserDoneException(String message) {
            super(message);
        }

        public SAXParserDoneException(String message, Exception e) {
            super(message, e);
        }
    }

    public static final class RootElementPacket {
        public final String namespaceURI;
        public final String localName;
        public final String qName;
        public final Attributes attributes;
        public final String publicId;
        public final String systemId;

        RootElementPacket(String namespaceURI, String localName, String qName, Attributes attributes, String publicId, String systemId) {
            this.namespaceURI = namespaceURI;
            this.localName = localName;
            this.qName = qName;
            this.attributes = attributes;
            this.publicId = publicId;
            this.systemId = systemId;
        }
    }

    public static class RootElementHandler
    extends DefaultHandler {
        private RootElementPacket _rootElement = null;
        private String _publicId;
        private String _systemId;

        public RootElementPacket getRootElement() {
            return this._rootElement;
        }

        public String getPublicId() {
            return this._publicId;
        }

        public String getSystemId() {
            return this._systemId;
        }

        public void startElement(String nsURI, String localName, String qName, Attributes attributes) throws SAXException {
            this._rootElement = new RootElementPacket(nsURI, localName, qName, attributes, this._publicId, this._systemId);
            throw new SAXParserDoneException();
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            if (this._publicId == null && this._systemId == null) {
                this._publicId = publicId;
                this._systemId = systemId;
            }
            InputSource inputSource = new InputSource();
            inputSource.setByteStream(new ByteArrayInputStream(new byte[0]));
            return inputSource;
        }
    }
}

