/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlPackageHintUtils {
    private static ConcurrentHashMap<String, Set<ClassLoader>> _hints = new ConcurrentHashMap();

    public static void addHint(String packageHint, ClassLoader loader) {
        Set<ClassLoader> loaders = _hints.get(packageHint);
        if (loaders == null) {
            loaders = new HashSet<ClassLoader>();
        }
        loaders.add(loader);
        _hints.put(packageHint, loaders);
    }

    public static Set<ClassLoader> getClassLoaders(String className) {
        LinkedHashSet<ClassLoader> loaders = new LinkedHashSet<ClassLoader>();
        if (className == null || !className.contains(".")) {
            return loaders;
        }
        String packageHint = className;
        int lastIndex = packageHint.lastIndexOf(".");
        while (lastIndex != -1) {
            packageHint = className.substring(0, lastIndex);
            if (_hints.containsKey(packageHint)) {
                loaders.addAll((Collection<ClassLoader>)_hints.get(packageHint));
            }
            lastIndex = packageHint.lastIndexOf(".");
        }
        return loaders;
    }

    private XmlPackageHintUtils() {
    }
}

