/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.structured;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.structured.StructuredMetadataBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableStructuredMetadataBean
extends StructuredMetadataBean {
    private Map<QualifiedName, String> _propertyMap = null;
    private Map<QualifiedName, Object> _hintMap = null;
    private List<StructuredMetadataBean> _children = null;

    public MutableStructuredMetadataBean(QualifiedName name) {
        super(name);
    }

    public MutableStructuredMetadataBean(String namespace, String localName) {
        this(QualifiedName.getQualifiedName(namespace, localName));
    }

    @Override
    public Map<QualifiedName, String> getProperties() {
        if (this._propertyMap == null) {
            return Collections.emptyMap();
        }
        return this._propertyMap;
    }

    public final void addProperty(String propertyNamespace, String propertyLocalName, String value) {
        QualifiedName propertyName = QualifiedName.getQualifiedName(propertyNamespace, propertyLocalName);
        this.addProperty(propertyName, value);
    }

    public void addProperty(QualifiedName propertyName, String value) {
        if (this._propertyMap == null) {
            this._propertyMap = new LinkedHashMap<QualifiedName, String>();
        }
        this._propertyMap.put(propertyName, value);
    }

    @Override
    public Map<QualifiedName, Object> getHints() {
        if (this._hintMap == null) {
            return Collections.emptyMap();
        }
        return this._hintMap;
    }

    public final void addHint(String hintNamespace, String hintLocalName, Object value) {
        QualifiedName hintName = QualifiedName.getQualifiedName(hintNamespace, hintLocalName);
        this.addHint(hintName, value);
    }

    public void addHint(QualifiedName hintName, Object value) {
        if (this._hintMap == null) {
            this._hintMap = new LinkedHashMap<QualifiedName, Object>();
        }
        this._hintMap.put(hintName, value);
    }

    public void setValue(String value) {
        this.addProperty(VALUE_PROPERTY, value);
    }

    public void setOwnerNS(XmlKey ownerNS) {
        this.addHint(OWNER_NS_PROPERTY, ownerNS);
    }

    @Override
    public List<StructuredMetadataBean> getChildren() {
        if (this._children == null) {
            return Collections.emptyList();
        }
        return this._children;
    }

    public void addChild(StructuredMetadataBean child) {
        if (child != null) {
            if (this._children == null) {
                this._children = new ArrayList<StructuredMetadataBean>();
            }
            this._children.add(child);
        }
    }
}

