/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.el.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import oracle.bali.xml.metadata.el.ELException;
import oracle.bali.xml.metadata.el.VariableResolver;
import oracle.bali.xml.metadata.el.impl.ASTOperand;
import oracle.bali.xml.metadata.el.impl.ASTUnaryOperator;
import oracle.bali.xml.metadata.el.impl.PrimitiveTypes;

final class ASTUnaryMinus
extends ASTUnaryOperator {
    private static final ASTUnaryMinus _sInstance = new ASTUnaryMinus();

    public Object apply(VariableResolver vResolver, ASTOperand operand) throws ELException {
        Object result = operand.getValue(vResolver);
        if (result == null) {
            return PrimitiveTypes.getLong(0L);
        }
        Class<Object> resultClass = result.getClass();
        try {
            if (String.class.equals(resultClass)) {
                String str = (String)result;
                if (str.indexOf(46) != -1 || str.indexOf(101) != -1 || str.indexOf(69) != -1) {
                    result = Double.valueOf(str);
                    resultClass = Double.class;
                } else {
                    result = Long.valueOf(str);
                    resultClass = Long.class;
                }
            }
            if (BigDecimal.class.equals(resultClass)) {
                return ((BigDecimal)result).negate();
            }
            if (BigInteger.class.equals(resultClass)) {
                return ((BigInteger)result).negate();
            }
            if (Byte.class.equals(resultClass)) {
                return PrimitiveTypes.getByte(-((Byte)result).byteValue());
            }
            if (Short.class.equals(resultClass)) {
                return PrimitiveTypes.getShort(-((Short)result).shortValue());
            }
            if (Integer.class.equals(resultClass)) {
                return PrimitiveTypes.getInteger(-((Integer)result).intValue());
            }
            if (Long.class.equals(resultClass)) {
                return PrimitiveTypes.getLong(-((Long)result).longValue());
            }
            if (Float.class.equals(resultClass)) {
                return PrimitiveTypes.getFloat(-((Float)result).floatValue());
            }
            if (Double.class.equals(resultClass)) {
                return PrimitiveTypes.getDouble(-((Double)result).doubleValue());
            }
            throw new NumberFormatException("Unable to negate " + result);
        }
        catch (NumberFormatException e) {
            throw new ELException(e);
        }
    }

    public Class getType(VariableResolver vResolver, ASTOperand operand) throws ELException {
        return Number.class;
    }

    public void toString(StringBuffer buffer, ASTOperand operand) {
        buffer.append("-");
        operand.toString(buffer);
    }

    public static ASTUnaryMinus sharedInstance() {
        return _sInstance;
    }

    private ASTUnaryMinus() {
    }
}

