/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.schema;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.GrammarProviderEvent;
import oracle.bali.xml.grammar.LayeredGrammarProvider;
import oracle.bali.xml.grammar.schema.OracleSchema;
import oracle.bali.xml.grammar.schema.OracleSchemaFactory;
import oracle.bali.xml.util.NullKeyConcurrentHashMapDecorator;
import org.xml.sax.EntityResolver;

public class SchemaGrammarProvider
extends LayeredGrammarProvider {
    private OracleSchemaFactory _schemaFactory;
    private Map<String, Grammar> _grammarMap = new NullKeyConcurrentHashMapDecorator<String, Grammar>(new ConcurrentHashMap(13), "#NULL#KEY#REPLACEMENT#VALUE");
    private EntityResolver _resolver;
    private static Logger _logger;
    private static final String _NULL_KEY_REPLACEMENT_VALUE = "#NULL#KEY#REPLACEMENT#VALUE";
    private static final String _ERROR_UNEXPECTED_CONFLICT = "A different Grammar with the same targetNamespace has already been returned by the OracleSchemaFactory instance";

    public SchemaGrammarProvider() {
        this(null, null);
    }

    public SchemaGrammarProvider(GrammarProvider base) {
        this(base, null);
    }

    public SchemaGrammarProvider(EntityResolver resolver) {
        this(null, resolver);
    }

    public SchemaGrammarProvider(GrammarProvider base, EntityResolver resolver) {
        super(base);
        this._resolver = resolver;
    }

    public Set addSchema(URL schemaLocation) throws GrammarException {
        return this.addSchema(schemaLocation, false);
    }

    public Set addSchema(URL schemaLocation, boolean useEntityResolverForRoot) throws GrammarException {
        Set addedGrammars = Collections.EMPTY_SET;
        OracleSchema[] gArr = this._getSchemaFactory().buildSchemas(schemaLocation, useEntityResolverForRoot);
        if (gArr != null) {
            List<OracleSchema> newGrammars = Arrays.asList(gArr);
            addedGrammars = this._addGrammars(new LinkedHashSet<OracleSchema>(newGrammars));
        }
        return addedGrammars;
    }

    public void clearSchemas() {
        HashSet<Grammar> removedGrammarSet = new HashSet<Grammar>(this._grammarMap.values());
        this._grammarMap.clear();
        this._clearSchemaFactory();
        this.fireEvent(Collections.EMPTY_SET, removedGrammarSet, Collections.EMPTY_SET);
    }

    public void setEntityResolver(EntityResolver resolver) {
        this._resolver = resolver;
    }

    protected Map getLayerGrammarMap() {
        return this._grammarMap;
    }

    private Set _addGrammars(Set grammars) throws GrammarException {
        Iterator iter = grammars.iterator();
        GrammarProviderEvent event = this.createEvent();
        while (iter.hasNext()) {
            Grammar grammar = (Grammar)iter.next();
            String targetNamespace = grammar.getTargetNamespace();
            Grammar previousGrammar = this._grammarMap.get(targetNamespace);
            if (previousGrammar == null) {
                this._grammarMap.put(targetNamespace, grammar);
                event.notifyGrammarAdded(grammar);
                continue;
            }
            if (previousGrammar == grammar) continue;
            SchemaGrammarProvider._getLogger().log(Level.SEVERE, _ERROR_UNEXPECTED_CONFLICT);
        }
        if (event.hasGrammarsAdded()) {
            this.fireEvent(event);
        }
        return event.getGrammarsAdded();
    }

    private synchronized OracleSchemaFactory _getSchemaFactory() {
        if (this._schemaFactory == null) {
            this._schemaFactory = new OracleSchemaFactory(this._resolver);
        }
        return this._schemaFactory;
    }

    private synchronized void _clearSchemaFactory() {
        if (this._schemaFactory != null) {
            this._schemaFactory.clearCache();
            this._schemaFactory = null;
        }
    }

    private static Logger _getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("oracle.bali.xml.grammar");
        }
        return _logger;
    }
}

