/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.util.XmlNameUtils;

class IdentifierQualifiedName
extends QualifiedName {
    private final String _identifier;
    private static final long serialVersionUID = 1L;
    private static ConcurrentHashMap<String, IdentifierQualifiedName> _sQNameMap = new ConcurrentHashMap(57, 0.75f, 10);

    public static IdentifierQualifiedName getIdentifierQualifiedName(String namespace, String name, String identifier) {
        IdentifierQualifiedName newName;
        String key;
        IdentifierQualifiedName qName;
        StringBuffer buffer = new StringBuffer();
        if (namespace != null) {
            buffer.append(namespace);
        }
        buffer.append(":");
        if (name != null) {
            buffer.append(name);
        }
        buffer.append(":");
        if (identifier != null) {
            buffer.append(identifier);
        }
        if ((qName = _sQNameMap.get(key = buffer.toString())) == null && (qName = _sQNameMap.putIfAbsent(key, newName = new IdentifierQualifiedName(namespace, name, identifier))) == null) {
            qName = newName;
        }
        return qName;
    }

    public String getIdentifier() {
        return this._identifier;
    }

    public boolean isVariation() {
        return true;
    }

    private IdentifierQualifiedName(String namespace, String name, String identifier) {
        super(namespace, name);
        XmlNameUtils.validateName(identifier);
        this._identifier = identifier;
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private Object writeReplace() {
        return new IdentifierQualifiedNameSerializationProxy(this);
    }

    private static class IdentifierQualifiedNameSerializationProxy
    implements Serializable {
        private final String _namespace;
        private final String _localName;
        private final String _identifier;
        private static final long serialVersionUID = 1L;

        IdentifierQualifiedNameSerializationProxy(IdentifierQualifiedName qName) {
            this._namespace = qName.getNamespace();
            this._localName = qName.getName();
            this._identifier = qName.getIdentifier();
        }

        private Object readResolve() {
            return IdentifierQualifiedName.getIdentifierQualifiedName(this._namespace, this._localName, this._identifier);
        }
    }
}

