/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.usages;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.raptor.usages.ServerLocation;
import oracle.dbtools.raptor.usages.ServerLocations;
import oracle.dbtools.raptor.usages.UsageClient;
import oracle.dbtools.util.Logger;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.FileEntity;

class FileSender {
    private static final FileSender _instance = new FileSender();
    private List<ServerLocation> _uploadServers;

    private FileSender() {
    }

    public static FileSender getInstance() {
        return _instance;
    }

    boolean logToServer(File ... fileArray) {
        boolean bl = false;
        if (fileArray != null && fileArray.length > 0) {
            try (UsageClient usageClient = UsageClient.createClient();){
                ContentType contentType = ContentType.create((String)"text/xml", (String)"UTF-8");
                FileEntity[] fileEntityArray = new FileEntity[fileArray.length];
                for (int i = 0; i < fileArray.length; ++i) {
                    fileEntityArray[i] = new FileEntity(fileArray[i], contentType);
                }
                List<ServerLocation> list = this.getUsageServers(usageClient);
                Iterator<ServerLocation> iterator = list.iterator();
                while (iterator.hasNext()) {
                    ServerLocation serverLocation = iterator.next();
                    for (FileEntity fileEntity : fileEntityArray) {
                        if (FileSender.sendEntity(fileEntity, usageClient, serverLocation)) continue;
                        iterator.remove();
                    }
                }
                bl = true;
            }
            catch (IOException iOException) {
                Logger.severe(FileSender.class, (Throwable)iOException);
            }
            catch (Exception exception) {
                Logger.severe(FileSender.class, (Throwable)exception);
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean sendEntity(FileEntity fileEntity, UsageClient usageClient, ServerLocation serverLocation) throws ClientProtocolException, IOException {
        HttpPost httpPost = new HttpPost(serverLocation.getUrl());
        httpPost.setEntity((HttpEntity)fileEntity);
        boolean bl = false;
        try (CloseableHttpResponse closeableHttpResponse = usageClient.executeRequest((HttpUriRequestBase)httpPost);){
            int n = closeableHttpResponse.getCode();
            String string = MessageFormat.format("Log to {0} : {1} {2}", serverLocation.getUrl(), n, closeableHttpResponse.getReasonPhrase());
            switch (n) {
                case 200: {
                    Logger.info(FileSender.class, (String)string);
                    bl = true;
                    return bl;
                }
                default: {
                    Logger.severe(FileSender.class, (String)string);
                    Logger.severe(FileSender.class, (String)closeableHttpResponse.getEntity().toString());
                    bl = false;
                    return bl;
                }
            }
        }
    }

    private List<ServerLocation> getUsageServers(UsageClient usageClient) {
        if (this._uploadServers == null || this._uploadServers.size() == 0) {
            this._uploadServers = new ArrayList<ServerLocation>(ServerLocations.getServers(usageClient));
        }
        return this._uploadServers;
    }
}

