/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.lang.reflect.Method;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.dbtools.logging.LogPaneHandler;
import oracle.dbtools.raptor.controls.UIDBAccessSafe;
import oracle.ide.Addin;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.driver.OracleLog;

public class MonitorJDBCAddin
implements Addin {
    public void initialize() {
        boolean bl = Boolean.getBoolean("oracle.dbtools.jdbc.logging");
        System.setProperty("oracle.jdbc.Trace", "true");
        boolean bl2 = OracleDriver.isDebug();
        if (bl2) {
            Logger logger = Logger.getLogger("oracle.jdbc");
            for (Handler handler : logger.getHandlers()) {
                logger.removeHandler(handler);
            }
            Logger logger2 = Logger.getLogger("oracle.sql");
            logger2.setUseParentHandlers(false);
            logger2.setLevel(Level.SEVERE);
            logger.setUseParentHandlers(false);
            logger.setLevel(OracleLog.TRACE_1);
            logger.addHandler(new JDBCEventHandler(bl));
        }
    }

    class JDBCEventHandler
    extends Handler {
        private AWTEvent _lastErrorEvent;
        private String _lastInterestingMsg;
        private boolean _reportAllInterestingMethods;
        private final boolean _logAllMessages;

        private JDBCEventHandler(boolean bl) {
            this._logAllMessages = bl;
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        @Override
        public void publish(LogRecord logRecord) {
            if (this._logAllMessages) {
                LogPaneHandler.getInstance().publish(logRecord);
            }
            AWTEvent aWTEvent = EventQueue.getCurrentEvent();
            if (EventQueue.isDispatchThread() && (this._reportAllInterestingMethods || aWTEvent != this._lastErrorEvent)) {
                StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                String string = null;
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                Object object = stackTraceElementArray;
                int n = ((StackTraceElement[])object).length;
                for (int i = 0; i < n; ++i) {
                    StackTraceElement stackTraceElement = object[i];
                    string = stackTraceElement.getClassName();
                    String string2 = stackTraceElement.getMethodName();
                    try {
                        for (Method method : Class.forName(string).getMethods()) {
                            if (!method.getName().equals(string2) || !method.isAnnotationPresent(UIDBAccessSafe.class)) continue;
                            bl = true;
                            break;
                        }
                    }
                    catch (SecurityException securityException) {
                        this.ignore(securityException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.ignore(classNotFoundException);
                    }
                    if (stringBuilder.length() != 0 || !string.startsWith("oracle.dbtools") || string.startsWith("oracle.dbtools.raptor.MonitorJDBCAddin") || string.startsWith("oracle.dbtools.db.DBUtil") || string.startsWith("oracle.dbtools.unit_test.utils.UtUtils")) continue;
                    stringBuilder.append("Move database action off the eventQueue: \n").append(this.idOf(aWTEvent)).append(':').append(string).append('.').append(stackTraceElement.getMethodName()).append('(').append(stackTraceElement.getLineNumber()).append(')');
                }
                if (!bl && !((String)(object = stringBuilder.toString())).equals(this._lastInterestingMsg)) {
                    this._lastInterestingMsg = object;
                    if (aWTEvent != this._lastErrorEvent) {
                        stringBuilder.append(" \n").append(aWTEvent.toString());
                        object = stringBuilder.toString();
                    }
                    this._lastErrorEvent = aWTEvent;
                    Logger.getLogger("oracle.dbtools.raptor").severe((String)object);
                    new Exception((String)object).printStackTrace();
                }
            }
        }

        private void ignore(Throwable throwable) {
            assert (throwable != null || null == throwable);
        }

        private String idOf(Object object) {
            return null == object ? null : object.getClass().getSimpleName() + "@" + Integer.toHexString(object.hashCode());
        }
    }
}

