/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webbrowser;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.webbrowser.BrowserArb;

final class AuthenticationPrompt
extends JPanel {
    private final MultiLineLabel hintLabel = new MultiLineLabel();
    private final JLabel userNameLabel = new JLabel();
    private final JLabel passwordLabel = new JLabel();
    private final JTextField userNameField = new JTextField(20);
    private final JPasswordField passwordField = new JPasswordField(20);
    private String host;
    private String prompt;
    private static final String HELP_ID = "f1_idedauthentication_html";

    public AuthenticationPrompt(String host, int port, String protocol, String prompt) {
        this.host = host;
        this.prompt = prompt;
        this.jbInit();
    }

    public String getUserName() {
        return this.userNameField.getText();
    }

    public char[] getPassword() {
        return this.passwordField.getPassword();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runDialog(Component parent) {
        int buttonMask;
        HelpSystem hs = HelpSystem.getHelpSystem();
        if (hs != null) {
            buttonMask = 7;
            hs.registerTopic((JComponent)this, HELP_ID);
        } else {
            buttonMask = 3;
        }
        JEWTDialog dialog = JEWTDialog.createDialog((Component)parent, (String)BrowserArb.getString(12), (int)buttonMask);
        dialog.setContent((Component)this);
        try {
            boolean bl = dialog.runDialog();
            return bl;
        }
        finally {
            dialog.dispose();
        }
    }

    private void jbInit() {
        String hint;
        MessageFormat hintFormat;
        ResourceUtils.resLabel((JLabel)this.userNameLabel, (Component)this.userNameField, (String)BrowserArb.getString(15));
        ResourceUtils.resLabel((JLabel)this.passwordLabel, (Component)this.passwordField, (String)BrowserArb.getString(16));
        if (this.prompt != null && this.prompt.trim().length() > 0) {
            hintFormat = new MessageFormat(BrowserArb.getString(14));
            hint = hintFormat.format(new Object[]{this.prompt.trim(), this.host});
        } else {
            hintFormat = new MessageFormat(BrowserArb.getString(13));
            hint = hintFormat.format(new Object[]{this.host});
        }
        this.hintLabel.setText(hint);
        this.hintLabel.setTextWrapper(WordWrapper.getTextWrapper());
        this.hintLabel.setPreferredAspectRatio(12.0f);
        this.hintLabel.setVerticalShrinking(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 15, 0);
        this.add((Component)this.hintLabel, gbc);
        ++gbc.gridy;
        gbc.gridwidth = -1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 5, 12);
        this.add((Component)this.userNameLabel, gbc);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.userNameField, gbc);
        ++gbc.gridy;
        gbc.gridwidth = -1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.passwordLabel, gbc);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.passwordField, gbc);
    }
}

