/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.samlp;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.saml.SAMLMessage;
import oracle.security.xmlsec.samlp.SAMLPUtils;
import oracle.security.xmlsec.util.GenericXMLElement;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class RequestType
extends SAMLMessage {
    public static final String ATTRIBUTE_STATEMENT = "AttributeStatement";
    public static final String AUTHENTICATION_STATEMENT = "AuthenticationStatement";
    public static final String AUTHORIZATION_DECISION_STATEMENT = "AuthorizationDecisionStatement";
    private static final String[] nsURIs = new String[]{"urn:oasis:names:tc:SAML:1.0:protocol", "http://www.w3.org/2000/09/xmldsig#"};
    private static final String[] localNames = new String[]{"RespondWith", "Signature"};
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 0;

    protected RequestType(Element element) throws DOMException {
        super(element);
    }

    protected RequestType(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    protected RequestType(Document owner, String uri, String localName) throws DOMException {
        super(owner, uri, localName);
        this.setVersion(1, 0);
    }

    public void setRequestID(String requestID) {
        this.setAttribute("RequestID", requestID);
    }

    public String getRequestID() {
        if (this.hasAttribute("RequestID")) {
            return this.getAttribute("RequestID");
        }
        return null;
    }

    public void setIssueInstant(Date issueInstant) {
        this.setAttribute("IssueInstant", XMLUtils.formatDateTime((Date)issueInstant));
    }

    public Date getIssueInstant() {
        if (this.hasAttribute("IssueInstant")) {
            return XMLUtils.parseDateTime((String)this.getAttribute("IssueInstant"));
        }
        return null;
    }

    public void addRespondWith(String localValue, String namespace) {
        String prefix = XMLElement.getDefaultNSPrefix((String)(namespace == null ? "urn:oasis:names:tc:SAML:1.0:assertion" : namespace));
        String qName = localValue;
        if (prefix != null && prefix.length() != 0) {
            qName = prefix + ":" + qName;
        }
        SAMLPUtils.insertChildElementWithText(this, "urn:oasis:names:tc:SAML:1.0:protocol", "RespondWith", nsURIs, localNames, qName, false);
    }

    public List getRespondWiths() {
        return SAMLPUtils.collectTextFromChildren(this, "urn:oasis:names:tc:SAML:1.0:protocol", "RespondWith");
    }

    public void addRespondWithValue(QName qname) {
        SAMLPUtils.insertChildElementWithQName(this, "urn:oasis:names:tc:SAML:1.0:protocol", "RespondWith", nsURIs, localNames, qname, false);
    }

    public List getRespondWithValues() {
        NodeList list = this.getChildElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:protocol", "RespondWith");
        ArrayList<QName> result = new ArrayList<QName>(list.getLength());
        int n = list.getLength();
        for (int i = 0; i < n; ++i) {
            Element elem = (Element)list.item(i);
            String value = XMLUtils.collectText((Node)elem);
            QName qName = QName.getInstance((String)value, (XMLElement)new GenericXMLElement(elem));
            result.add(qName);
        }
        return result;
    }

    @Override
    protected String[] getNSURIsPrecedeDSig() {
        return new String[]{"urn:oasis:names:tc:SAML:1.0:protocol"};
    }

    @Override
    protected String[] getLocalNamesPrecedeDSig() {
        return new String[]{"RespondWith"};
    }

    @Override
    protected String getID() {
        if (this.getMajorVersion() == 1 && this.getMinorVersion() == 0) {
            return null;
        }
        return this.getRequestID();
    }

    static {
        SAMLInitializer.initialize();
    }
}

