/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml;

import java.util.List;
import oracle.security.xmlsec.dsig.XSKeyInfo;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.saml.SAMLUtils;
import oracle.security.xmlsec.util.XMLElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SubjectConfirmation
extends XMLElement {
    private static final String[] nsURIs = new String[]{"urn:oasis:names:tc:SAML:1.0:assertion", "urn:oasis:names:tc:SAML:1.0:assertion", "http://www.w3.org/2000/09/xmldsig#"};
    private static final String[] localNames = new String[]{"ConfirmationMethod", "SubjectConfirmationData", "KeyInfo"};

    public SubjectConfirmation(Element element) throws DOMException {
        super(element);
    }

    public SubjectConfirmation(Element element, String SystemId) throws DOMException {
        super(element, SystemId);
    }

    public SubjectConfirmation(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmation");
    }

    public void addConfirmationMethod(String uri) {
        SAMLUtils.insertChildElementWithText(this, "urn:oasis:names:tc:SAML:1.0:assertion", "ConfirmationMethod", nsURIs, localNames, uri, false);
    }

    public List getConfirmationMethods() {
        return SAMLUtils.collectTextFromChildren(this, "urn:oasis:names:tc:SAML:1.0:assertion", "ConfirmationMethod");
    }

    public void setSubjectConfirmationData(String value) {
        SAMLUtils.insertChildElementWithText(this, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmationData", nsURIs, localNames, value, true);
    }

    public String getSubjectConfirmationData() {
        return SAMLUtils.collectTextFromChild(this, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmationData");
    }

    public void setKeyInfo(XSKeyInfo keyInfo) {
        String prefix = keyInfo.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            keyInfo.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
        } else {
            keyInfo.addNSPrefixAttr(prefix, "http://www.w3.org/2000/09/xmldsig#");
        }
        SAMLUtils.setChildElement(this, (XMLElement)keyInfo, nsURIs, localNames);
    }

    public XSKeyInfo getKeyInfo() {
        return (XSKeyInfo)SAMLUtils.getChildElement(this, "http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
    }

    static {
        SAMLInitializer.initialize();
    }
}

