/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.sqlserver2000;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.GenerateDSMLFormattedFiles;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.MetadataFileParser;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.ObjectStatusList;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.OracleDatatypeIdentifiers;
import oracle.dbtools.migration.workbench.sqlserver7.SQLServer7AbstractCapturer;

public class SQLServer2000DoOfflineCaptureLoad
implements OracleDatatypeIdentifiers {
    private HashMap<File, ArrayList<File>> _dbXMLMetadataList = new HashMap();
    private HashMap<File, ObjectStatusList> m_dSMLMap = null;
    private String _currentTableName = null;
    private int _currentDbId = 0;
    public String currValue = "";
    private HashMap<String, String[]> m_tableTypes = new HashMap();
    private Connection m_conn = null;
    private static String m_encoding = null;

    public SQLServer2000DoOfflineCaptureLoad(Connection connection) {
        this.m_conn = connection;
        this.populateTableTypes();
    }

    public void convertBcpDumpToXML(HashMap<File, ObjectStatusList> hashMap) throws OfflineCaptureException {
        this.m_dSMLMap = hashMap;
        Statement statement = null;
        Connection connection = null;
        try {
            connection = this.m_conn;
            statement = connection.createStatement();
            GenerateDSMLFormattedFiles generateDSMLFormattedFiles = new GenerateDSMLFormattedFiles(this.m_dSMLMap, SQLServer2000DoOfflineCaptureLoad.getEncoding());
            this._dbXMLMetadataList = generateDSMLFormattedFiles.getDSMLFormattedFilesTable();
        }
        catch (SQLException sQLException) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw new OfflineCaptureException((Exception)sQLException);
        }
        catch (Exception exception) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new OfflineCaptureException(exception);
        }
    }

    public void loadSourceModel(HashMap<File, ObjectStatusList> hashMap) throws OfflineCaptureException {
        this.m_dSMLMap = hashMap;
        Statement statement = null;
        Connection connection = null;
        Object var4_4 = null;
        try {
            connection = this.m_conn;
            statement = connection.createStatement();
            GenerateDSMLFormattedFiles generateDSMLFormattedFiles = new GenerateDSMLFormattedFiles(this.m_dSMLMap, SQLServer2000DoOfflineCaptureLoad.getEncoding());
            this._dbXMLMetadataList = generateDSMLFormattedFiles.getDSMLFormattedFilesTable();
            File file = this.getDbFile("MASTER");
            if (file == null) {
                throw new OfflineCaptureException(new Exception());
            }
            this._currentDbId = 1;
            this.populateSourceModel(connection, file, 1);
            for (File file2 : this._dbXMLMetadataList.keySet()) {
                int n;
                if (file2.getName().equalsIgnoreCase("MASTER")) continue;
                this._currentDbId = n = this.getDbId(connection, file2.getName());
                SQLServer7AbstractCapturer.OfflineDbId = n;
                if (n == 0) continue;
                this.populateSourceModel(connection, file2, n);
            }
            this.sourceModelIndexCreate(connection);
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw new OfflineCaptureException((Exception)sQLException);
        }
        catch (Exception exception) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new OfflineCaptureException(exception);
        }
    }

    public File getDbFile(String string) {
        File file = null;
        for (File file2 : this.m_dSMLMap.keySet()) {
            String string2 = file2.getName();
            if (!string2.equalsIgnoreCase(string)) continue;
            file = file2;
            break;
        }
        return file;
    }

    public int getDbId(Connection connection, String string) throws OfflineCaptureException {
        Statement statement = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            statement = connection.createStatement();
            String string2 = " SELECT DBID FROM SS2K_SYSDATABASES  WHERE UPPER(RTRIM(NAME)) = '" + string.toUpperCase() + "' ";
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            return n;
        }
        catch (SQLException sQLException) {
            throw new OfflineCaptureException((Exception)sQLException);
        }
    }

    public void populateSourceModel(Connection connection, File file, int n) throws OfflineCaptureException {
        try {
            ArrayList<File> arrayList = this._dbXMLMetadataList.get(file);
            Iterator<File> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                File file2;
                File file3 = file2 = iterator.next();
                this._currentTableName = GenerateDSMLFormattedFiles.getUnqualifiedName(file3.getName());
                this._currentTableName = this.getCorrectName(this._currentTableName);
                String[] stringArray = this.getFieldTypes(this._currentTableName);
                if (stringArray == null) continue;
                MetadataFileParser metadataFileParser = new MetadataFileParser(n, SQLServer2000DoOfflineCaptureLoad.fileToURL(file3), this._currentTableName);
                metadataFileParser.createPrepardStatement(connection, stringArray);
                int n2 = metadataFileParser.loadData();
            }
        }
        catch (Exception exception) {
            throw new OfflineCaptureException(exception);
        }
    }

    private String getCorrectName(String string) {
        if (string.startsWith("SS2K")) {
            return string;
        }
        if (string.startsWith("SS2K5")) {
            return "SS2K_" + string.split("_")[1];
        }
        return string;
    }

    private String[] getFieldTypes(String string) {
        String[] stringArray = null;
        for (String string2 : this.m_tableTypes.keySet()) {
            if (!string.equalsIgnoreCase(string2)) continue;
            stringArray = this.m_tableTypes.get(string2.toUpperCase());
            break;
        }
        return stringArray;
    }

    private void populateTableTypes() {
        String[] stringArray = new String[]{"3", "6", "3", "5", "5", "5", "3", "3", "3", "3", "3", "1", "1", "1", "1", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "1", "3"};
        this.m_tableTypes.put("SS2K_SYSLOGINS", stringArray);
        String[] stringArray2 = new String[]{"3", "1", "3", "6", "3", "3", "3", "5", "5", "3", "3", "1", "3"};
        this.m_tableTypes.put("SS2K_SYSDATABASES", stringArray2);
        String[] stringArray3 = new String[]{"3", "3", "3", "1", "6", "7", "5", "5", "3", "6", "3", "1", "3", "3", "3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS2K_SYSUSERS", stringArray3);
        String[] stringArray4 = new String[]{"3", "3", "3", "3", "3", "3", "6", "6", "6", "6", "6", "6"};
        this.m_tableTypes.put("SS2K_SYSPERMISSIONS", stringArray4);
        String[] stringArray5 = new String[]{"3", "3", "3", "3", "3", "6", "3"};
        this.m_tableTypes.put("SS2K_SYSPROTECTS", stringArray5);
        String[] stringArray6 = new String[]{"3", "1", "3", "8", "3", "3", "3", "3", "3", "3", "5", "3", "3", "3", "8", "3", "3", "3", "5", "3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS2K_SYSOBJECTS", stringArray6);
        String[] stringArray7 = new String[]{"3", "1", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "1", "3", "3", "3", "3", "3", "1", "6"};
        this.m_tableTypes.put("SS2K_SYSCOLUMNS", stringArray7);
        String[] stringArray8 = new String[]{"3", "1", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "1", "3", "3", "1"};
        this.m_tableTypes.put("SS2K_SYSTYPES", stringArray8);
        String[] stringArray9 = new String[]{"3", "3", "3", "6", "3", "6", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "6", "3", "3", "3", "6", "1", "11", "3", "3"};
        this.m_tableTypes.put("SS2K_SYSINDEXES", stringArray9);
        String[] stringArray10 = new String[]{"3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS2K_SYSINDEXKEYS", stringArray10);
        String[] stringArray11 = new String[]{"3", "3", "3", "3", "3", "3", "6", "6", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS2K_SYSREFERENCES", stringArray11);
        String[] stringArray12 = new String[]{"3", "3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS2K_SYSCONSTRAINTS", stringArray12);
        String[] stringArray13 = new String[]{"3", "3", "3", "3", "3", "3", "3", "3", "3", "4"};
        this.m_tableTypes.put("SS2K_SYSCOMMENTS", stringArray13);
        String[] stringArray14 = new String[]{"3", "3", "3", "3", "3", "3", "3", "3", "1", "1"};
        this.m_tableTypes.put("SS2K_SYSFILES", stringArray14);
        String[] stringArray15 = new String[]{"3", "3", "3"};
        this.m_tableTypes.put("SS2K_SYSMEMBERS", stringArray15);
        String[] stringArray16 = new String[]{"3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SS2K_SYSFOREIGNKEYS", stringArray16);
        String[] stringArray17 = new String[]{"3", "3", "3", "3", "1", "1"};
        this.m_tableTypes.put("SS2K_SYSPROPERTIES", stringArray17);
    }

    private static URL fileToURL(File file) {
        Object object = file.getAbsolutePath();
        String string = System.getProperty("file.separator");
        if (string != null && string.length() == 1) {
            object = ((String)object).replace(string.charAt(0), '/');
        }
        if (((String)object).length() > 0 && ((String)object).charAt(0) != '/') {
            object = "/" + (String)object;
        }
        try {
            return new URL("file", null, (String)object);
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error("Unexpected MalformedURLException");
        }
    }

    public void sourceModelIndexCreate(Connection connection) throws OfflineCaptureException {
        Statement statement = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            arrayList.add("CREATE INDEX SS2K_syslogins_sid on SS2K_syslogins (\"SID\")");
            arrayList.add("CREATE INDEX SS2K_sysdatabases_db_id on SS2K_sysdatabases (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K_sysdatabases_name on SS2K_sysdatabases (\"NAME\")");
            arrayList.add("CREATE INDEX SS2K_sysdatabases_dbid on SS2K_sysdatabases (\"DBID\")");
            arrayList.add("CREATE INDEX SS2K_sysusers_uid on SS2K_sysusers (\"UID\")");
            arrayList.add("CREATE INDEX SS2K_sysusers_sid on SS2K_sysusers (\"SID\")");
            arrayList.add("CREATE INDEX SS2K_sysusers_gid on SS2K_sysusers (\"GID\")");
            arrayList.add("CREATE INDEX SS2K_sysusers_db_id on SS2K_sysusers (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K_permissions_db_id on SS2K_syspermissions (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K_permissions_id on SS2K_syspermissions (\"ID\")");
            arrayList.add("CREATE INDEX SS2K_sysprotects_db_id on SS2K_sysprotects (DB_ID)");
            arrayList.add("CREATE INDEX SS2K_sysprotects_id on SS2K_sysprotects (\"ID\")");
            arrayList.add("CREATE INDEX SS2K_sysprotects_uid on SS2K_sysprotects (\"UID\")");
            arrayList.add("CREATE INDEX SS2K_sysprotects_action on SS2K_sysprotects (\"ACTION\")");
            arrayList.add("CREATE INDEX SS2K_sysprotects_protecttype on SS2K_sysprotects (\"PROTECTTYPE\")");
            arrayList.add("CREATE INDEX SS2K_sysobj_db_id on SS2K_sysobjects (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K_sysobj_id on SS2K_sysobjects (\"ID\")");
            arrayList.add("CREATE INDEX SS2K_sysobj_name on SS2K_sysobjects (\"NAME\")");
            arrayList.add("CREATE INDEX SS2K_sysobj_xtype on SS2K_sysobjects (\"XTYPE\")");
            arrayList.add("CREATE INDEX SS2K_sysobj_uid on SS2K_sysobjects (\"UID\")");
            arrayList.add("CREATE INDEX SS2K_syscol_id on SS2K_syscolumns (\"ID\")");
            arrayList.add("CREATE INDEX SS2K_syscol_db_id on SS2K_syscolumns (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K_systypes_xutype on SS2K_systypes (\"XUSERTYPE\")");
            arrayList.add("CREATE INDEX SS2K_systypes_db_id on SS2K_systypes (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K_systypes_name on SS2K_systypes (\"NAME\")");
            arrayList.add("CREATE INDEX SS2K_sysindex_db_id on SS2K_sysindexes (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K_sysindex_id on SS2K_sysindexes (\"ID\")");
            arrayList.add("CREATE INDEX SS2K_sysindex_indid on SS2K_sysindexes (\"INDID\")");
            arrayList.add("CREATE INDEX SS2K_sysindexkeys_db_id on SS2K_sysindexkeys (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K_sysindexkeys_id on SS2K_sysindexkeys (\"ID\")");
            arrayList.add("CREATE INDEX SS2K_sysindexkeys_indid on SS2K_sysindexkeys (\"INDID\")");
            arrayList.add("CREATE INDEX SS2K_sysreferences_rkeyid on SS2K_sysreferences (\"RKEYID\")");
            arrayList.add("CREATE INDEX SS2K_sysreferences_Fkeyid on SS2K_sysreferences (\"FKEYID\")");
            arrayList.add("CREATE INDEX SS2K_sysreferences_constid on SS2K_sysreferences (\"CONSTID\")");
            arrayList.add("CREATE INDEX SS2K_sysreferences_db_id on SS2K_sysreferences (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K_sysconstraints_constid on SS2K_sysconstraints (\"CONSTID\")");
            arrayList.add("CREATE INDEX SS2K_sysconstraints_db_id on SS2K_sysconstraints (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K_sysconstraints_id on SS2K_sysconstraints (\"ID\")");
            arrayList.add("CREATE INDEX SS2K_syscomments_dbid on SS2K_syscomments (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K_syscomments_id on SS2K_syscomments (\"ID\")");
            arrayList.add("CREATE INDEX SS2K_syscomments_colid on SS2K_syscomments (\"COLID\")");
            arrayList.add("CREATE INDEX SS2K_sysfiles_db_id on SS2K_sysfiles (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K_sysfiles_fileid on SS2K_sysfiles (\"FILEID\")");
            arrayList.add("CREATE INDEX SS2K_sysmembers_db_id on SS2K_sysmembers (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K_sysmembers_memberuid on SS2K_sysmembers (\"MEMBERUID\")");
            arrayList.add("CREATE INDEX SS2K_sysmembers_groupuid on SS2K_sysmembers (\"GROUPUID\")");
            arrayList.add("CREATE INDEX SS2K_sysforeignkeys_db_id on SS2K_sysforeignkeys (\"DB_ID\")");
            arrayList.add("CREATE INDEX SS2K_sysforeignkeys_constid on SS2K_sysforeignkeys (\"CONSTID\")");
            arrayList.add("CREATE INDEX SS2K_sysforeignkeys_fkeyid on SS2K_sysforeignkeys (\"FKEYID\")");
            arrayList.add("CREATE INDEX SS2K_sysforeignkeys_rkeyid on SS2K_sysforeignkeys (\"RKEYID\")");
            statement = connection.createStatement();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = string = (String)iterator.next();
                try {
                    statement.execute(string2);
                }
                catch (SQLException sQLException) {
                    throw new OfflineCaptureException((Exception)sQLException);
                }
            }
            statement.close();
            arrayList.clear();
        }
        catch (SQLException sQLException) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw new OfflineCaptureException((Exception)sQLException);
        }
    }

    public static void setEncoding(String string) {
        m_encoding = string;
    }

    public static String getEncoding() {
        return m_encoding;
    }
}

