/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.xml.xsql.XSQLConfigManager;
import oracle.xml.xsql.XSQLConnectionManager;
import oracle.xml.xsql.XSQLConnectionManagerCleanup;
import oracle.xml.xsql.XSQLConnectionManagerFactory;
import oracle.xml.xsql.XSQLInitializationException;
import oracle.xml.xsql.XSQLPageProcessor;
import oracle.xml.xsql.XSQLServletPageRequest;
import org.xml.sax.SAXParseException;

public final class XSQLServlet
extends HttpServlet {
    private ServletContext myContext = null;
    private static boolean inJServ = false;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.myContext = servletConfig.getServletContext();
        String string = this.myContext.getServerInfo();
        inJServ = string != null && string.indexOf("JServ") >= 0;
    }

    public static boolean inJServ() {
        return inJServ;
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        XSQLServletPageRequest xSQLServletPageRequest = new XSQLServletPageRequest(httpServletRequest, httpServletResponse, this.getServletConfig());
        XSQLPageProcessor xSQLPageProcessor = new XSQLPageProcessor(xSQLServletPageRequest);
        try {
            xSQLPageProcessor.process();
        }
        catch (SAXParseException sAXParseException) {
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        catch (XSQLInitializationException xSQLInitializationException) {
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    public String getServletInfo() {
        return "Oracle XSQLServlet";
    }

    public void destroy() {
        super.destroy();
        XSQLConfigManager xSQLConfigManager = XSQLConfigManager.getManager();
        XSQLConnectionManagerFactory xSQLConnectionManagerFactory = xSQLConfigManager.getDefaultConnectionManagerFactory();
        XSQLConnectionManager xSQLConnectionManager = xSQLConnectionManagerFactory.create();
        if (xSQLConnectionManager instanceof XSQLConnectionManagerCleanup) {
            XSQLConnectionManagerCleanup xSQLConnectionManagerCleanup = (XSQLConnectionManagerCleanup)((Object)xSQLConnectionManager);
            xSQLConnectionManagerCleanup.cleanup();
        }
        xSQLConfigManager.reset();
    }
}

