/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.renderer.maps;

import ilog.views.IlvGraphic;
import ilog.views.IlvLayerVisibilityFilter;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvManagerView;
import ilog.views.IlvRect;
import ilog.views.graphic.IlvIcon;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.tiling.IlvTile;
import ilog.views.tiling.IlvTileLoader;
import ilog.views.util.IlvImageUtil;
import java.awt.Image;
import java.io.IOException;
import java.net.URL;

public class IlvImageTileLoader
extends IlvLayerVisibilityFilter
implements IlvTileLoader {
    String a;
    String b;
    double c;
    double d;
    boolean e = false;

    public IlvImageTileLoader(String string, String string2, double d, double d2) {
        this.a = string;
        this.b = string2;
        this.c = d;
        this.d = d2;
    }

    public IlvImageTileLoader(IlvInputStream ilvInputStream) throws IlvReadFileException, IOException {
        super(ilvInputStream);
        this.a = ilvInputStream.readString("prefix");
        URL uRL = ilvInputStream.getDocumentBase();
        if (uRL != null) {
            try {
                this.a = new URL(uRL, this.a).toString();
            }
            catch (Exception exception) {
            }
        }
        this.b = ilvInputStream.readString("suffix");
        this.c = ilvInputStream.readDouble("minZoom");
        this.d = ilvInputStream.readDouble("maxZoom");
        try {
            this.e = ilvInputStream.readBoolean("highQuality");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public void setHighQualityRendering(boolean bl) {
        this.e = bl;
    }

    public boolean isHighQualityRendering() {
        return this.e;
    }

    public void load(IlvTile ilvTile) throws Exception {
        Image image;
        String string = this.a(ilvTile);
        IlvRect ilvRect = new IlvRect();
        ilvTile.boundingBox(ilvRect);
        try {
            image = IlvImageUtil.loadImage((URL)new URL(string));
        }
        catch (Exception exception) {
            try {
                image = IlvImageUtil.loadImage((String)string);
            }
            catch (Exception exception2) {
                image = null;
            }
        }
        IlvIcon ilvIcon = new IlvIcon(image, ilvRect);
        ilvIcon.setHighQualityRendering(this.e);
        ilvTile.addObject((IlvGraphic)ilvIcon, (Object)string);
        ilvTile.loadComplete();
    }

    public void release(IlvTile ilvTile) {
        String string = this.a(ilvTile);
        IlvGraphic ilvGraphic = ilvTile.getObject((Object)string);
        if (ilvGraphic != null) {
            try {
                ilvTile.getController().getManager().removeObject(ilvGraphic, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            IlvIcon ilvIcon = (IlvIcon)ilvGraphic;
            if (ilvIcon.getImage() != null) {
                ilvIcon.getImage().flush();
            }
        }
    }

    private String a(IlvTile ilvTile) {
        return this.a + "_" + ilvTile.getColumn() + "_" + ilvTile.getRow() + this.b;
    }

    public boolean isVisible(IlvManagerLayer ilvManagerLayer, IlvManagerView ilvManagerView) {
        double d = ilvManagerView.getTransformer().zoomFactor();
        return (this.c == 0.0 || d > this.c) && (this.d == 0.0 || d <= this.d);
    }

    public boolean isPersistent() {
        return true;
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        ilvOutputStream.write("prefix", this.a);
        ilvOutputStream.write("suffix", this.b);
        ilvOutputStream.write("minZoom", this.c);
        ilvOutputStream.write("maxZoom", this.d);
        if (this.e) {
            ilvOutputStream.write("highQuality", this.e);
        }
    }
}

