/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.renderer;

import ilog.views.IlvGraphic;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.graphic.util.ColorAllocator;
import ilog.views.sdm.renderer.IlvFilterSDMRenderer;
import ilog.views.sdm.renderer.IlvRendererUtil;
import ilog.views.sdm.renderer.IlvSDMCSSFunction;
import ilog.views.sdm.renderer.IlvSDMRenderer;
import ilog.views.sdm.renderer.IlvStyleSheetRenderer;
import java.awt.Color;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public class IlvColoringRenderer
extends IlvFilterSDMRenderer {
    String a = "foreground";
    String b = null;
    ColorAllocator c = new ColorAllocator();

    public IlvColoringRenderer(IlvSDMRenderer ilvSDMRenderer) {
        super(ilvSDMRenderer);
    }

    public IlvColoringRenderer() {
        this(null);
    }

    @Override
    public void setParameter(String string) {
        this.setIndexProperty(string);
    }

    @Override
    public String getParameter() {
        return this.getIndexProperty();
    }

    public void setColorProperty(String string) {
        this.a = string;
    }

    public String getColorProperty() {
        return this.a;
    }

    public void setIndexProperty(String string) {
        this.b = string;
    }

    public String getIndexProperty() {
        return this.b;
    }

    public void setHue(float f) {
        this.c.setHue(f);
    }

    public float getHue() {
        return this.c.getHue();
    }

    public void setSaturation(float f) {
        this.c.setSaturation(f);
    }

    public float getSaturation() {
        return this.c.getSaturation();
    }

    public void setBrightness(float f) {
        this.c.setBrightness(f);
    }

    public float getBrightness() {
        return this.c.getBrightness();
    }

    public void setAlpha(float f) {
        this.c.setAlpha(f);
    }

    public float getAlpha() {
        return this.c.getAlpha();
    }

    @Override
    public void removeAll(IlvSDMEngine ilvSDMEngine) {
        super.removeAll(ilvSDMEngine);
        this.c.reset();
    }

    @Override
    public IlvGraphic createNodeGraphic(IlvSDMEngine ilvSDMEngine, Object object) {
        IlvGraphic ilvGraphic = super.createNodeGraphic(ilvSDMEngine, object);
        if (ilvGraphic != null) {
            this.a(ilvSDMEngine, object, ilvGraphic);
        }
        return ilvGraphic;
    }

    @Override
    public IlvGraphic createLinkGraphic(IlvSDMEngine ilvSDMEngine, Object object, IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2) {
        IlvGraphic ilvGraphic3 = super.createLinkGraphic(ilvSDMEngine, object, ilvGraphic, ilvGraphic2);
        if (ilvGraphic3 != null) {
            this.a(ilvSDMEngine, object, ilvGraphic3);
        }
        return ilvGraphic3;
    }

    @Override
    public void prepareRendering(IlvSDMEngine ilvSDMEngine) {
        super.prepareRendering(ilvSDMEngine);
        IlvStyleSheetRenderer ilvStyleSheetRenderer = (IlvStyleSheetRenderer)IlvRendererUtil.getRenderer(ilvSDMEngine, "StyleSheet");
        if (ilvStyleSheetRenderer != null) {
            ilvStyleSheetRenderer.registerFunction(new ColoringFunction());
        }
    }

    private void a(IlvSDMEngine ilvSDMEngine, Object object, IlvGraphic ilvGraphic) {
        if (this.a == null) {
            return;
        }
        Object object2 = this.b != null && this.b.length() > 0 ? IlvRendererUtil.getGraphicProperty(ilvSDMEngine, object, this.b, null, null) : "<no index property>";
        if (object2 == null) {
            return;
        }
        Color color = this.c.getColor(object2);
        IlvGraphic ilvGraphic2 = ilvSDMEngine.getRenderer().getEncapsulatedGraphic(ilvGraphic);
        if (this.a.indexOf(",") > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.a, ", ");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                this.a(ilvGraphic, string, color);
                if (ilvGraphic2 == ilvGraphic) continue;
                this.a(ilvGraphic2, string, color);
            }
        } else {
            this.a(ilvGraphic, this.a, color);
            if (ilvGraphic2 != ilvGraphic) {
                this.a(ilvGraphic2, this.a, color);
            }
        }
    }

    private void a(IlvGraphic ilvGraphic, String string, Color color) {
        if (string.equals("foreground")) {
            ilvGraphic.setForeground(color);
        } else if (string.equals("background")) {
            ilvGraphic.setBackground(color);
        } else {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(ilvGraphic.getClass());
                PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                    if (!propertyDescriptorArray[i].getName().equals(string)) continue;
                    Method method = propertyDescriptorArray[i].getWriteMethod();
                    if (method != null) {
                        Object[] objectArray = new Object[]{color};
                        method.invoke((Object)ilvGraphic, objectArray);
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class ColoringFunction
    extends IlvSDMCSSFunction
    implements Serializable {
        ColoringFunction() {
        }

        @Override
        public String getName() {
            return "coloring";
        }

        public String getShortDescription() {
            return IlvSDMCSSFunction.a().getString("IlvColoringRenderer.function.shortDescr.coloring");
        }

        @Override
        public Object call(Object[] objectArray, Class clazz, IlvSDMEngine ilvSDMEngine, Object object, Object object2) {
            if (objectArray.length != 1 || objectArray[0] == null) {
                throw new IllegalArgumentException("bad argument list: expected coloring type value (i.e. \"foreground : @|coloring(type);\" )");
            }
            return IlvColoringRenderer.this.c.getColor(objectArray[0]);
        }
    }
}

