/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.graphic.IlvArrowLine;
import ilog.views.graphic.IlvCircularScale;
import ilog.views.graphic.IlvFilledEllipse;
import ilog.views.graphic.IlvFilledRectangle;
import ilog.views.graphic.IlvGeneralPath;
import ilog.views.graphic.IlvIcon;
import ilog.views.graphic.IlvLabel;
import ilog.views.graphic.IlvLine;
import ilog.views.graphic.IlvMarker;
import ilog.views.graphic.IlvPolyline;
import ilog.views.graphic.IlvRectangularScale;
import ilog.views.graphic.IlvReliefLabel;
import ilog.views.graphic.IlvShadowLabel;
import ilog.views.graphic.IlvZoomableLabel;
import ilog.views.interactor.IlvRectangularObjectFactory;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class IlvGraphicFactories {
    private IlvGraphicFactories() {
    }

    public static class BusPolyline
    implements IlvRectangularObjectFactory {
        public IlvGraphic createObject(IlvRect ilvRect) {
            IlvPoint[] ilvPointArray = new IlvPoint[6];
            ilvPointArray[0] = new IlvPoint(ilvRect.x, ilvRect.y);
            ilvPointArray[1] = new IlvPoint(ilvRect.x + ilvRect.width, ilvRect.y);
            ilvPointArray[2] = new IlvPoint(ilvRect.x + ilvRect.width, ilvRect.y + 0.5f * ilvRect.height);
            ilvPointArray[3] = new IlvPoint(ilvRect.x, ilvRect.y + 0.5f * ilvRect.height);
            ilvPointArray[4] = new IlvPoint(ilvRect.x, ilvRect.y + ilvRect.height);
            ilvPointArray[5] = new IlvPoint(ilvRect.x + ilvRect.width, ilvRect.y + ilvRect.height);
            return new IlvPolyline(ilvPointArray);
        }
    }

    public static class CircularScale
    implements IlvRectangularObjectFactory {
        public IlvGraphic createObject(IlvRect ilvRect) {
            return new IlvCircularScale(ilvRect, "#", 0.0f, 10.0f, 0.0f, 360.0f, false, 1, 0, 2.0f, 1.0f);
        }
    }

    public static class RectangularScale
    implements IlvRectangularObjectFactory {
        public IlvGraphic createObject(IlvRect ilvRect) {
            return new IlvRectangularScale(new IlvPoint(ilvRect.x, ilvRect.y), 10.0f, "#", 0.0f, 10.0f, 1, 0, 1, 8, 2.0f, 1.0f);
        }
    }

    public static class ZoomableLabel
    implements IlvRectangularObjectFactory {
        public IlvGraphic createObject(IlvRect ilvRect) {
            IlvPoint ilvPoint = new IlvPoint();
            IlvZoomableLabel ilvZoomableLabel = new IlvZoomableLabel(ilvPoint, "no-label", false);
            ilvZoomableLabel.move(ilvRect.x, ilvRect.y);
            return ilvZoomableLabel;
        }
    }

    public static class ShadowLabel
    implements IlvRectangularObjectFactory {
        public IlvGraphic createObject(IlvRect ilvRect) {
            return new IlvShadowLabel(ilvRect, "no label", 5.0f, 10);
        }
    }

    public static class ReliefLabel
    implements IlvRectangularObjectFactory {
        public IlvGraphic createObject(IlvRect ilvRect) {
            return new IlvReliefLabel(ilvRect, "no label");
        }
    }

    public static class FilledEllipse
    implements IlvRectangularObjectFactory {
        public IlvGraphic createObject(IlvRect ilvRect) {
            return new IlvFilledEllipse(ilvRect);
        }
    }

    public static class FilledRectangle
    implements IlvRectangularObjectFactory {
        public IlvGraphic createObject(IlvRect ilvRect) {
            return new IlvFilledRectangle(ilvRect);
        }
    }

    public static class Ellipse
    implements IlvRectangularObjectFactory {
        public IlvGraphic createObject(IlvRect ilvRect) {
            Ellipse2D.Float float_ = new Ellipse2D.Float(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height);
            IlvGeneralPath ilvGeneralPath = new IlvGeneralPath((Shape)float_);
            ilvGeneralPath.setFillOn(false);
            return ilvGeneralPath;
        }
    }

    public static class Rectangle
    implements IlvRectangularObjectFactory {
        public IlvGraphic createObject(IlvRect ilvRect) {
            Rectangle2D.Float float_ = new Rectangle2D.Float(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height);
            IlvGeneralPath ilvGeneralPath = new IlvGeneralPath((Shape)float_);
            ilvGeneralPath.setFillOn(false);
            return ilvGeneralPath;
        }
    }

    public static class Marker
    implements IlvRectangularObjectFactory {
        public IlvGraphic createObject(IlvRect ilvRect) {
            float f = (ilvRect.width + ilvRect.height) / 2.0f;
            IlvPoint ilvPoint = new IlvPoint(ilvRect.x, ilvRect.y);
            return new IlvMarker(ilvPoint, 8, (int)f);
        }
    }

    public static class Label
    implements IlvRectangularObjectFactory {
        public IlvGraphic createObject(IlvRect ilvRect) {
            return new IlvLabel(new IlvPoint(ilvRect.x, ilvRect.y), "no label");
        }
    }

    public static class Line
    implements IlvRectangularObjectFactory {
        public IlvGraphic createObject(IlvRect ilvRect) {
            return new IlvLine(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height);
        }
    }

    public static class Icon
    implements IlvRectangularObjectFactory {
        public IlvGraphic createObject(IlvRect ilvRect) {
            return new IlvIcon((Image)null, ilvRect);
        }
    }

    public static class ArrowLine
    implements IlvRectangularObjectFactory {
        public IlvGraphic createObject(IlvRect ilvRect) {
            return new IlvArrowLine(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height, 0.5f);
        }
    }
}

