/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.debugger.gui;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvGeneralPath;
import ilog.views.graphic.IlvIcon;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMView;
import ilog.views.sdm.debugger.IlvDebuggerContext;
import ilog.views.swing.IlvJManagerViewControlBar;
import ilog.views.swing.IlvJScrollManagerView;
import ilog.views.util.java2d.IlvBlinkingColor;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class IlvDiagramPanel
extends JPanel {
    private IlvDebuggerContext a;
    private IlvSDMView b;
    private Object c;
    private IlvGraphic d;
    private Session e;
    private ArrayList<Breakpoint> f = new ArrayList();
    private static ImageIcon g;

    public IlvDiagramPanel(IlvDebuggerContext ilvDebuggerContext) {
        super(new BorderLayout());
        this.a = ilvDebuggerContext;
        ilvDebuggerContext.setDiagramPanel(this);
        this.b();
        this.setSize(400, 400);
    }

    private void b() {
        this.b = new IlvSDMView(this.a.getEngine());
        this.b.setBackground(Color.white);
        this.add(this.a(this.b), "North");
        IlvJScrollManagerView ilvJScrollManagerView = new IlvJScrollManagerView((IlvManagerView)this.b);
        ilvJScrollManagerView.setSize(400, 400);
        this.add((Component)ilvJScrollManagerView, "Center");
    }

    private int c() {
        return 15;
    }

    private Breakpoint a(Object object) {
        for (Breakpoint breakpoint : this.f) {
            if (!breakpoint.isBreaking(object)) continue;
            return breakpoint;
        }
        return null;
    }

    public boolean shouldPauseDebugger() {
        return this.c != null && this.a(this.c) != null;
    }

    private Component a(IlvSDMView ilvSDMView) {
        IlvJManagerViewControlBar ilvJManagerViewControlBar = new IlvJManagerViewControlBar();
        ilvJManagerViewControlBar.setView((IlvManagerView)ilvSDMView);
        ilvJManagerViewControlBar.add((Action)new BreakpointAction());
        return ilvJManagerViewControlBar;
    }

    public void setCurrentObject(Object object) {
        if (object == null) {
            this.highlightCurrentGraphic(false);
        }
        this.c = object;
    }

    public void highlightCurrentGraphic(boolean bl) {
        if (this.c == null) {
            return;
        }
        IlvManager ilvManager = this.b.getManager();
        if (bl) {
            this.d = this.e.addHighLighter(this.c);
        } else if (this.d != null) {
            final IlvGraphic ilvGraphic = this.d;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ilvGraphic.getGraphicBag().removeObject(ilvGraphic, true);
                }
            });
            this.d = null;
        }
    }

    public void recordSession(boolean bl) {
        if (bl) {
            this.e = new Session();
            this.e.copyGraphicData(this.a);
        }
    }

    public void shutDown() {
        this.highlightCurrentGraphic(false);
        for (Breakpoint breakpoint : this.f) {
            breakpoint.getGraphicBag().removeObject((IlvGraphic)breakpoint, true);
        }
    }

    private static IlvRect b(IlvGraphic ilvGraphic) {
        IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
        IlvTransformer ilvTransformer = null;
        if (ilvGraphic instanceof IlvManager) {
            ilvTransformer = ((IlvManager)ilvGraphic).getTopLevelTransformer();
        }
        return ilvGraphic.boundingBox(ilvTransformer);
    }

    private class Breakpoint
    extends IlvIcon {
        private Object a;

        public Breakpoint(Object object) {
            super(g.getImage(), new IlvRect(0.0f, 0.0f, (float)g.getIconWidth(), (float)g.getIconHeight()));
            this.a = object;
        }

        public boolean isBreaking(Object object) {
            return this.a == object;
        }
    }

    public class BreakpointAction
    extends AbstractAction
    implements MouseListener {
        public BreakpointAction() {
            super("break");
            if (g == null) {
                g = new ImageIcon(this.getClass().getResource("bullet.gif"));
            }
            this.putValue("SmallIcon", g);
            this.putValue("ShortDescription", IlvDiagramPanel.this.a.getBundle().getString("IlvDiagramPanel.breakpointButton.tooltiptext"));
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void setEnabled(boolean bl) {
            System.err.println("BreakpointAction.setEnabled(): " + bl);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IlvManagerViewInteractor ilvManagerViewInteractor = new IlvManagerViewInteractor();
            ilvManagerViewInteractor.addMouseListener((MouseListener)this);
            IlvDiagramPanel.this.b.pushInteractor(ilvManagerViewInteractor);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            IlvPoint ilvPoint = new IlvPoint((float)mouseEvent.getX(), (float)mouseEvent.getY());
            IlvGraphic ilvGraphic = IlvDiagramPanel.this.b.getManager().getObject(ilvPoint, (IlvManagerView)IlvDiagramPanel.this.b, true);
            if (ilvGraphic != null) {
                if (ilvGraphic instanceof Breakpoint) {
                    Breakpoint breakpoint = (Breakpoint)ilvGraphic;
                    breakpoint.getGraphicBag().removeObject((IlvGraphic)breakpoint, true);
                    IlvDiagramPanel.this.f.remove((Object)breakpoint);
                } else {
                    Object object = IlvDiagramPanel.this.a.getDiagrammer().getEngine().getObject(ilvGraphic);
                    if (object != null) {
                        Breakpoint breakpoint = IlvDiagramPanel.this.a(object);
                        if (breakpoint != null) {
                            breakpoint.getGraphicBag().removeObject((IlvGraphic)breakpoint, true);
                            IlvDiagramPanel.this.f.remove((Object)breakpoint);
                        } else {
                            breakpoint = new Breakpoint(object);
                            IlvDiagramPanel.this.f.add(breakpoint);
                            ilvGraphic.getGraphicBag();
                            IlvRect ilvRect = IlvDiagramPanel.b(ilvGraphic);
                            breakpoint.move(ilvRect.x, ilvRect.y);
                            IlvDiagramPanel.this.b.getManager().addObject((IlvGraphic)breakpoint, IlvDiagramPanel.this.c(), true);
                        }
                    }
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    private static class Session {
        IlvGrapher a;
        private HashMap<Object, IlvGraphic> b = new HashMap();

        private Session() {
        }

        public void copyGraphicData(IlvDebuggerContext ilvDebuggerContext) {
            IlvSDMEngine ilvSDMEngine = ilvDebuggerContext.getDiagrammer().getEngine();
            Enumeration enumeration = ilvSDMEngine.getAllObjects();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                IlvGraphic ilvGraphic = ilvSDMEngine.getGraphic(e, false);
                if (ilvGraphic == null) continue;
                this.b.put(e, ilvGraphic);
            }
        }

        public IlvGraphic addHighLighter(Object object) {
            final IlvGraphic ilvGraphic = this.b.get(object);
            IlvRect ilvRect = ilvGraphic.boundingBox();
            ilvRect.expand(4.0f);
            if (ilvRect == null) {
                return null;
            }
            final IlvGeneralPath ilvGeneralPath = new IlvGeneralPath((Shape)new Rectangle2D.Float(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height));
            ilvGeneralPath.setStroke((Stroke)new BasicStroke(3.0f));
            ilvGeneralPath.setFillOn(false);
            ilvGeneralPath.setForeground((Color)new IlvBlinkingColor(Color.orange, Color.black));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ilvGraphic.getGraphicBag().addObject((IlvGraphic)ilvGeneralPath, true);
                }
            });
            return ilvGeneralPath;
        }
    }
}

