/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.builder.gui;

import ilog.views.appframe.IlvApplication;
import ilog.views.applications.util.wizard.IlvBoxUtils;
import ilog.views.builder.IlvBuilder;
import ilog.views.builder.gui.Utils;
import ilog.views.css.model.diagrammer.IlvDiagrammerCSS;
import ilog.views.diagrammer.IlvDiagrammer;
import ilog.views.sdm.IlvSDMException;
import ilog.views.sdm.builder.docview.IlvSDMBuilderDocument;
import ilog.views.sdm.renderer.IlvRendererUtil;
import ilog.views.util.cssbeans.IlvCSSCompatible;
import ilog.views.util.swing.border.IlvEtchedLineBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class RendererChooser
extends JPanel
implements ActionListener {
    private IlvSDMBuilderDocument a;
    private IlvDiagrammer b;
    private JDialog c;
    private JButton d;
    private JButton e;
    private Map<String, Integer> f;
    private boolean g;
    private static final String h = "Builder.SDM.RendererChooser.";
    private static final String i = "renderer_name";

    public RendererChooser(IlvSDMBuilderDocument ilvSDMBuilderDocument, URL uRL) {
        super(new BorderLayout());
        this.a = ilvSDMBuilderDocument;
        this.g = false;
        Box box = new Box(2);
        box.add(Box.createHorizontalStrut(5));
        JLabel jLabel = new JLabel(ilvSDMBuilderDocument.getApplication().getString("Builder.SDM.RendererChooser.Description"));
        jLabel.setForeground(Utils.LABEL_FOREGROUND_COLOR);
        jLabel.setFont(Utils.DESCRIPTION_FONT);
        box.add(jLabel);
        this.add((Component)box, "North");
        this.b = new IlvDiagrammer();
        ilvSDMBuilderDocument.getPaletteManager().attach((IlvCSSCompatible)this.b.getEngine());
        this.b.getView().setAutoFitToContents(true);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createBevelBorder(1)));
        jPanel.add((Component)this.b, "Center");
        this.add((Component)jPanel, "Before");
        try {
            this.b.setStyleSheet(uRL);
            this.b.setDataSource(ilvSDMBuilderDocument.getDiagrammer().getDataSource());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n = this.b.getEngine().getStyleSheets().length;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = new JPanel(gridBagLayout);
        this.add((Component)jPanel2, "Center");
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        String[] stringArray = IlvDiagrammerCSS.allRenderers;
        this.f = new HashMap<String, Integer>();
        for (int i = 0; i < stringArray.length; ++i) {
            Serializable serializable;
            String string = stringArray[i];
            if ("StyleSheet".equals(stringArray[i])) continue;
            this.f.put(string, new Integer(n + i));
            JCheckBox jCheckBox = new JCheckBox(IlvDiagrammerCSS.getResourceString(h + string + ".Name"));
            jCheckBox.setMinimumSize(jCheckBox.getPreferredSize());
            jCheckBox.putClientProperty(i, string);
            if (IlvSDMBuilderDocument.isRendererValid(ilvSDMBuilderDocument.getApplication(), string, false)) {
                serializable = IlvRendererUtil.getRenderer(this.b.getEngine(), string);
                jCheckBox.setSelected(serializable != null);
                jCheckBox.addActionListener(this);
            } else {
                jCheckBox.setSelected(false);
                jCheckBox.setEnabled(false);
            }
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagLayout.setConstraints(jCheckBox, gridBagConstraints);
            jPanel2.add(jCheckBox);
            serializable = new JLabel(IlvDiagrammerCSS.getResourceString(h + string + ".Description"));
            ((JComponent)serializable).setFont(IlvBoxUtils.deriveFont((Font)((Component)serializable).getFont(), (int)0));
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints((Component)serializable, gridBagConstraints);
            jPanel2.add((Component)serializable);
            ++gridBagConstraints.gridy;
        }
    }

    public void apply() {
        if (this.g) {
            try {
                this.a.updateRendererConfiguration(this.b.getEngine().getStyleSheets());
            }
            catch (IlvSDMException ilvSDMException) {
                IlvBuilder.showErrorBox((IlvApplication)this.a.getApplication(), (String)"Builder.SDM.RendererChooser.Error", (Exception)ilvSDMException);
            }
        }
    }

    public boolean showDialog() {
        IlvApplication ilvApplication = this.a.getApplication();
        JFrame jFrame = IlvBuilder.getBuilder((IlvApplication)ilvApplication).getFrame();
        this.c = new JDialog(jFrame, ilvApplication.getString("Builder.SDM.RendererChooser.Title"), true);
        this.c.getContentPane().setLayout(new BorderLayout(5, 5));
        this.c.getContentPane().add((Component)this, "Center");
        Box box = new Box(2);
        box.add(Box.createHorizontalStrut(5));
        box.setBorder(BorderFactory.createCompoundBorder((Border)new IlvEtchedLineBorder(2), BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        JLabel jLabel = new JLabel(ilvApplication.getString("Builder.SDM.RendererChooser.Title"));
        jLabel.setForeground(Utils.LABEL_FOREGROUND_COLOR);
        jLabel.setFont(Utils.TITLE_FONT);
        box.add(jLabel);
        this.c.getContentPane().add((Component)box, "North");
        JPanel jPanel = new JPanel(new FlowLayout(1, 5, 5));
        jPanel.setBorder((Border)new IlvEtchedLineBorder());
        this.c.getContentPane().add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanel.add(jPanel2);
        JButton jButton = this.d = new JButton(ilvApplication.getString("Builder.SDM.RendererChooser.OK"));
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        jButton = this.e = new JButton(ilvApplication.getString("Builder.SDM.RendererChooser.Cancel"));
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        int n = Integer.parseInt(ilvApplication.getString("Builder.SDM.RendererChooser.Width"));
        int n2 = Integer.parseInt(ilvApplication.getString("Builder.SDM.RendererChooser.Height"));
        Dimension dimension = new Dimension(n, n2);
        this.c.setSize(dimension);
        this.c.setLocationRelativeTo(jFrame);
        dimension.width /= 2;
        dimension.height /= 2;
        this.b.setPreferredSize(dimension);
        this.g = false;
        this.c.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                RendererChooser.this.a.getPaletteManager().detach((IlvCSSCompatible)RendererChooser.this.b.getEngine());
            }
        });
        this.c.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RendererChooser.this.e.doClick(5);
            }
        }, "cancel", KeyStroke.getKeyStroke(27, 0), 2);
        this.c.setVisible(true);
        return this.g;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.d) {
            this.apply();
            this.c.setVisible(false);
        } else if (actionEvent.getSource() == this.e) {
            this.c.setVisible(false);
        } else if (actionEvent.getSource() instanceof JCheckBox) {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            String string = (String)jCheckBox.getClientProperty(i);
            if (string != null) {
                this.g = true;
                int n = this.f.get(string);
                if (!IlvSDMBuilderDocument.addRemoveRenderer(this.a, this.b.getEngine(), string, n, jCheckBox.isSelected())) {
                    jCheckBox.setSelected(false);
                }
            }
        }
    }
}

