/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.beans.editor;

import java.beans.PropertyEditorSupport;
import java.io.Serializable;

public class EnumPropertyEditor
extends PropertyEditorSupport
implements Serializable {
    protected String[] _enums;
    protected Integer[] _values;
    protected String _baseClass;

    private EnumPropertyEditor() {
    }

    public EnumPropertyEditor(Class clazz, String[] stringArray) {
        this._enums = stringArray;
        this._baseClass = clazz.getName();
        this._values = new Integer[this._enums.length];
        for (int i = 0; i < this._enums.length; ++i) {
            this._values[i] = new Integer(i);
        }
    }

    @Override
    public String getJavaInitializationString() {
        Integer n = (Integer)this.getValue();
        for (int i = 0; i < this._enums.length; ++i) {
            if (!n.equals(this._values[i])) continue;
            return this._baseClass + "." + this._enums[i];
        }
        return null;
    }

    @Override
    public String getAsText() throws IllegalArgumentException {
        if (this.getValue() == null) {
            return this._values[0].toString();
        }
        Integer n = (Integer)this.getValue();
        for (int i = 0; i < this._enums.length; ++i) {
            if (!n.equals(this._values[i])) continue;
            return this._enums[i];
        }
        throw new IllegalArgumentException("bad value " + this.getValue());
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < this._enums.length; ++i) {
            if (!string.equals(this._enums[i])) continue;
            this.setValue(this._values[i]);
            return;
        }
        try {
            Integer n = Integer.valueOf(string);
            for (int i = 0; i < this._values.length; ++i) {
                if (!n.equals(this._values[i])) continue;
                this.setValue(this._values[i]);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException(string);
    }

    @Override
    public String[] getTags() {
        return this._enums;
    }
}

