/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.hypergraph.crossing;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.hypergraph.IlvSegmentedHyperEdge;
import ilog.views.hypergraph.crossing.IlvAbstractCrossingGraphic;
import ilog.views.hypergraph.crossing.IlvCrossingAwareObject;
import ilog.views.internal.IlvStrokeInfo;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.io.IOException;

public class IlvBridgeCrossings
extends IlvAbstractCrossingGraphic {
    private float a = 3.0f;

    public IlvBridgeCrossings(IlvSegmentedHyperEdge ilvSegmentedHyperEdge) {
        super(ilvSegmentedHyperEdge);
    }

    public IlvBridgeCrossings(IlvBridgeCrossings ilvBridgeCrossings) {
        super(ilvBridgeCrossings);
        this.a = ilvBridgeCrossings.a;
    }

    public IlvBridgeCrossings(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.a = ilvInputStream.readFloat("bridgeLengthFactor");
    }

    public IlvGraphic copy() {
        return new IlvBridgeCrossings(this);
    }

    public void setBridgeLengthFactor(float f) {
        this.a = f;
    }

    public final float getBridgeLengthFactor() {
        return this.a;
    }

    @Override
    public void drawCrossing(Graphics graphics, IlvTransformer ilvTransformer, IlvCrossingAwareObject ilvCrossingAwareObject, IlvCrossingAwareObject ilvCrossingAwareObject2, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, float f, float f2, float f3) {
        DrawingParameters drawingParameters = new DrawingParameters(ilvTransformer, ilvCrossingAwareObject, ilvPoint, ilvPoint2, ilvPoint3, ilvPoint4, f3, false);
        if (!drawingParameters.e) {
            return;
        }
        IlvGraphicUtil.DrawPolyline((Graphics)graphics, (IlvPoint[])drawingParameters.a, (int)2, (float)0.0f, (int)0, (int)1, null, (IlvTransformer)ilvTransformer, (boolean)true);
        IlvGraphicUtil.DrawPolyline((Graphics)graphics, (IlvPoint[])drawingParameters.b, (int)2, (float)0.0f, (int)0, (int)1, null, (IlvTransformer)ilvTransformer, (boolean)true);
    }

    @Override
    public boolean containsAtCrossing(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer, IlvCrossingAwareObject ilvCrossingAwareObject, IlvCrossingAwareObject ilvCrossingAwareObject2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, IlvPoint ilvPoint5, IlvPoint ilvPoint6, float f, float f2, float f3) {
        return false;
    }

    @Override
    protected IlvRect calcBoundingBox(IlvTransformer ilvTransformer) {
        float f;
        IlvSegmentedHyperEdge ilvSegmentedHyperEdge = this.a();
        IlvRect ilvRect = ilvSegmentedHyperEdge.boundingBox(ilvTransformer);
        double d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        float f2 = ilvSegmentedHyperEdge.getGap();
        if (ilvSegmentedHyperEdge.isGapZoomable()) {
            f2 = (float)((double)f2 * d);
        }
        if ((f = ilvSegmentedHyperEdge.getLineWidth()) != 0.0f) {
            float f3 = ilvSegmentedHyperEdge.getMaximumLineWidth();
            f = IlvStrokeInfo.zoomedLineWidth((float)f, (float)f3, (IlvTransformer)ilvTransformer, (boolean)true);
        }
        f = (float)((double)f * d);
        IlvRect ilvRect2 = new IlvRect(0.0f, 0.0f, 2.0f * f2 + f, f2);
        IlvPoint ilvPoint = new IlvPoint(0.0f, 0.0f);
        IlvPoint ilvPoint2 = new IlvPoint(2.0f * f2 + f, 0.0f);
        this.addCrossingBound(ilvRect2, ilvTransformer, ilvSegmentedHyperEdge, ilvSegmentedHyperEdge, null, ilvPoint, ilvPoint2, null, 0.0f, 0.0f, f2);
        IlvRect ilvRect3 = new IlvRect(0.0f, 0.0f, f2, 2.0f * f2 + f);
        ilvPoint.move(0.0f, 0.0f);
        ilvPoint2.move(0.0f, 2.0f * f2 + f);
        this.addCrossingBound(ilvRect3, ilvTransformer, ilvSegmentedHyperEdge, ilvSegmentedHyperEdge, null, ilvPoint, ilvPoint2, null, 0.0f, 0.0f, f2);
        ilvRect.x -= 1.5f * ilvRect3.width;
        ilvRect.y -= 1.5f * ilvRect2.height;
        ilvRect.width += 3.0f * ilvRect3.width;
        ilvRect.height += 3.0f * ilvRect2.height;
        return ilvRect;
    }

    @Override
    public void addCrossingBound(IlvRect ilvRect, IlvTransformer ilvTransformer, IlvCrossingAwareObject ilvCrossingAwareObject, IlvCrossingAwareObject ilvCrossingAwareObject2, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, float f, float f2, float f3) {
        DrawingParameters drawingParameters = new DrawingParameters(ilvTransformer, ilvCrossingAwareObject, ilvPoint, ilvPoint2, ilvPoint3, ilvPoint4, f3, true);
        if (!drawingParameters.e) {
            return;
        }
        ilvRect.add(IlvGraphicUtil.PolylineBBox((IlvPoint[])drawingParameters.a, (int)2, (float)0.0f, (int)0, (int)1, null));
        ilvRect.add(IlvGraphicUtil.PolylineBBox((IlvPoint[])drawingParameters.b, (int)2, (float)0.0f, (int)0, (int)1, null));
    }

    @Override
    public boolean zoomable() {
        IlvSegmentedHyperEdge ilvSegmentedHyperEdge = this.a();
        if (ilvSegmentedHyperEdge == null) {
            return true;
        }
        if (ilvSegmentedHyperEdge.getLineWidth() == 0.0f) {
            return false;
        }
        if (!ilvSegmentedHyperEdge.zoomable()) {
            return false;
        }
        return ilvSegmentedHyperEdge.isGapZoomable();
    }

    private IlvSegmentedHyperEdge a() {
        return (IlvSegmentedHyperEdge)this.getRelatedObject();
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("bridgeLengthFactor", this.a);
    }

    class DrawingParameters {
        IlvPoint[] a;
        IlvPoint[] b;
        float c;
        float d;
        boolean e = true;

        DrawingParameters(IlvTransformer ilvTransformer, IlvCrossingAwareObject ilvCrossingAwareObject, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, float f, boolean bl) {
            float f2;
            float f3;
            double d;
            IlvSegmentedHyperEdge ilvSegmentedHyperEdge = (IlvSegmentedHyperEdge)ilvCrossingAwareObject;
            this.d = ilvSegmentedHyperEdge.getLineWidth();
            double d2 = d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (this.d != 0.0f) {
                f3 = ilvSegmentedHyperEdge.getMaximumLineWidth();
                this.d = IlvStrokeInfo.zoomedLineWidth((float)this.d, (float)f3, (IlvTransformer)ilvTransformer, (boolean)bl);
            }
            this.c = (float)((double)this.d * d);
            f3 = ilvPoint3.x - ilvPoint2.x;
            float f4 = ilvPoint3.y - ilvPoint2.y;
            double d3 = Math.sqrt(f3 * f3 + f4 * f4);
            if (d3 == 0.0) {
                this.e = false;
                return;
            }
            float f5 = (float)((double)(0.5f * this.c * f3) / d3);
            if ((d3 = Math.sqrt((f3 -= 2.0f * f5) * f3 + (f4 -= 2.0f * (f2 = (float)((double)(0.5f * this.c * f4) / d3))) * f4)) == 0.0) {
                this.e = false;
                return;
            }
            float f6 = IlvBridgeCrossings.this.a / 2.0f * Math.max(this.c, 1.0f);
            this.a = new IlvPoint[2];
            this.b = new IlvPoint[2];
            float f7 = ilvPoint2.x + f5;
            float f8 = ilvPoint2.y + f2;
            float f9 = ilvPoint3.x - f5;
            float f10 = ilvPoint3.y - f2;
            float f11 = -((float)((double)(f6 * f4) / d3));
            float f12 = (float)((double)(f6 * f3) / d3);
            this.a[0] = new IlvPoint(f7 + f11, f8 + f12);
            this.a[1] = new IlvPoint(f7 - f11, f8 - f12);
            this.b[0] = new IlvPoint(f9 + f11, f10 + f12);
            this.b[1] = new IlvPoint(f9 - f11, f10 - f12);
        }
    }
}

