/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.uniformlengthedges;

import ilog.views.IlvRect;
import ilog.views.graphlayout.IlvGraphLayout;
import ilog.views.graphlayout.IlvGraphLayoutException;
import ilog.views.graphlayout.IlvGraphLayoutReport;
import ilog.views.graphlayout.IlvGraphModel;
import ilog.views.graphlayout.internalutil.FixedNodeInterface;
import ilog.views.graphlayout.internalutil.ReshapeLinkUtil;
import ilog.views.graphlayout.internalutil.genericgrapher.IlvAbstractGraph;
import ilog.views.graphlayout.internalutil.genericgrapher.IlvAbstractNode;
import ilog.views.graphlayout.uniformlengthedges.IlvGraphCoarseningAlgo;
import ilog.views.graphlayout.uniformlengthedges.IlvMultilevelGraphPartitioningAlgo;
import ilog.views.graphlayout.uniformlengthedges.IlvMultipoleULELayout;
import ilog.views.graphlayout.uniformlengthedges.IlvRegularizationAlgo;
import ilog.views.graphlayout.uniformlengthedges.IlvSolarSystemNode;
import ilog.views.graphlayout.uniformlengthedges.IlvUniformLengthEdgesLayout;
import ilog.views.graphlayout.uniformlengthedges.IlvUniformLengthEdgesLayoutReport;
import ilog.views.graphlayout.uniformlengthedges.TopLevelAbstractGraphAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;

final class IlvFMMAlgorithm
implements Serializable {
    private float a;
    private float b;
    private int c;
    private long d;
    private IlvUniformLengthEdgesLayout e;
    private IlvMultipoleULELayout f;

    public IlvFMMAlgorithm(IlvUniformLengthEdgesLayout ilvUniformLengthEdgesLayout) {
        this.e = ilvUniformLengthEdgesLayout;
    }

    public void detach() {
        if (this.f != null) {
            this.f.detach();
        }
    }

    public void doLayout(IlvGraphModel ilvGraphModel, boolean bl) throws IlvGraphLayoutException {
        Object object;
        if (this.e.getLinkStyle() == 1) {
            ReshapeLinkUtil.deleteIntermediatePointsOnLinks(ilvGraphModel, this.e, false);
        }
        this.d = System.currentTimeMillis();
        this.a = this.e.getMaxPercentageOfElapsedTimeForRefinement() / 100.0f;
        this.b = this.e.getMaxPercentageOfTotalAllowedTimeForRefinement() / 100.0f;
        this.c = this.e.getMaxRepeatForConvergence();
        long l = this.e.getAllowedTime();
        this.f = null;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        IlvMultilevelGraphPartitioningAlgo ilvMultilevelGraphPartitioningAlgo = new IlvMultilevelGraphPartitioningAlgo();
        ilvMultilevelGraphPartitioningAlgo.run(ilvGraphModel, arrayList, arrayList2);
        int n = arrayList.size();
        if (n >= 1) {
            IlvAbstractGraph ilvAbstractGraph = null;
            int n2 = n - 1;
            IlvRegularizationAlgo ilvRegularizationAlgo = new IlvRegularizationAlgo();
            for (int i = n2; i >= 0; --i) {
                Object object2;
                IlvAbstractGraph ilvAbstractGraph2 = (IlvAbstractGraph)arrayList.get(i);
                object = (IlvGraphModel)arrayList2.get(i);
                if (i < n2) {
                    ilvAbstractGraph = (IlvAbstractGraph)arrayList.get(i + 1);
                }
                this.a((IlvGraphModel)object, ilvAbstractGraph, n, i, l, false, i == n2, bl);
                if (i < 1) continue;
                IlvAbstractGraph ilvAbstractGraph3 = (IlvAbstractGraph)arrayList.get(i - 1);
                IlvGraphModel ilvGraphModel2 = (IlvGraphModel)arrayList2.get(i - 1);
                Enumeration enumeration = ilvAbstractGraph3.getNodes();
                while (enumeration.hasMoreElements()) {
                    object2 = (IlvSolarSystemNode)enumeration.nextElement();
                    IlvAbstractNode ilvAbstractNode = IlvGraphCoarseningAlgo.getSolarSystemNode((IlvAbstractNode)object2);
                    IlvRect ilvRect = ilvAbstractGraph2.boundingBox(ilvAbstractNode);
                    ilvAbstractGraph3.move((IlvAbstractNode)object2, ilvRect.x, ilvRect.y);
                }
                object2 = ilvGraphModel2;
                if (object2 instanceof TopLevelAbstractGraphAdapter) {
                    ((TopLevelAbstractGraphAdapter)object2).setMoveInOriginalModel(false);
                }
                ilvRegularizationAlgo.regularize((IlvGraphModel)object2, new FixedNodeInterface((IlvGraphModel)object2){
                    final /* synthetic */ IlvGraphModel a;
                    {
                        this.a = ilvGraphModel;
                    }

                    @Override
                    public boolean isFixed(Object object) {
                        IlvSolarSystemNode ilvSolarSystemNode;
                        if (object instanceof IlvSolarSystemNode && (ilvSolarSystemNode = (IlvSolarSystemNode)object).getType() == 0) {
                            return true;
                        }
                        return this.a.getNodeDegree(object) < 2;
                    }
                });
            }
        }
        this.a((IlvGraphModel)arrayList2.get(0), null, n, -1, l, true, false, bl);
        object = (IlvUniformLengthEdgesLayoutReport)this.e.getLayoutReport();
        ((IlvGraphLayoutReport)object).setCode(5);
        ((IlvUniformLengthEdgesLayoutReport)object).b(this.e.getAllowedNumberOfIterations());
    }

    private void a(IlvGraphModel ilvGraphModel, IlvAbstractGraph ilvAbstractGraph, int n, int n2, long l, boolean bl, boolean bl2, boolean bl3) throws IlvGraphLayoutException {
        boolean bl4;
        if (this.f == null) {
            this.f = new IlvMultipoleULELayout(this.e);
            this.f.setRespectNodeSizes(true);
            this.f.setPreserveFixedNodes(this.e.isPreserveFixedNodes());
            this.f.setAdditionalNodeRepulsionWeight(0.2f);
            this.f.setPreferredLinksLength(2.0f * this.e.getPreferredLinksLength());
            this.f.setMaxAllowedMovePerIteration(this.e.getMaxAllowedMovePerIteration());
            this.f.setLinkStyle(0);
            this.f.setLinkLengthWeight(0.1f);
            this.f.setForceFitToLayoutRegion(this.e.isForceFitToLayoutRegion());
            this.f.setLayoutOfConnectedComponentsEnabled(this.e.isLayoutOfConnectedComponentsEnabled());
            IlvGraphLayout ilvGraphLayout = this.e.getLayoutOfConnectedComponents();
            if (ilvGraphLayout != null) {
                this.f.setLayoutOfConnectedComponents(ilvGraphLayout.copy());
            }
        }
        if (this.f.getGraphModel() != ilvGraphModel) {
            boolean bl5 = ilvGraphModel.isInternalGraphModelChecking();
            ilvGraphModel.setInternalGraphModelChecking(false);
            this.f.setGraphModel(ilvGraphModel);
            ilvGraphModel.setInternalGraphModelChecking(bl5);
        }
        if (n2 <= 0) {
            this.f.setPreferredLinksLength(this.e.getPreferredLinksLength());
            this.f.setRespectNodeSizes(this.e.isRespectNodeSizes());
            this.f.setAdditionalNodeRepulsionWeight(this.e.getAdditionalNodeRepulsionWeight());
        }
        this.f.b(bl);
        this.f.setLayoutMode(!bl2 || bl ? 10 : 11);
        if (bl && ilvGraphModel instanceof TopLevelAbstractGraphAdapter) {
            ((TopLevelAbstractGraphAdapter)ilvGraphModel).setMoveInOriginalModel(true);
            float f = this.e.getConvergenceThreshold();
            if (n <= 2) {
                f *= 0.5f;
            }
            this.f.setConvergenceThreshold(f);
            this.f.setLinkLengthWeight(this.e.getLinkLengthWeight());
            this.f.setLinkStyle(this.e.getLinkStyle());
        }
        this.f.d().a(bl2 ? 12 : 10);
        boolean bl6 = bl4 = this.f.getLayoutMode() == 10;
        if (bl4) {
            int n3;
            int n4 = n3 = bl ? 1 : this.c;
            for (int i = 0; !(i >= n3 || i != 0 && this.e.e()); ++i) {
                if (bl) {
                    long l2 = System.currentTimeMillis() - this.d;
                    long l3 = n > 1 ? (long)Math.min(this.a * (float)l2, this.b * (float)l) : l;
                    this.f.setAllowedTime(l3);
                } else {
                    this.f.setAllowedTime(this.e.getRemainingAllowedTime());
                }
                this.f.performLayout(ilvAbstractGraph, bl2, bl3);
                if (!bl || bl2 || n <= 2) continue;
                break;
            }
        } else {
            this.f.setAllowedTime(this.e.getRemainingAllowedTime());
            this.f.performLayout(ilvAbstractGraph, bl2, bl3);
        }
        this.e.callLayoutStepPerformedIfNeeded();
    }
}

