/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.internalutil;

import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.IlvResourceUtil;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LogResUtil {
    public static boolean logExceptions = true;
    public static boolean logStackTrace = false;
    private static boolean a = IlvResourceUtil.isInApplet();
    private static Level b = Level.SEVERE;

    public static void logAndThrowRuntimeExc(Class clazz, String string) {
        LogResUtil.logAndThrowRuntimeExc(clazz, string, null);
    }

    public static void logAndThrowRuntimeExc(Class clazz, String string, Object[] objectArray) {
        LogResUtil.logSevere(clazz, string, objectArray);
        String string2 = LogResUtil.getMessage(clazz, string, objectArray);
        if (string2 != null) {
            throw new RuntimeException(string2);
        }
        throw new RuntimeException();
    }

    public static void logAndThrowRuntimeExc(Class clazz, String string, int n) {
        Object[] objectArray = new Object[]{new Integer(n)};
        LogResUtil.logAndThrowRuntimeExc(clazz, string, objectArray);
    }

    public static void logAndThrowIllegalArgExc(Class clazz, String string) {
        LogResUtil.logAndThrowIllegalArgExc(clazz, string, null);
    }

    public static void logAndThrowIllegalArgExc(Class clazz, String string, Object[] objectArray) {
        LogResUtil.logSevere(clazz, string, objectArray);
        String string2 = LogResUtil.getMessage(clazz, string, objectArray);
        if (string2 != null) {
            throw new IllegalArgumentException(string2);
        }
        throw new IllegalArgumentException();
    }

    public static void logAndThrowIllegalArgExc(Class clazz, String string, boolean bl) {
        Object[] objectArray = new Object[]{new Boolean(bl)};
        LogResUtil.logAndThrowIllegalArgExc(clazz, string, objectArray);
    }

    public static void logAndThrowIllegalArgExc(Class clazz, String string, int n) {
        Object[] objectArray = new Object[]{new Integer(n)};
        LogResUtil.logAndThrowIllegalArgExc(clazz, string, objectArray);
    }

    public static void logAndThrowIllegalArgExc(Class clazz, String string, float f) {
        Object[] objectArray = new Object[]{new Float(f)};
        LogResUtil.logAndThrowIllegalArgExc(clazz, string, objectArray);
    }

    public static void logAndThrowIllegalArgExc(Class clazz, String string, double d) {
        Object[] objectArray = new Object[]{new Double(d)};
        LogResUtil.logAndThrowIllegalArgExc(clazz, string, objectArray);
    }

    public static void logAndThrowIllegalStateExc(Class clazz, String string) {
        LogResUtil.logAndThrowIllegalStateExc(clazz, string, null);
    }

    public static void logAndThrowIllegalStateExc(Class clazz, String string, Object[] objectArray) {
        LogResUtil.logSevere(clazz, string, objectArray);
        String string2 = LogResUtil.getMessage(clazz, string, objectArray);
        if (string2 != null) {
            throw new IllegalStateException(string2);
        }
        throw new IllegalStateException();
    }

    public static void logAndThrowClassCastExc(Class clazz, String string) {
        LogResUtil.logAndThrowClassCastExc(clazz, string, null);
    }

    public static void logAndThrowClassCastExc(Class clazz, String string, Object[] objectArray) {
        LogResUtil.logSevere(clazz, string, objectArray);
        String string2 = LogResUtil.getMessage(clazz, string, objectArray);
        if (string2 != null) {
            throw new ClassCastException(string2);
        }
        throw new ClassCastException();
    }

    public static void logAndThrowNoSuchElementExc(Class clazz, String string) {
        LogResUtil.logAndThrowNoSuchElementExc(clazz, string, null);
    }

    public static void logAndThrowNoSuchElementExc(Class clazz, String string, Object[] objectArray) {
        LogResUtil.logSevere(clazz, string, objectArray);
        String string2 = LogResUtil.getMessage(clazz, string, objectArray);
        if (string2 != null) {
            throw new NoSuchElementException(string2);
        }
        throw new NoSuchElementException();
    }

    public static void logAndThrowUnsupportedOpExc(Class clazz, String string) {
        LogResUtil.logAndThrowUnsupportedOpExc(clazz, string, null);
    }

    public static void logAndThrowUnsupportedOpExc(Class clazz, String string, Object[] objectArray) {
        LogResUtil.logSevere(clazz, string, objectArray);
        String string2 = LogResUtil.getMessage(clazz, string, objectArray);
        if (string2 != null) {
            throw new UnsupportedOperationException(string2);
        }
        throw new UnsupportedOperationException();
    }

    public static String getMessage(Class clazz, String string, Object[] objectArray) {
        String string2 = string;
        if (string2 != null) {
            try {
                ResourceBundle resourceBundle = IlvResourceUtil.getBundle((String)"messages", (Class)clazz, (Locale)IlvLocaleUtil.getCurrentLocale());
                string2 = resourceBundle.getString(string);
                if (objectArray != null && objectArray.length > 0) {
                    try {
                        string2 = MessageFormat.format(string2, objectArray);
                    }
                    catch (Exception exception) {
                        System.err.println("Should not happen: Message format \"" + string2 + "\", with " + objectArray.length + " arguments");
                        exception.printStackTrace();
                    }
                }
            }
            catch (MissingResourceException missingResourceException) {
                System.err.println("Should not happen: Key " + string + " not found in bundle " + clazz.getPackage().getName() + ".messages");
                missingResourceException.printStackTrace();
            }
        }
        return string2;
    }

    public static void logSevere(Class clazz, String string, Object[] objectArray) {
        if (!logExceptions) {
            return;
        }
        ResourceBundle resourceBundle = LogResUtil.a(clazz);
        String string2 = string;
        if (resourceBundle != null) {
            try {
                string2 = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        Logger logger = LogResUtil.a(clazz, resourceBundle != null);
        logger.log(b, string2, objectArray);
        if (logStackTrace) {
            logger.log(b, "Stack trace of previous message", new Exception("Stack trace"));
        }
    }

    private static Logger a(Class clazz, boolean bl) {
        String string = clazz.getPackage().getName();
        if (bl) {
            return Logger.getLogger(string);
        }
        String string2 = clazz.getPackage().getName() + ".messages";
        return Logger.getLogger(string, string2);
    }

    private static ResourceBundle a(Class clazz) {
        if (a) {
            try {
                return IlvResourceUtil.getBundle((String)"messages", (Class)clazz, (Locale)IlvLocaleUtil.getCurrentLocale());
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }
}

