/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.hierarchical;

import ilog.views.IlvRect;
import ilog.views.graphlayout.IlvGraphModel;
import ilog.views.graphlayout.hierarchical.ConstraintManager;
import ilog.views.graphlayout.hierarchical.HGraph;
import ilog.views.graphlayout.hierarchical.IlvHierarchicalConstraint;
import ilog.views.graphlayout.hierarchical.IlvNodeGroup;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import java.io.IOException;

public class IlvSwimLaneConstraint
extends IlvHierarchicalConstraint {
    static final long serialVersionUID = 2589367868901467853L;
    private IlvNodeGroup a;
    private float b;
    private float c;
    private float d;
    private int e;
    private int f;
    private IlvRect g;

    public IlvSwimLaneConstraint(IlvNodeGroup ilvNodeGroup) {
        this(ilvNodeGroup, 0.0f, -1);
    }

    public IlvSwimLaneConstraint(IlvNodeGroup ilvNodeGroup, float f, int n) {
        this(ilvNodeGroup, f, n, 0.0f);
    }

    public IlvSwimLaneConstraint(IlvNodeGroup ilvNodeGroup, float f, int n, float f2) {
        this(ilvNodeGroup, f, n, f2, f2);
    }

    public IlvSwimLaneConstraint(IlvNodeGroup ilvNodeGroup, float f, int n, float f2, float f3) {
        super(Float.MAX_VALUE);
        this.a = ilvNodeGroup;
        this.g = new IlvRect();
        this.f = 0;
        this.setRelativeSize(f);
        this.setSpecPositionIndex(n);
        this.setEastMinMargin(f3);
        this.setWestMinMargin(f2);
    }

    public IlvSwimLaneConstraint(IlvSwimLaneConstraint ilvSwimLaneConstraint) {
        super(ilvSwimLaneConstraint);
        this.a = ilvSwimLaneConstraint.a;
        this.g = new IlvRect(ilvSwimLaneConstraint.g);
        this.b = ilvSwimLaneConstraint.b;
        this.e = ilvSwimLaneConstraint.e;
        this.f = ilvSwimLaneConstraint.f;
        this.c = ilvSwimLaneConstraint.c;
        this.d = ilvSwimLaneConstraint.d;
    }

    public IlvSwimLaneConstraint(IlvInputStream ilvInputStream) throws IOException, IlvReadFileException {
        super(ilvInputStream);
        try {
            this.a = (IlvNodeGroup)ilvInputStream.readPersistentObject("group");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.a = null;
        }
        try {
            this.b = ilvInputStream.readFloat("size");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.b = 0.0f;
        }
        this.d = 0.0f;
        this.c = 0.0f;
        try {
            this.c = this.d = ilvInputStream.readFloat("margin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.c = ilvInputStream.readFloat("eastMinMargin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.d = ilvInputStream.readFloat("westMinMargin");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.e = ilvInputStream.readInt("position");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.e = -1;
        }
        this.g = new IlvRect();
        this.f = 0;
    }

    @Override
    public IlvHierarchicalConstraint copy() {
        return new IlvSwimLaneConstraint(this);
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("group", (IlvPersistentObject)this.getGroup());
        ilvOutputStream.write("size", this.b);
        ilvOutputStream.write("eastMinMargin", this.c);
        ilvOutputStream.write("westMinMargin", this.d);
        ilvOutputStream.write("position", this.e);
    }

    public final IlvNodeGroup getGroup() {
        return this.a;
    }

    public final void setRelativeSize(float f) {
        this.b = f < 0.0f ? 0.0f : f;
    }

    public final float getRelativeSize() {
        return this.b;
    }

    public final void setMinMargin(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        this.c = f;
        this.d = f;
    }

    public final float getMinMargin() {
        return (this.c + this.d) / 2.0f;
    }

    public final void setWestMinMargin(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        this.d = f;
    }

    public final float getWestMinMargin() {
        return this.d;
    }

    public final void setEastMinMargin(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        this.c = f;
    }

    public final float getEastMinMargin() {
        return this.c;
    }

    public final IlvRect getCalcBoundingBox() {
        return new IlvRect(this.g);
    }

    final void a(IlvRect ilvRect) {
        this.g = ilvRect;
    }

    public final void setSpecPositionIndex(int n) {
        this.e = n < 0 ? -1 : n;
    }

    public final int getSpecPositionIndex() {
        return this.e;
    }

    public final int getCalcPositionIndex() {
        return this.f;
    }

    final void a(int n) {
        this.f = n;
    }

    @Override
    final Object c() {
        return this.a;
    }

    @Override
    final void a(Object object) {
        this.a = (IlvNodeGroup)object;
    }

    @Override
    final boolean a(IlvGraphModel ilvGraphModel) {
        return this.a(ilvGraphModel, this.getGroup());
    }

    @Override
    final void a(HGraph hGraph) {
        this.a(true);
        this.a(hGraph, this.getGroup());
    }

    @Override
    final void a(ConstraintManager constraintManager) {
        constraintManager.a(this.getGroup());
    }
}

