/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml;

import java.util.Collections;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.NavigableContext;
import oracle.ide.util.Namespace;
import oracle.jdevimpl.xml.PromptPanel;

public abstract class ParentNavigable
extends Navigable {
    protected ParentNavigable(String label, Class panelClass) {
        super(label, panelClass);
    }

    protected ParentNavigable(String label, String prompt) {
        super(label, PromptPanel.class, new Class[]{String.class}, new Object[]{prompt}, null);
    }

    public DefaultMutableTreeNode createTreeNode(NavigableContext nc) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode((Object)this);
        Namespace dataScope = nc.getScope();
        this.setDataScope(dataScope);
        Iterator iter = this.getChildIterator(dataScope);
        while (iter.hasNext()) {
            Object dataObj = iter.next();
            node.add(this.createTreeNode(nc, dataObj));
        }
        return node;
    }

    protected Iterator emptyIterator() {
        return Collections.EMPTY_LIST.iterator();
    }

    protected static DefaultMutableTreeNode createTreeNode(NavigableContext nc, Object data, String dataKey, String treeNodeLabel, Class panelClass, Navigable[] childNavigables) {
        return ParentNavigable.createTreeNode(nc, data, dataKey, new Navigable(treeNodeLabel, panelClass, childNavigables));
    }

    protected static DefaultMutableTreeNode createTreeNode(NavigableContext nc, Object data, String dataKey, String treeNodeLabel, Class panelClass, Navigable[] childNavigables, String helpID) {
        Navigable nav = new Navigable(treeNodeLabel, panelClass, childNavigables);
        nav.setHelpID(helpID);
        return ParentNavigable.createTreeNode(nc, data, dataKey, nav);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DefaultMutableTreeNode createTreeNode(NavigableContext nc, Object data, String dataKey, Navigable nav) {
        DefaultMutableTreeNode treeNode = null;
        if (data != null) {
            Namespace scope = new Namespace();
            scope.findAndReplace(dataKey, data);
            nc.pushAnonymousScope(scope, nav);
            try {
                treeNode = nav.createTreeNode(nc);
            }
            finally {
                nc.popScope();
            }
        }
        return treeNode;
    }

    protected abstract Iterator getChildIterator(Namespace var1);

    protected abstract DefaultMutableTreeNode createTreeNode(NavigableContext var1, Object var2);
}

