/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.bali.share.datatransfer.ObjectTransferable;
import oracle.bali.share.datatransfer.TransferUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controls.DescriptionScrollPane;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.controls.SortedListModel;
import oracle.ide.extension.feature.Feature;
import oracle.ide.extension.feature.FeatureType;
import oracle.ide.extension.feature.TechnologyFeatureType;
import oracle.ide.model.Project;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeDetector;
import oracle.ide.model.TechnologyScopeManager;
import oracle.ide.model.Workspace;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.nicelist.NiceList;
import oracle.javatools.controls.nicelist.NiceListRenderer;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.model.ConfirmDeleteTechScopesDialog;
import oracle.jdeveloper.model.JDevTechnologyInfo;
import oracle.jdeveloper.model.JDevTechnologyRegistry;
import oracle.jdeveloper.resource.TechArb;

final class FeaturesPanel
extends DefaultTraversablePanel {
    static final String SELECTED_FEATURES = "selectedTechnologies";
    static final String FIXED_FEATURES = "fixedTechnologies";
    private final transient HashMap<String, TechInfo> _featureCache = new HashMap();
    private final PropertyChangeSupport _propertyChangeSupport = new PropertyChangeSupport((Object)this);
    private transient TechId[] _selectedTechnologies = new TechId[0];
    private transient TechId[] _fixedTechnologies = new TechId[0];
    private transient TraversableContext _dataContext;
    private final EditMode _editMode;
    private DefaultTraversablePanel _contentPanel;

    public FeaturesPanel(EditMode editMode) {
        this._editMode = editMode;
    }

    private DefaultTraversablePanel createGui(EditMode editMode) {
        switch (editMode) {
            case EDITABLE: {
                return new FeatureShuttlePanel();
            }
            case READ_ONLY: {
                return new FeatureListPanel(false);
            }
            case DEFERRED_EDIT_WITH_UPDATE: {
                return new FeatureListPanel(true);
            }
        }
        return null;
    }

    public void onEntry(TraversableContext dataContext) {
        if (this._dataContext == null) {
            TechId[] fixedTechnologies;
            TechId[] selectedTechnologies = (TechId[])dataContext.get(SELECTED_FEATURES);
            if (selectedTechnologies != null) {
                this._selectedTechnologies = selectedTechnologies;
            }
            if ((fixedTechnologies = (TechId[])dataContext.get(FIXED_FEATURES)) != null) {
                this._fixedTechnologies = fixedTechnologies;
            }
            this._dataContext = dataContext;
        }
        if (this._contentPanel == null) {
            this._contentPanel = this.createGui(this._editMode);
            this.setLayout(new BorderLayout());
            this.add((Component)this._contentPanel, "Center");
        }
        this._contentPanel.onEntry(dataContext);
    }

    private void setTechnologyKeys(TechId ... ids) {
        if (ids.length != this._selectedTechnologies.length || !this.scopesAreEqual(this._selectedTechnologies, ids)) {
            this.firePropertyChange(SELECTED_FEATURES, this._selectedTechnologies, ids);
        }
        this._selectedTechnologies = ids;
    }

    private boolean scopesAreEqual(TechId[] one, TechId[] another) {
        TechnologyScope orig = new TechnologyScope();
        for (TechId techId : one) {
            orig.add(techId);
        }
        TechnologyScope newScope = new TechnologyScope();
        for (TechId techId : another) {
            newScope.add(techId);
        }
        return orig.equals((Object)newScope);
    }

    TechnologyScope getTechnologyScope() {
        TechnologyScope scope = new TechnologyScope();
        for (TechId techId : this._selectedTechnologies) {
            if (!techId.isVisible()) continue;
            scope.add(techId);
        }
        return scope;
    }

    final synchronized void addFeatureChangeListener(PropertyChangeListener listener) {
        this._propertyChangeSupport.addPropertyChangeListener(SELECTED_FEATURES, listener);
    }

    final synchronized void removeFeatureChangeListener(PropertyChangeListener listener) {
        this._propertyChangeSupport.removePropertyChangeListener(SELECTED_FEATURES, listener);
    }

    private Workspace getWorkspace() {
        return this.getContext().getWorkspace() != null ? this.getContext().getWorkspace() : Ide.getActiveWorkspace();
    }

    private Project getProject() {
        Project project;
        if (this._dataContext != null && (project = (Project)this._dataContext.get("Project")) != null) {
            return project;
        }
        return this.getContext().getProject() != null ? this.getContext().getProject() : Ide.getActiveProject();
    }

    private Context getContext() {
        Context context;
        if (this._dataContext != null && (context = (Context)this._dataContext.get(Context.class)) != null) {
            return context;
        }
        return Context.newIdeContext();
    }

    private final TechInfo newTechInfo(TechId techId) {
        String techKey = techId.getKey();
        if (this._featureCache.containsKey(techKey)) {
            return this._featureCache.get(techKey);
        }
        List features = ExtensionRegistry.getExtensionRegistry().getFeatureRegistry().getFeatures();
        for (Feature feature : features) {
            if (this._featureCache.containsKey(feature.getId())) continue;
            FeatureType featureType = feature.getType();
            if (featureType instanceof TechnologyFeatureType) {
                String key = ((TechnologyFeatureType)featureType).getTechnologyKey();
                if (!techKey.equals(key)) continue;
                TechInfo tInfo = new TechInfo(techId, feature);
                this._featureCache.put(techKey, tInfo);
                return tInfo;
            }
            this._featureCache.put(feature.getId(), null);
        }
        TechInfo info = new TechInfo(techId);
        this._featureCache.put(techId.getKey(), info);
        return info;
    }

    static /* synthetic */ TechId[] access$002(FeaturesPanel x0, TechId[] x1) {
        x0._selectedTechnologies = x1;
        return x1;
    }

    static enum EditMode {
        EDITABLE,
        READ_ONLY,
        DEFERRED_EDIT_WITH_UPDATE;

    }

    private class FeatureShuttlePanel
    extends DefaultTraversablePanel {
        private JPanel _technologiesPanel = new JPanel();
        private FilesPanel _generatedComponentsPanel = new FilesPanel();
        private LibrariesPanel _librariesPanel = new LibrariesPanel();
        private final DefaultListModel _fromModel = new SortedListModel();
        private final DefaultListModel _toModel = new SortedListModel();
        private final DefaultListCellRenderer _renderer = new LRenderer();
        private final JTabbedPane _tabs = new JTabbedPane();
        private final GridBagLayout _layout = new GridBagLayout();
        private final JLabel _fromLabel = new JLabel();
        private final JList _fromList = new JList();
        private final JLabel _toLabel = new JLabel();
        private final JList _toList = new JList();
        private final Shuttle _technologiesShuttle = new Shuttle();
        private final JLabel _descriptionLabel = new JLabel();
        private final DescriptionScrollPane _descriptionScrollPane = new DescriptionScrollPane();
        private final ListPicker _fromPicker = new CustomFromListPicker(this._fromList);
        private final ListPicker _toPicker = new CustomToListPicker(this._toList);

        public FeatureShuttlePanel() {
            try {
                this.createGui();
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }

        public void onEntry(TraversableContext dataContext) {
            this.populateModels(FeaturesPanel.this._selectedTechnologies);
        }

        private void createGui() {
            EventAdapter eventAdapter = new EventAdapter();
            this._fromList.addFocusListener(eventAdapter);
            this._fromList.addListSelectionListener(eventAdapter);
            this._toList.addFocusListener(eventAdapter);
            this._toList.addListSelectionListener(eventAdapter);
            this._technologiesShuttle.addShuttleListener((ShuttleListener)eventAdapter);
            this._fromList.setModel(this._fromModel);
            this._fromList.setSelectionMode(2);
            this._fromPicker.setItemsSorted(true);
            this._toList.setModel(this._toModel);
            this._toList.setCellRenderer(this._renderer);
            this._toList.setSelectionMode(2);
            this._toPicker.setItemsSorted(true);
            ResourceUtils.resLabel((JLabel)this._fromLabel, (Component)this._fromList, (String)TechArb.getString(10));
            ResourceUtils.resLabel((JLabel)this._toLabel, (Component)this._toList, (String)TechArb.getString(11));
            ResourceUtils.resLabel((JLabel)this._descriptionLabel, (Component)this._descriptionScrollPane.getLabelComponent(), (String)TechArb.getString(12));
            Border headerLabelBorder = BorderFactory.createEmptyBorder(0, 0, 2, 0);
            this._fromLabel.setBorder(headerLabelBorder);
            this._toLabel.setBorder(headerLabelBorder);
            this._technologiesShuttle.setButtonsShown(5);
            this._technologiesShuttle.add((Component)this._fromLabel, (Object)"FromHeader");
            this._technologiesShuttle.setFromPicker((ItemPicker)this._fromPicker);
            this._technologiesShuttle.add((Component)this._toLabel, (Object)"ToHeader");
            this._technologiesShuttle.setToPicker((ItemPicker)this._toPicker);
            this._technologiesPanel.setLayout(this._layout);
            this._technologiesPanel.add((Component)this._technologiesShuttle, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.8, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this._technologiesPanel.add((Component)this._descriptionLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 2, 0), 0, 0));
            this._technologiesPanel.add((Component)this._descriptionScrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.2, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            int margin = 10;
            this._technologiesPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            Border border = BorderFactory.createEmptyBorder(10, 10, 10, 10);
            this._generatedComponentsPanel.setBorder(border);
            this._librariesPanel.setBorder(border);
            String label0 = TechArb.getString(1);
            int mnemonic0 = StringUtils.getMnemonicKeyCode((String)label0);
            String slabel0 = StringUtils.stripMnemonic((String)label0);
            this._tabs.add((Component)this._technologiesPanel, slabel0);
            this._tabs.setMnemonicAt(0, mnemonic0);
            String label1 = TechArb.getString(2);
            int mnemonic1 = StringUtils.getMnemonicKeyCode((String)label1);
            String slabel1 = StringUtils.stripMnemonic((String)label1);
            this._tabs.add((Component)this._generatedComponentsPanel, slabel1);
            this._tabs.setMnemonicAt(1, mnemonic1);
            String label2 = TechArb.getString(7);
            int mnemonic2 = StringUtils.getMnemonicKeyCode((String)label2);
            String slabel2 = StringUtils.stripMnemonic((String)label2);
            this._tabs.add((Component)this._librariesPanel, slabel2);
            this._tabs.setMnemonicAt(2, mnemonic2);
            this.setLayout(new BorderLayout());
            this.add(this._tabs, "Center");
        }

        private boolean canRemoveTechId(TechId techId) {
            for (TechId id : FeaturesPanel.this._fixedTechnologies) {
                if (!id.equals(techId)) continue;
                return false;
            }
            return true;
        }

        private void populateModels(TechId ... techIds) {
            TechId techId;
            int i;
            TechnologyRegistry techReg = TechnologyRegistry.getInstance();
            TechId[] technologies = techReg.getVisibleTechIds();
            this._fromModel.clear();
            this._fromModel.ensureCapacity(technologies.length);
            for (i = 0; i < technologies.length; ++i) {
                techId = technologies[i];
                TechInfo info = FeaturesPanel.this.newTechInfo(techId);
                this._fromModel.addElement(info);
            }
            for (i = this._toModel.size() - 1; i >= 0; --i) {
                TechInfo feature = (TechInfo)this._toModel.getElementAt(i);
                if (!this.canRemoveTechId(feature.getTechId())) continue;
                this._toModel.remove(i);
            }
            this._toModel.ensureCapacity(techIds.length);
            for (i = 0; i < techIds.length; ++i) {
                TechInfo techInfo;
                techId = techIds[i];
                if (!techId.isVisible() || !this._fromModel.contains(techInfo = FeaturesPanel.this.newTechInfo(techId))) continue;
                this._fromModel.removeElement(techInfo);
                if (this._toModel.contains(techInfo)) continue;
                this._toModel.addElement(techInfo);
            }
            this._fromList.ensureIndexIsVisible(0);
            this._fromList.setSelectedIndex(0);
            this._toList.ensureIndexIsVisible(0);
            this._toList.setSelectedIndex(0);
            this._generatedComponentsPanel.setTechnologies(techIds);
            this._librariesPanel.setTechnologies(techIds);
        }

        private class LRenderer
        extends DefaultListCellRenderer {
            final Color selectedForeground;
            final SystemColor unselectedForeground;

            LRenderer() {
                UIDefaults uid = UIManager.getLookAndFeel().getDefaults();
                this.selectedForeground = uid.getColor("List.selectionForeground");
                this.unselectedForeground = SystemColor.textInactiveText;
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel l = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                TechInfo techFeature = (TechInfo)value;
                if (!FeatureShuttlePanel.this.canRemoveTechId(techFeature.getTechId())) {
                    l.setForeground(isSelected ? this.selectedForeground : this.unselectedForeground);
                }
                return l;
            }
        }

        private class CustomToListPicker
        extends ListPicker {
            public CustomToListPicker(JList list) {
                super(list);
            }

            private boolean hasUnmoveableItems() {
                return FeaturesPanel.this._fixedTechnologies.length > 0 && !this.getList().isSelectionEmpty();
            }

            public boolean isItemSelected() {
                TechInfo[] infos;
                if (!FeaturesPanel.this.isEnabled()) {
                    return false;
                }
                if (!this.hasUnmoveableItems()) {
                    return super.isItemSelected();
                }
                for (TechInfo tech : infos = this.getSelectedTechInfos()) {
                    if (!FeatureShuttlePanel.this.canRemoveTechId(tech._techId)) continue;
                    return true;
                }
                return false;
            }

            public boolean isSelectableItemPresent() {
                TechInfo[] infos;
                if (!FeaturesPanel.this.isEnabled()) {
                    return false;
                }
                if (!this.hasUnmoveableItems()) {
                    return super.isSelectableItemPresent();
                }
                for (TechInfo tech : infos = this.getSelectedTechInfos()) {
                    if (!FeatureShuttlePanel.this.canRemoveTechId(tech.getTechId())) continue;
                    return true;
                }
                return false;
            }

            public Transferable[] getSelectedItems() {
                if (!FeaturesPanel.this.isEnabled()) {
                    return new Transferable[0];
                }
                if (!this.hasUnmoveableItems()) {
                    return super.getSelectedItems();
                }
                TechInfo[] infos = this.getSelectedTechInfos();
                ArrayList<Transferable> list = new ArrayList<Transferable>();
                for (TechInfo info : infos) {
                    if (!FeatureShuttlePanel.this.canRemoveTechId(info._techId)) continue;
                    list.add(this.createTransferable(info));
                }
                return list.toArray(new Transferable[list.size()]);
            }

            public Transferable[] getAllSelectableItems() {
                if (!this.hasUnmoveableItems()) {
                    return super.getAllSelectableItems();
                }
                ListModel listModel = this.getList().getModel();
                int size = listModel.getSize();
                if (size == 0) {
                    ArrayList<Transferable> transferables = new ArrayList<Transferable>();
                    for (int i = 0; i < size; ++i) {
                        Object element = listModel.getElementAt(i);
                        if (!FeatureShuttlePanel.this.canRemoveTechId((TechId)element)) continue;
                        transferables.add(this.createTransferable(element));
                    }
                    return transferables.toArray(new Transferable[transferables.size()]);
                }
                return new Transferable[0];
            }

            private TechInfo[] getSelectedTechInfos() {
                ListModel listModel = this.getList().getModel();
                int size = listModel.getSize();
                if (size > 0) {
                    int[] indices;
                    ArrayList<TechInfo> techinfos = new ArrayList<TechInfo>(size);
                    for (int index : indices = this.getList().getSelectedIndices()) {
                        techinfos.add((TechInfo)listModel.getElementAt(index));
                    }
                    return techinfos.toArray(new TechInfo[techinfos.size()]);
                }
                return new TechInfo[0];
            }
        }

        private class CustomFromListPicker
        extends ListPicker {
            public CustomFromListPicker(JList list) {
                super(list);
            }

            public boolean isSelectableItemPresent() {
                if (!FeaturesPanel.this.isEnabled()) {
                    return false;
                }
                return super.isSelectableItemPresent();
            }
        }

        class LibrariesPanel
        extends TechScopeAssociationsPanel {
            final String[] columns;

            public LibrariesPanel() {
                this.columns = new String[]{"", TechArb.getString(9)};
            }

            @Override
            protected Vector getDataVector() {
                Vector data = new Vector();
                for (TechId technology : this._technologies) {
                    JDevTechnologyRegistry jdevTechnologyRegistry = JDevTechnologyRegistry.getInstance();
                    JDevTechnologyInfo jdevTechInfo = jdevTechnologyRegistry.getJDevTechnologyInfo(technology);
                    if (jdevTechInfo == null) continue;
                    for (JDevTechnologyInfo.LibraryInfo libInfo : jdevTechInfo.getLibraries()) {
                        Assert.println((libInfo.getName() == null ? 1 : 0) != 0, (String)("Library dependencies for the " + jdevTechInfo.getTechId() + " technology scope may not be defined correctly."));
                        if (libInfo.getName() == null) continue;
                        Vector<String> v = new Vector<String>();
                        v.add(libInfo.getDescription());
                        v.add(libInfo.getName());
                        data.add(v);
                    }
                }
                return data;
            }

            @Override
            protected Vector getColumnsVector() {
                return new Vector<String>(Arrays.asList(this.columns));
            }

            @Override
            protected String getTitle() {
                return TechArb.getString(8);
            }
        }

        class FilesPanel
        extends TechScopeAssociationsPanel {
            final String[] columns;

            public FilesPanel() {
                this.columns = new String[]{"", TechArb.getString(4), TechArb.getString(5), TechArb.getString(6)};
            }

            @Override
            protected Vector getDataVector() {
                Vector data = new Vector();
                for (TechId technology : this._technologies) {
                    JDevTechnologyInfo.GeneratedFileInfo[] files;
                    JDevTechnologyRegistry jdevTechnologyRegistry = JDevTechnologyRegistry.getInstance();
                    JDevTechnologyInfo jdevTechInfo = jdevTechnologyRegistry.getJDevTechnologyInfo(technology);
                    if (jdevTechInfo == null || (files = jdevTechInfo.getGeneratedFiles()) == null || files.length <= 0) continue;
                    for (JDevTechnologyInfo.GeneratedFileInfo file : files) {
                        Vector<String> v = new Vector<String>();
                        v.add(ModelUtil.hasLength((String)file.getDescription()) ? file.getDescription() : file.toString());
                        v.add(file.getName());
                        v.add(file.getPath());
                        v.add(file.getFileType());
                        data.add(v);
                    }
                }
                return data;
            }

            @Override
            protected Vector getColumnsVector() {
                return new Vector<String>(Arrays.asList(this.columns));
            }

            @Override
            protected String getTitle() {
                return TechArb.getString(3);
            }
        }

        private abstract class TechScopeAssociationsPanel
        extends JPanel
        implements ListSelectionListener {
            protected TechId[] _technologies;
            private final BorderLayout _layout = new BorderLayout(0, 8);
            private final JSplitPane _splitPane = new JSplitPane();
            private final JWrappedLabel _tableLabel = new JWrappedLabel();
            protected final DefaultTableModel _model = new NonEditableTableModel();
            private final JTable _table = new JTable(this._model);
            private final DescriptionScrollPane _descriptionScrollPane = new DescriptionScrollPane();

            TechScopeAssociationsPanel() {
                this._tableLabel.setText(this.getTitle());
                this._tableLabel.setForeground(Colors.HINT_TEXT);
                this._table.setDragEnabled(false);
                this._table.setSelectionMode(0);
                this._table.setColumnSelectionAllowed(false);
                this._table.setRowSelectionAllowed(true);
                this._table.getSelectionModel().addListSelectionListener(this);
                JScrollPane listScroller = new JScrollPane(this._table);
                listScroller.setBorder(BorderFactory.createEmptyBorder());
                listScroller.setHorizontalScrollBarPolicy(31);
                listScroller.setVerticalScrollBarPolicy(20);
                this._descriptionScrollPane.setBorder(null);
                this._descriptionScrollPane.setHorizontalScrollBarPolicy(31);
                this._descriptionScrollPane.setVerticalScrollBarPolicy(20);
                this._splitPane.setResizeWeight(0.7);
                this._splitPane.setOrientation(0);
                this._splitPane.setTopComponent(listScroller);
                this._splitPane.setBottomComponent((Component)this._descriptionScrollPane);
                this.setLayout(this._layout);
                this.add((Component)this._tableLabel, "North");
                this.add((Component)this._splitPane, "Center");
            }

            protected void setTechnologies(TechId[] techIds) {
                if (!Arrays.equals(this._technologies, techIds)) {
                    this._technologies = techIds;
                    this.refreshList();
                }
            }

            private void refreshList() {
                this._model.getDataVector().clear();
                if (this._technologies != null) {
                    int r = this._table.getSelectedRow();
                    int c = this._table.getSelectedColumn();
                    this._model.setDataVector(this.getDataVector(), this.getColumnsVector());
                    if (r >= 0 && c >= 0 && r < this._model.getRowCount() && c < this._model.getColumnCount()) {
                        this._table.changeSelection(r, c, true, true);
                    }
                }
                this._model.fireTableDataChanged();
                this._table.removeColumn(this._table.getColumnModel().getColumn(0));
            }

            protected abstract Vector getDataVector();

            protected abstract Vector getColumnsVector();

            protected abstract String getTitle();

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (this._table.getSelectedRow() == -1) {
                        this._descriptionScrollPane.setText(null);
                    } else {
                        String desc = (String)this._model.getValueAt(this._table.getSelectedRow(), 0);
                        this._descriptionScrollPane.setText(desc == null ? "" : desc);
                    }
                }
            }

            private class NonEditableTableModel
            extends DefaultTableModel {
                private NonEditableTableModel() {
                }

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            }
        }

        private final class EventAdapter
        implements FocusListener,
        ListSelectionListener,
        ShuttleListener {
            private EventAdapter() {
            }

            @Override
            public void focusGained(FocusEvent event) {
                this.updateDescription((JList)event.getSource());
            }

            @Override
            public void focusLost(FocusEvent event) {
            }

            @Override
            public void valueChanged(ListSelectionEvent event) {
                this.updateDescription((JList)event.getSource());
            }

            public void shuttleItemsMoved(ShuttleEvent event) {
                TechnologyScope copy = new TechnologyScope(FeaturesPanel.this.getTechnologyScope());
                Transferable[] items = event.getItems();
                for (int i = 0; i < items.length; ++i) {
                    TechInfo info = this.extractTechInfo(items[i]);
                    if (info == null) continue;
                    copy.add(info.getTechId());
                }
                int anchor = FeatureShuttlePanel.this._fromList.getAnchorSelectionIndex();
                TechId[] techIds = copy.toArray();
                FeatureShuttlePanel.this.populateModels(techIds);
                FeaturesPanel.this.setTechnologyKeys(techIds);
                this.restoreRelativeSelection(FeatureShuttlePanel.this._fromList, anchor);
            }

            public void shuttleItemsRemoved(ShuttleEvent event) {
                TechnologyScope copy = new TechnologyScope(FeaturesPanel.this.getTechnologyScope());
                Transferable[] items = event.getItems();
                for (int i = 0; i < items.length; ++i) {
                    TechInfo info = this.extractTechInfo(items[i]);
                    if (info == null || !FeatureShuttlePanel.this.canRemoveTechId(info.getTechId())) continue;
                    copy.remove(info.getTechId());
                }
                int anchor = FeatureShuttlePanel.this._toList.getAnchorSelectionIndex();
                TechId[] techIds = copy.toArray();
                FeatureShuttlePanel.this.populateModels(techIds);
                FeaturesPanel.this.setTechnologyKeys(techIds);
                this.restoreRelativeSelection(FeatureShuttlePanel.this._toList, anchor);
            }

            private void restoreRelativeSelection(JList list, int lastIndex) {
                int maxIndex = list.getModel().getSize() - 1;
                int index = Math.min(lastIndex, maxIndex);
                list.setSelectedIndex(index);
            }

            public void shuttleItemsReordered(ShuttleEvent event) {
            }

            private void updateDescription(JList list) {
                TechInfo info = (TechInfo)list.getSelectedValue();
                if (info != null) {
                    FeatureShuttlePanel.this._descriptionScrollPane.setText(info.getDescription());
                    ResourceUtils.resLabel((JLabel)FeatureShuttlePanel.this._descriptionLabel, (Component)FeatureShuttlePanel.this._descriptionScrollPane, (String)TechArb.format(13, info.getName()));
                } else {
                    FeatureShuttlePanel.this._descriptionScrollPane.setText(null);
                    ResourceUtils.resLabel((JLabel)FeatureShuttlePanel.this._descriptionLabel, (Component)FeatureShuttlePanel.this._descriptionScrollPane, (String)TechArb.getString(12));
                }
            }

            private TechInfo extractTechInfo(Transferable t) {
                if (t instanceof ObjectTransferable) {
                    ObjectTransferable item = (ObjectTransferable)t;
                    DataFlavor flavor = TransferUtils.getDataFlavor(TechInfo.class);
                    try {
                        return (TechInfo)item.getTransferData(flavor);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
        }
    }

    private final class FeatureListPanel
    extends DefaultTraversablePanel {
        private DefaultListModel _listModel = new SortedListModel();
        private final NiceList _featureList = new NiceList();
        private final JLabel _listLabel = new JLabel();
        private final ControlBar _toolbar = new ControlBar();
        private final JButton _addButton = new JButton();
        private final JButton _updateButton = new JButton();

        public FeatureListPanel(boolean showUpdateButton) {
            try {
                this.createGui(showUpdateButton);
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }

        public void onEntry(TraversableContext dataContext) {
            if (this.featuresInSync()) {
                this._updateButton.setEnabled(false);
            }
            this.populateList(FeaturesPanel.this._selectedTechnologies);
        }

        private boolean featuresInSync() {
            return Boolean.TRUE.equals(FeaturesPanel.this._dataContext.get("reconciled-features"));
        }

        private void setFeaturesInSync(boolean inSync) {
            if (inSync) {
                FeaturesPanel.this._dataContext.put("reconciled-features", (Object)Boolean.TRUE);
            } else {
                FeaturesPanel.this._dataContext.remove("reconciled-features");
            }
            this._updateButton.setEnabled(!inSync);
        }

        private void createGui(boolean showUpdateButton) {
            ResourceUtils.resLabel((JLabel)this._listLabel, (Component)this._featureList, (String)TechArb.getString(15));
            NLR listRenderer = new NLR();
            listRenderer.setForeground(Colors.GRADIENT_SELECTION_LIGHT);
            this._featureList.setCellRenderer((ListCellRenderer)((Object)listRenderer));
            this._featureList.setModel((ListModel)this._listModel);
            this.setLayout(new BorderLayout(0, 8));
            JScrollPane scroller = new JScrollPane((Component)this._featureList, 20, 31);
            ComponentWithTitlebar titledComp = new ComponentWithTitlebar((JComponent)scroller, this._listLabel, this._toolbar);
            this.add((Component)titledComp, "Center");
            if (showUpdateButton) {
                this._addButton.setIcon(OracleIcons.getIcon((String)"add.png"));
                this._addButton.setToolTipText(TechArb.getString(17));
                ResourceUtils.resButton((AbstractButton)this._updateButton, (String)TechArb.getString(16));
                GuiHandler actionListener = new GuiHandler();
                this._addButton.addActionListener(actionListener);
                this._updateButton.addActionListener(actionListener);
                this._toolbar.add((Component)this._addButton);
                this._toolbar.add((Component)this._updateButton);
                JWrappedLabel header = new JWrappedLabel(TechArb.getString(14));
                header.setForeground(Colors.HINT_TEXT);
                this.add((Component)header, "North");
            }
        }

        private List<TechId> calculateDiff(TechId[] a, TechId[] b) {
            List<TechId> aList = a != null ? Arrays.asList(a) : Collections.EMPTY_LIST;
            List<TechId> bList = b != null ? Arrays.asList(b) : Collections.EMPTY_LIST;
            ArrayList<TechId> removed = new ArrayList<TechId>(aList);
            removed.removeAll(bList);
            return removed;
        }

        private String calculateChange(TechId[] origIds, TechId[] newIds, List<TechId> userWantsToRemoveIds, boolean userPrompted) {
            List<TechId> removed = this.calculateDiff(origIds, newIds);
            List<TechId> added = this.calculateDiff(newIds, origIds);
            if (!userPrompted && removed.isEmpty() && added.isEmpty()) {
                return TechArb.getString(23);
            }
            StringBuilder b = new StringBuilder();
            if (!added.isEmpty()) {
                b.append("\n\n");
                b.append(TechArb.getString(25));
                Collections.sort(added);
                this.buildFeaturesList(added, b);
            }
            if (!removed.isEmpty()) {
                b.append(TechArb.getString(26));
                Collections.sort(removed);
                this.buildFeaturesList(removed, b);
            }
            if (!userWantsToRemoveIds.isEmpty()) {
                List<TechId> newIdsList = Arrays.asList(newIds);
                for (TechId id : userWantsToRemoveIds) {
                    if (!newIdsList.contains(id)) continue;
                    b.append("\n\n");
                    b.append(TechArb.getString(24));
                    break;
                }
            }
            return b.toString().trim();
        }

        private void buildFeaturesList(List<TechId> removed, StringBuilder b) {
            String delim = " ";
            for (TechId t : removed) {
                b.append(delim);
                b.append(new TechInfo(t).toString());
                delim = ", ";
            }
            b.append(". ");
        }

        private void showFeedback(String feedbackText) {
            MessageDialog.information((Component)((Object)this), (Object)feedbackText, (String)TechArb.getString(22), null);
        }

        private void populateList(TechId ... techIds) {
            this._listModel.clear();
            if (techIds.length > 0) {
                for (TechId techId : techIds) {
                    if (!techId.isVisible()) continue;
                    TechInfo info = FeaturesPanel.this.newTechInfo(techId);
                    this._listModel.addElement(info);
                }
            }
        }

        private void editFeatures() {
            FeatureShuttlePanel shuttle = new FeatureShuttlePanel();
            shuttle.setPreferredSize(new Dimension(500, 325));
            JPanel panel = new JPanel(new BorderLayout(0, 16));
            JLabel header = new JLabel(TechArb.getString(18));
            panel.add((Component)header, "North");
            panel.add((Component)((Object)shuttle), "Center");
            int buttonMask = 7;
            String title = TechArb.getString(17);
            JEWTDialog dlg = JEWTDialog.createDialog((Component)((Object)FeaturesPanel.this), (String)title, (int)7);
            HelpUtils.setHelpID((JComponent)panel, (String)"f1_idedaddfeatures_html");
            dlg.setContent((Component)panel);
            dlg.pack();
            dlg.setResizable(true);
            TechId[] backup = FeaturesPanel.this._selectedTechnologies;
            shuttle.onEntry(FeaturesPanel.this._dataContext);
            if (dlg.runDialog()) {
                FeaturesPanel.this.setTechnologyKeys(FeaturesPanel.this._selectedTechnologies);
                this.populateList(FeaturesPanel.this._selectedTechnologies);
                if (backup.length != FeaturesPanel.this._selectedTechnologies.length) {
                    this.setFeaturesInSync(false);
                }
            } else {
                FeaturesPanel.access$002(FeaturesPanel.this, backup);
            }
        }

        private void detectTechnologies() {
            final IndeterminateProgressMonitor monitor = new IndeterminateProgressMonitor((Component)((Object)this), TechArb.getString(19), (Object)TechArb.getString(20), TechArb.getString(21));
            monitor.setCancellable(false);
            monitor.setCloseOnFinish(true);
            HashSet<String> result = new HashSet<String>();
            DetectorRunnable runnable = new DetectorRunnable(result);
            final FutureTask<HashSet<String>> future = new FutureTask<HashSet<String>>(runnable, result);
            ExecutorService executor = Executors.newCachedThreadPool();
            class MonitorProgressRunnable
            implements Runnable {
                MonitorProgressRunnable() {
                }

                @Override
                public void run() {
                    monitor.start();
                    while (!monitor.isCancelled()) {
                        try {
                            Thread.sleep(1000L);
                            if (monitor.isCanceled()) {
                                future.cancel(true);
                            }
                            if (!future.isDone()) continue;
                            break;
                        }
                        catch (Exception e) {
                            monitor.close();
                        }
                    }
                    try {
                        final Collection techScopes = (Collection)future.get();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                boolean userMustConfirm;
                                monitor.close();
                                TechnologyScope reconciledScope = new TechnologyScope();
                                for (String id : techScopes) {
                                    TechId techId = TechnologyRegistry.getInstance().getTechId(id);
                                    if (techId != null) {
                                        reconciledScope.add(techId);
                                        continue;
                                    }
                                    Assert.println((String)("Detected technology " + id + " was not registered in oracle.ide.model.TechnologyRegistry"));
                                }
                                TechId[] originalIds = (TechId[])FeaturesPanel.this._selectedTechnologies.clone();
                                ArrayList<TechId> leftInIds = new ArrayList<TechId>();
                                List removedIds = FeatureListPanel.this.calculateDiff(originalIds, reconciledScope.toArray());
                                ArrayList userConfirmedRemovalOfIds = new ArrayList(removedIds);
                                boolean bl = userMustConfirm = !removedIds.isEmpty();
                                if (userMustConfirm) {
                                    Collections.sort(removedIds);
                                    ConfirmDeleteTechScopesDialog confirmDialog = new ConfirmDeleteTechScopesDialog((Component)((Object)FeaturesPanel.this), removedIds);
                                    if (!confirmDialog.runDialog()) {
                                        FeatureListPanel.this.setFeaturesInSync(false);
                                        return;
                                    }
                                    leftInIds.addAll(confirmDialog.getLeftInTechIds());
                                    for (TechId techId : leftInIds) {
                                        reconciledScope.add(techId);
                                        userConfirmedRemovalOfIds.remove(techId);
                                    }
                                }
                                TechId[] newIds = reconciledScope.toArray();
                                FeaturesPanel.this.setTechnologyKeys(newIds);
                                FeatureListPanel.this.populateList(FeaturesPanel.this._selectedTechnologies);
                                boolean userEditedTechList = !leftInIds.isEmpty();
                                FeatureListPanel.this.setFeaturesInSync(!userEditedTechList);
                                String feedback = FeatureListPanel.this.calculateChange(originalIds, newIds, userConfirmedRemovalOfIds, userMustConfirm);
                                if (!feedback.isEmpty()) {
                                    FeatureListPanel.this.showFeedback(feedback);
                                }
                            }
                        });
                    }
                    catch (ExecutionException e) {
                        Assert.printStackTrace((Throwable)e);
                    }
                    catch (InterruptedException e) {
                        Assert.printStackTrace((Throwable)e);
                    }
                    catch (CancellationException cancellationException) {
                        // empty catch block
                    }
                }
            }
            MonitorProgressRunnable showProgress = new MonitorProgressRunnable();
            executor.submit(showProgress);
            executor.submit(future);
        }

        private class NLR
        extends NiceListRenderer<TechInfo> {
            private NLR() {
            }

            protected String getTitle(TechInfo listItem) {
                return listItem.getName();
            }

            protected String getDescription(TechInfo listItem) {
                return listItem.getDescription();
            }

            protected boolean isItemSelected(TechInfo listItem) {
                return false;
            }

            protected boolean isCheckable(TechInfo listItem) {
                return false;
            }
        }

        private class GuiHandler
        implements ActionListener {
            private GuiHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (FeatureListPanel.this._addButton == source) {
                    FeatureListPanel.this.editFeatures();
                } else if (FeatureListPanel.this._updateButton == source) {
                    FeatureListPanel.this.detectTechnologies();
                }
            }
        }

        private class DetectorRunnable
        implements Runnable {
            private Collection<String> _techScopeIds;

            public DetectorRunnable(Set<String> techScopeIds) {
                this._techScopeIds = techScopeIds;
            }

            @Override
            public void run() {
                TechnologyScopeManager manager = TechnologyScopeManager.getTechnologyScopeManager();
                TechnologyScopeDetector detector = manager.getDetector();
                try {
                    Collection detected = detector.detectTechnologyScopeIds(FeaturesPanel.this.getWorkspace(), FeaturesPanel.this.getProject());
                    this._techScopeIds.addAll(detected);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted while trying to reconcile technology scopes", e);
                }
            }
        }
    }

    private static final class TechInfo {
        private TechId _techId;
        private Feature _feature;

        TechInfo(TechId techId) {
            this(techId, null);
        }

        TechInfo(TechId techId, Feature feature) {
            Assert.check((techId != null ? 1 : 0) != 0);
            this._techId = techId;
            this._feature = feature;
        }

        String getName() {
            if (this._feature != null) {
                return this._feature.getDisplayName();
            }
            return this._techId.getName();
        }

        String getDescription() {
            if (this._feature != null) {
                return this._feature.getDescription();
            }
            return this._techId.getDescription();
        }

        TechId getTechId() {
            return this._techId;
        }

        public String toString() {
            return this.getName();
        }
    }
}

