/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.controller;

import java.util.EventObject;
import javax.swing.JMenu;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.LabelUpdater;
import oracle.ide.controller.MenuManager;

public abstract class MenuAwareLabelUpdater
implements LabelUpdater {
    private String _menuId;

    public MenuAwareLabelUpdater(String menuId) {
        this._menuId = menuId;
    }

    public final String labelWhenDisabled(Context context, IdeAction action, String originalLabel) {
        return this.disabledLabelImpl(context, action, originalLabel);
    }

    public final String labelWhenEnabled(Context context, IdeAction action, String originalLabel) {
        return this.enabledLabelImpl(context, action, originalLabel);
    }

    protected abstract String disabledMenuSpecificLabel(IdeAction var1, String var2);

    protected abstract String enabledMenuSpecificLabel(IdeAction var1, String var2);

    public final void setDisabledFormat(String format) {
    }

    public final void setEnabledFormat(String format) {
    }

    private String disabledLabelImpl(Context context, IdeAction action, String originalLabel) {
        if (this.matchMenu(context.getEvent())) {
            return this.disabledMenuSpecificLabel(action, originalLabel);
        }
        return originalLabel;
    }

    private String enabledLabelImpl(Context context, IdeAction action, String originalLabel) {
        if (this.matchMenu(context.getEvent())) {
            return this.enabledMenuSpecificLabel(action, originalLabel);
        }
        return originalLabel;
    }

    protected boolean matchMenu(EventObject event) {
        Object source;
        if (event != null && this._menuId != null && (source = event.getSource()) instanceof JMenu) {
            JMenu jm = (JMenu)source;
            if (jm == MenuManager.getJMenu((String)this._menuId)) {
                return true;
            }
            if (this._menuId.equals(jm.getName())) {
                return true;
            }
        }
        return false;
    }
}

