/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.core.util.RaptorGroupLoader;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.plugin.TeradataMachine;
import oracle.dbtools.migration.workbench.plugin.TeradataState;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

class Teradata12BTEQExternalSQLLoaderState
extends TeradataState {
    Logger LOGGER = Logger.getLogger(MigrationUtils.class.getClass().getName());
    StringBuffer postSQLBuf = new StringBuffer();
    protected TeradataMachine machine = null;
    protected StringTemplateGroup m_templateGroup = null;

    public Teradata12BTEQExternalSQLLoaderState(TeradataMachine teradataMachine) {
        super(teradataMachine);
    }

    @Override
    public String getDataExportCommmand(TeradataMachine teradataMachine, String string, MdColumn[] mdColumnArray, String string2, boolean bl) {
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        StringTemplate stringTemplate = null;
        String string3 = null;
        try {
            String string4;
            String string5;
            String string6;
            this.loadTemplates();
            if (string2.toLowerCase().endsWith(".dat")) {
                string6 = "data/" + string2.substring(0, string2.length() - 4) + ".exp";
                string5 = "data/" + string2.substring(0, string2.length() - 4) + ".dat";
                string4 = "data/" + string2.substring(0, string2.length() - 4) + ".csv";
            } else {
                string6 = "data/" + string2 + ".exp";
                string5 = "data/" + string2 + ".dat";
                string4 = "data/" + string2 + ".csv";
            }
            String string7 = migrationConfig.getEndColumnDelimiter();
            String string8 = "'" + string7 + "'";
            String string9 = migrationConfig.getEndRowDelimiter();
            String string10 = "'" + string9 + "'";
            String string11 = string.substring(0, string.indexOf("."));
            String[] stringArray = new String[mdColumnArray.length];
            for (int i = 0; i < mdColumnArray.length; ++i) {
                MdColumn mdColumn = mdColumnArray[i];
                String string12 = mdColumn.getColumnType();
                String string13 = mdColumn.getColumnName();
                Integer n = mdColumn.getPrecision();
                Integer n2 = mdColumn.getScale();
                if (n == null) {
                    n = 0;
                }
                if (n2 == null) {
                    n2 = 0;
                }
                stringArray[i] = this.getColumnPattern(string13, string12, n, n2, string8, mdColumn.getNullableFlag(), i == mdColumnArray.length - 1);
            }
            stringTemplate = this.m_templateGroup.getTemplateDefinition("Convert");
            stringTemplate.reset();
            stringTemplate.setAttribute("expfile", (Object)string6);
            stringTemplate.setAttribute("datfile", (Object)string5);
            stringTemplate.setAttribute("csvfile", (Object)string4);
            stringTemplate.setAttribute("collist", (Object)stringArray);
            stringTemplate.setAttribute("table", (Object)teradataMachine.quote(string));
            stringTemplate.setAttribute("eofd", (Object)string8);
            stringTemplate.setAttribute("eord", (Object)string10);
            stringTemplate.setAttribute("platformWindows", (Object)bl);
            string3 = stringTemplate.toString();
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.WARNING, exception.getLocalizedMessage());
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generateCSV(TeradataMachine teradataMachine, String string, MdColumn[] mdColumnArray) {
        String string2 = "";
        try {
            StringTemplate stringTemplate;
            this.loadTemplates();
            StringTemplate stringTemplate2 = stringTemplate = this.m_templateGroup.getTemplateDefinition("GenerateControlCSV");
            synchronized (stringTemplate2) {
                stringTemplate.reset();
                for (MdColumn mdColumn : mdColumnArray) {
                    stringTemplate.setAttribute("columndetails", (Object)new TeradataState.ColumnDetails(mdColumn));
                }
                stringTemplate.setAttribute("table", (Object)string);
                string2 = stringTemplate.toString();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    @Override
    public String getDataExportScript(TeradataMachine teradataMachine, String string, MdColumn[] mdColumnArray, String string2) {
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        StringTemplate stringTemplate = null;
        try {
            this.loadTemplates();
            String string3 = string2.toLowerCase().endsWith(".dat") ? "data/" + string2.substring(0, string2.length() - 4) + ".exp" : "data/" + string2 + ".exp";
            String string4 = migrationConfig.getEndColumnDelimiter();
            String string5 = "'" + string4 + "'";
            String string6 = migrationConfig.getEndRowDelimiter();
            String string7 = "'" + string6 + "'";
            String[] stringArray = new String[mdColumnArray.length];
            for (int i = 0; i < mdColumnArray.length; ++i) {
                MdColumn mdColumn = mdColumnArray[i];
                String string8 = mdColumn.getColumnType();
                String string9 = mdColumn.getColumnName();
                Integer n = mdColumn.getPrecision();
                Integer n2 = mdColumn.getScale();
                if (n == null) {
                    n = 0;
                }
                if (n2 == null) {
                    n2 = 0;
                }
                stringArray[i] = this.getColumnPattern(string9, string8, n, n2, string5, mdColumn.getNullableFlag(), i == mdColumnArray.length - 1);
            }
            stringTemplate = this.m_templateGroup.getTemplateDefinition("Unload");
            stringTemplate.reset();
            stringTemplate.setAttribute("outfile", (Object)string3);
            stringTemplate.setAttribute("collist", (Object)stringArray);
            stringTemplate.setAttribute("table", (Object)teradataMachine.quote(string));
            stringTemplate.setAttribute("eofd", (Object)string5);
            stringTemplate.setAttribute("eord", (Object)string7);
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.WARNING, exception.getLocalizedMessage());
        }
        return stringTemplate.toString();
    }

    public String getDataExportCommmand(String string, MdColumn[] mdColumnArray, String string2, boolean bl) {
        return null;
    }

    @Override
    public String getColumnPattern(String string, String string2, int n, int n2, String string3, boolean bl, boolean bl2) {
        Object object;
        Object object2 = "";
        Object object3 = "''";
        Object object4 = object = bl2 ? "" : " || " + string3;
        if (string2.equals("DECIMAL")) {
            String string4 = Teradata12BTEQExternalSQLLoaderState.makeNumericFormat(n, n2);
            object2 = "CAST(CAST(\"" + string + "\" AS FORMAT '" + string4 + "') AS CHAR(" + string4.length() + "))";
            if (bl) {
                object2 = "('N' || " + string3 + " || " + (String)object2 + ")";
                object3 = "('Y' || " + string3 + " || (CAST ('' as char(" + string4.length() + "))))";
                object2 = "case when \"" + string + "\" is null then " + (String)object3 + " else " + (String)object2 + " end";
            }
            object = "";
        } else if (string2.equals("DATE")) {
            object2 = "(\"" + string + "\"(FORMAT 'Y4-MM-DD') (CHAR(10)))";
            if (bl) {
                object2 = "('N' || " + string3 + " || " + (String)object2 + ")";
                object3 = "('Y' || " + string3 + " || '          ' )";
                object2 = "case when \"" + string + "\" is null then " + (String)object3 + " else " + (String)object2 + " end";
            }
            object = "";
        } else if (string2.equals("ANSITIME")) {
            object2 = "(\"" + string + "\"(FORMAT 'HH:MI:SS.S(6)') (CHAR(15)))";
            if (bl) {
                object2 = "('N' || " + string3 + " || " + (String)object2 + ")";
                object3 = "('Y' || " + string3 + " || (CAST ('' as char(15))))";
                object2 = "case when \"" + string + "\" is null then " + (String)object3 + " else " + (String)object2 + " end";
            }
            object = "";
        } else if (string2.equals("ANSITIMEWITHTIMEZONE")) {
            object2 = "(\"" + string + "\"(FORMAT 'HH:MI:SS.S(6)Z') (CHAR(21)))";
            if (bl) {
                object2 = "('N' || " + string3 + " || " + (String)object2 + ")";
                object3 = "('Y' || " + string3 + " || (CAST ('' as char(21))))";
                object2 = "case when \"" + string + "\" is null then " + (String)object3 + " else " + (String)object2 + " end";
            }
            object = "";
        } else if (string2.equals("TIMESTAMPWITHOUTTIMEZONE")) {
            object2 = "(\"" + string + "\"(FORMAT 'Y4-MM-DDbHH:MI:SS.S(6)') (CHAR(26)))";
            if (bl) {
                object2 = "('N' || " + string3 + " || " + (String)object2 + ")";
                object3 = "('Y' || " + string3 + " || (CAST ('' as char(26))))";
                object2 = "case when \"" + string + "\" is null then " + (String)object3 + " else " + (String)object2 + " end";
            }
            object = "";
        } else if (string2.equals("TIMESTAMPWITHTIMEZONE")) {
            object2 = "(\"" + string + "\"(FORMAT 'Y4-MM-DD HH:MI:SS.S(6)Z') (CHAR(32)))";
            if (bl) {
                object2 = "('N' || " + string3 + " || " + (String)object2 + ")";
                object3 = "('Y' || " + string3 + " || (CAST ('' as char(32))))";
                object2 = "case when \"" + string + "\" is null then " + (String)object3 + " else " + (String)object2 + " end";
            }
            object = "";
        } else if (string2.equals("DAY") || string2.equals("DAYHOUR") || string2.equals("DAYMINUTE") || string2.equals("DAYSECOND")) {
            int n3 = n + 10 + (n2 > 0 ? n2 + 1 : 0);
            object2 = "CAST(CAST(\"" + string + "\" AS INTERVAL DAY(" + n + ") TO SECOND(" + n2 + ")) AS CHAR(" + n3 + "))";
            if (bl) {
                object2 = "('N' || " + string3 + " || " + (String)object2 + ")";
                object3 = "('Y' || " + string3 + " || (CAST ('' as char(" + n3 + "))))";
                object2 = "case when \"" + string + "\" is null then " + (String)object3 + " else " + (String)object2 + " end";
            }
            object = "";
        } else if (string2.equals("HOUR") || string2.equals("HOURMINUTE") || string2.equals("HOURSECOND")) {
            switch (n) {
                case 4: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                default: {
                    n = 1;
                }
            }
            int n4 = n + 10 + (n2 > 0 ? n2 + 1 : 0);
            object2 = "CAST(CAST(\"" + string + "\" AS INTERVAL DAY(" + n + ") TO SECOND(" + n2 + ")) AS CHAR(" + n4 + "))";
            if (bl) {
                object2 = "('N' || " + string3 + " || " + (String)object2 + ")";
                object3 = "('Y' || " + string3 + " || (CAST ('' as char(" + n4 + "))))";
                object2 = "case when \"" + string + "\" is null then " + (String)object3 + " else " + (String)object2 + " end";
            }
            object = "";
        } else if (string2.equals("MINUTE") || string2.equals("MINUTETOSECOND") || string2.equals("SECOND")) {
            int n5 = 11 + (n2 > 0 ? n2 + 1 : 0);
            object2 = "CAST(CAST(\"" + string + "\" AS INTERVAL DAY(1) TO SECOND(" + n2 + ")) AS CHAR(" + n5 + "))";
            if (bl) {
                object2 = "('N' || " + string3 + " || " + (String)object2 + ")";
                object3 = "('Y' || " + string3 + " || (CAST ('' as char(" + n5 + "))))";
                object2 = "case when \"" + string + "\" is null then " + (String)object3 + " else " + (String)object2 + " end";
            }
            object = "";
        } else if (string2.equals("YEAR") || string2.equals("YEARMONTH")) {
            int n6 = n + 4;
            object2 = "CAST(CAST(\"" + string + "\" AS INTERVAL YEAR(" + n + ") TO MONTH) AS CHAR(" + n6 + "))";
            if (bl) {
                object2 = "('N' || " + string3 + " || " + (String)object2 + ")";
                object3 = "('Y' || " + string3 + " || (CAST ('' as char(" + n6 + "))))";
                object2 = "case when \"" + string + "\" is null then " + (String)object3 + " else " + (String)object2 + " end";
            }
            object = "";
        } else if (string2.equals("MONTH")) {
            switch (n) {
                case 4: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                default: {
                    n = 1;
                }
            }
            int n7 = n + 4;
            object2 = "CAST(CAST(\"" + string + "\" AS INTERVAL YEAR(" + n + ") TO MONTH) AS CHAR(" + n7 + "))";
            if (bl) {
                object2 = "('N' || " + string3 + " || " + (String)object2 + ")";
                object3 = "('Y' || " + string3 + " || (CAST ('' as char(" + n7 + "))))";
                object2 = "case when \"" + string + "\" is null then " + (String)object3 + " else " + (String)object2 + " end";
            }
            object = "";
        } else if (string2.equals("CHARVARYINGLATIN") || string2.equals("CHARVARYINGGRAPHIC") || string2.equals("CHARVARYINGUNICODE") || string2.equals("CHARVARYINGKANJI1") || string2.equals("CHARVARYINGKANJISJIS")) {
            object2 = n > 4000 ? "'000009Too Large'" : "((CAST(CAST(CHARACTER_LENGTH(\"" + string + "\") AS FORMAT'-9(6)') AS CHAR(6))) || \"" + string + "\")";
            object3 = "'000000'";
            object = "";
            if (bl) {
                object2 = "('N' || " + string3 + " || " + (String)object2 + ")";
                object3 = "('Y' || " + string3 + " || " + (String)object3 + ")";
                object2 = "case when \"" + string + "\" is null then " + (String)object3 + " else " + (String)object2 + " end";
            }
        } else if (string2.equals("BYTEFIXED")) {
            object2 = "'" + Teradata12BTEQExternalSQLLoaderState.makeHexVARCHARC(6, "BYTEFIXED not allowed in fexp migration", n) + "'";
            object3 = "'000000'";
            if (bl) {
                object2 = "('N' || " + string3 + " || " + (String)object2 + ")";
                object3 = "('Y' || " + string3 + " || " + (String)object3 + ")";
                object2 = "case when \"" + string + "\" is null then " + (String)object3 + " else " + (String)object2 + " end";
            }
            object = "";
        } else if (string2.equals("BYTELARGEOBJECT")) {
            object2 = "'" + Teradata12BTEQExternalSQLLoaderState.makeHexVARCHARC(6, "BYTELARGEOBJECT not allowed in fexp migration", -1) + "'";
            object3 = "'000000'";
            if (bl) {
                object2 = "('N' || " + string3 + " || " + (String)object2 + ")";
                object3 = "('Y' || " + string3 + " || " + (String)object3 + ")";
                object2 = "case when \"" + string + "\" is null then " + (String)object3 + " else " + (String)object2 + " end";
            }
            object = "";
        } else if (string2.equals("BYTEVARYING")) {
            object2 = "'" + Teradata12BTEQExternalSQLLoaderState.makeHexVARCHARC(6, "BYTEVARYING not allowed in fexp migration", n) + "'";
            object3 = "'000000'";
            if (bl) {
                object2 = "('N' || " + string3 + " || " + (String)object2 + ")";
                object3 = "('Y' || " + string3 + " || " + (String)object3 + ")";
                object2 = "case when \"" + string + "\" is null then " + (String)object3 + " else " + (String)object2 + " end";
            }
            object = "";
        } else if (string2.equals("CHARLARGEOBJECTLATIN") || string2.equals("CHARLARGEOBJECTGRAPHIC") || string2.equals("CHARLARGEOBJECTUNICODE") || string2.equals("CHARLARGEOBJECTKANJI1") || string2.equals("CHARLARGEOBJECTKANJISJIS")) {
            object2 = "'" + Teradata12BTEQExternalSQLLoaderState.makeVARCHARC(6, string2 + " not allowed in fexp migration", -1) + "'";
            object3 = "'000000'";
            if (bl) {
                object2 = "('N' || " + string3 + " || " + (String)object2 + ")";
                object3 = "('Y' || " + string3 + " || " + (String)object3 + ")";
                object2 = "case when \"" + string + "\" is null then " + (String)object3 + " else " + (String)object2 + " end";
            }
            object = "";
        } else if (string2.equals("REAL")) {
            object2 = "(CAST(\"" + string + "\" AS FORMAT '+9.9999999999999999E+999'))";
            if (bl) {
                object2 = "('N' || " + string3 + " || " + (String)object2 + ")";
                object3 = "('Y' || " + string3 + " || '+9.9999999999999999E+999')";
                object2 = "case when \"" + string + "\" is null then " + (String)object3 + " else " + (String)object2 + " end";
            }
            object = "";
        } else if (string2.equals("BIGINTEGER")) {
            object2 = "(CAST(\"" + string + "\" AS FORMAT '+9(20)'))";
            if (bl) {
                object2 = "('N' || " + string3 + " || " + (String)object2 + ")";
                object3 = "('Y' || " + string3 + " || (CAST ('' as char(21))))";
                object2 = "case when \"" + string + "\" is null then " + (String)object3 + " else " + (String)object2 + " end";
            }
            object = "";
        } else if (string2.equals("INTEGER")) {
            object2 = "(CAST(\"" + string + "\" AS FORMAT '+9(11)'))";
            if (bl) {
                object2 = "('N' || " + string3 + " || " + (String)object2 + ")";
                object3 = "('Y' || " + string3 + " || (CAST ('' as char(12))))";
                object2 = "case when \"" + string + "\" is null then " + (String)object3 + " else " + (String)object2 + " end";
            }
            object = "";
        } else if (string2.equals("SMALLINT")) {
            object2 = "(CAST(\"" + string + "\" AS FORMAT '+9(5)'))";
            if (bl) {
                object2 = "('N' || " + string3 + " || " + (String)object2 + ")";
                object3 = "('Y' || " + string3 + " || (CAST ('' as char(6))))";
                object2 = "case when \"" + string + "\" is null then " + (String)object3 + " else " + (String)object2 + " end";
            }
            object = "";
        } else if (string2.equals("BYTEINT")) {
            object2 = "(CAST(\"" + string + "\" AS FORMAT '+9(3)'))";
            if (bl) {
                object2 = "('N' || " + string3 + " || " + (String)object2 + ")";
                object3 = "('Y' || " + string3 + " || (CAST ('' as char(4))))";
                object2 = "case when \"" + string + "\" is null then " + (String)object3 + " else " + (String)object2 + " end";
            }
            object = "";
        } else if (string2.equals("CHARFIXEDLATIN")) {
            object2 = "\"" + string + "\"";
            if (bl) {
                String string5 = "('N' || " + string3 + ")";
                object3 = "('Y' || " + string3 + ")";
                object2 = "case when \"" + string + "\" is null then " + (String)object3 + " else " + string5 + " end, case when \"" + string + "\" is null then (CAST ('' as char(" + n + "))) else (" + (String)object2 + ") end, ''";
            } else {
                object2 = "'', " + (String)object2 + ", ''";
            }
        } else if (string2.equals("CHARFIXEDGRAPHIC")) {
            object2 = "(TRANSLATE(\"" + string + "\" USING GRAPHIC_TO_UNICODE))";
            if (bl) {
                String string6 = "('N' || " + string3 + ")";
                object3 = "('Y' || " + string3 + ")";
                object2 = "case when \"" + string + "\" is null then " + (String)object3 + " else " + string6 + " end, case when \"" + string + "\" is null then (CAST ('' as char(" + n + ")) else (" + (String)object2 + ") end, ''";
            } else {
                object2 = "'', " + (String)object2 + ", ''";
            }
        } else {
            object2 = "\"" + string + "\"";
            if (bl) {
                object2 = "('N' || " + string3 + " || " + (String)object2 + ")";
                object3 = "('Y' || " + string3 + ")";
                object2 = "case when \"" + string + "\" is null then " + (String)object3 + " else " + (String)object2 + " end";
            }
        }
        return (String)object2 + (String)object;
    }

    @Override
    public Object[] generateExternalTableColumnDefinitions(TeradataMachine teradataMachine, MdColumn[] mdColumnArray, MdColumn[] mdColumnArray2) {
        return mdColumnArray2;
    }

    @Override
    public String generateExternalColumnDefinitions(TeradataMachine teradataMachine, MdColumn[] mdColumnArray, MdColumn[] mdColumnArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < mdColumnArray2.length; ++i) {
            String string;
            MdColumn mdColumn = mdColumnArray2[i];
            MdColumn mdColumn2 = mdColumnArray[i];
            stringBuffer.append(this.maybeQuoteExternalFieldReference(teradataMachine, mdColumn2, mdColumn));
            stringBuffer.append(' ');
            stringBuffer.append(this.formatSQLLoaderColumn(teradataMachine, mdColumn2, mdColumn, i + 1 >= mdColumnArray2.length));
            if (i < mdColumnArray2.length - 1) {
                stringBuffer.append(", \n");
            }
            if (!(string = mdColumn2.getColumnType()).equals("BYTELARGEOBJECT")) continue;
            vector.add(mdColumn);
        }
        stringBuffer.append("\n");
        if (vector.size() > 0) {
            String string = "    ";
            for (MdColumn mdColumn : vector) {
                this.postSQLBuf.append(string);
                this.postSQLBuf.append("\"" + mdColumn.getColumnName() + "\"=DBMS_LOB.SUBSTR(\"" + mdColumn.getColumnName() + "\",DBMS_LOB.GETLENGTH(\"" + mdColumn.getColumnName() + "\")-8,8)");
                string = ",\n    ";
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String generateExternalSelectColumnList(TeradataMachine teradataMachine, MdColumn[] mdColumnArray, MdColumn[] mdColumnArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = new Vector();
        String string = "";
        for (int i = 0; i < mdColumnArray2.length; ++i) {
            MdColumn mdColumn = mdColumnArray2[i];
            MdColumn mdColumn2 = mdColumnArray[i];
            stringBuffer.append(string);
            stringBuffer.append(mdColumn.getColumnName());
            string = ",\n  ";
        }
        return stringBuffer.toString();
    }

    @Override
    public String maybeQuoteSqlldrFieldReference(TeradataMachine teradataMachine, MdColumn mdColumn, MdColumn mdColumn2) {
        return null;
    }

    @Override
    public String maybeQuoteExternalFieldReference(TeradataMachine teradataMachine, MdColumn mdColumn, MdColumn mdColumn2) {
        String string = mdColumn.getColumnType();
        StringBuffer stringBuffer = new StringBuffer();
        if (mdColumn2.getNullableFlag()) {
            stringBuffer.append(teradataMachine.trunk30("NL_" + mdColumn2.getColumnName()));
            stringBuffer.append(" VARCHAR(2,16),\n");
        }
        if (string.equals("BIGINTEGER") || string.equals("BYTEFIXED") || string.equals("BYTEINT") || string.equals("BYTELARGEOBJECT") || string.equals("CHARFIXEDGRAPHIC") || string.equals("CHARFIXEDKANJI1") || string.equals("CHARFIXEDKANJISJIS") || string.equals("CHARFIXEDLATIN") || string.equals("CHARFIXEDUNICODE") || string.equals("CHARVARYINGGRAPHIC") || string.equals("CHARVARYINGKANJI1") || string.equals("CHARVARYINGKANJISJIS") || string.equals("CHARVARYINGLATIN") || string.equals("CHARVARYINGUNICODE") || string.equals("DAY") || string.equals("DAYHOUR") || string.equals("DAYMINUTE") || string.equals("DAYSECOND") || string.equals("DECIMAL") || string.equals("INTEGER") || string.equals("MINUTE") || string.equals("MINUTETOSECOND") || string.equals("REAL") || string.equals("SECOND") || string.equals("SMALLINT") || string.equals("HOUR") || string.equals("HOURMINUTE") || string.equals("HOURSECOND") || string.equals("YEAR") || string.equals("YEARMONTH") || string.equals("MONTH")) {
            stringBuffer.append("IG" + mdColumn.getColumnOrder() + " RAW(2),\n");
        } else if (string.equals("BYTEVARYING")) {
            stringBuffer.append("IG" + mdColumn.getColumnOrder() + " RAW(8),\n");
        } else if (string.equals("CHARLARGEOBJECTGRAPHIC") || string.equals("CHARLARGEOBJECTKANJI1") || string.equals("CHARLARGEOBJECTKANJISJIS") || string.equals("CHARLARGEOBJECTLATIN") || string.equals("CHARLARGEOBJECTUNICODE")) {
            stringBuffer.append("IG" + mdColumn.getColumnOrder() + " RAW(8),\n");
        } else if (string.equals("DATE")) {
            stringBuffer.append("IG" + mdColumn.getColumnOrder() + "DATE RAW(8),\n");
        } else if (string.equals("ANSITIME")) {
            stringBuffer.append("IG" + mdColumn.getColumnOrder() + "ANSITIME RAW(8),\n");
        } else if (string.equals("ANSITIMEWITHTIMEZONE")) {
            stringBuffer.append("IG" + mdColumn.getColumnOrder() + "ANSITIMETZ RAW(8),\n");
        } else if (string.equals("TIMESTAMPWITHOUTTIMEZONE")) {
            stringBuffer.append("IG" + mdColumn.getColumnOrder() + "TS RAW(8),\n");
        } else if (string.equals("TIMESTAMPWITHTIMEZONE")) {
            stringBuffer.append("IG" + mdColumn.getColumnOrder() + "TSTZ RAW(8),\n");
        }
        stringBuffer.append(mdColumn2.getColumnName());
        return stringBuffer.toString();
    }

    @Override
    public String formatSQLLoaderColumn(TeradataMachine teradataMachine, MdColumn mdColumn, MdColumn mdColumn2, boolean bl) {
        Object object = "";
        String string = mdColumn2.getColumnName();
        boolean bl2 = mdColumn.getNullableFlag();
        String string2 = mdColumn.getColumnType();
        Object object2 = "";
        if (bl2) {
            object2 = " NULLIF " + teradataMachine.trunk30("NL_" + string) + "='Y'";
        }
        if (string2.equals("BIGINTEGER") || string2.equals("BYTEINT") || string2.equals("CHARFIXEDGRAPHIC") || string2.equals("CHARFIXEDKANJI1") || string2.equals("CHARFIXEDKANJISJIS") || string2.equals("CHARFIXEDLATIN") || string2.equals("CHARFIXEDUNICODE") || string2.equals("CHARLARGEOBJECTGRAPHIC") || string2.equals("CHARLARGEOBJECTKANJI1") || string2.equals("CHARLARGEOBJECTKANJISJIS") || string2.equals("CHARLARGEOBJECTLATIN") || string2.equals("CHARLARGEOBJECTUNICODE") || string2.equals("CHARVARYINGGRAPHIC") || string2.equals("CHARVARYINGKANJI1") || string2.equals("CHARVARYINGKANJISJIS") || string2.equals("CHARVARYINGLATIN") || string2.equals("CHARVARYINGUNICODE") || string2.equals("DAY") || string2.equals("DAYHOUR") || string2.equals("DAYMINUTE") || string2.equals("DAYSECOND") || string2.equals("DECIMAL") || string2.equals("INTEGER") || string2.equals("MINUTE") || string2.equals("MINUTETOSECOND") || string2.equals("REAL") || string2.equals("SECOND") || string2.equals("SMALLINT") || string2.equals("HOUR") || string2.equals("HOURMINUTE") || string2.equals("HOURSECOND") || string2.equals("YEAR") || string2.equals("YEARMONTH") || string2.equals("MONTH")) {
            object = "VARCHARC(6,4000)";
        } else if (string2.equals("BYTEFIXED")) {
            object = "VARRAWC(6,100000)";
        } else if (string2.equals("BYTEVARYING")) {
            object = "VARRAW(100000)";
        } else if (string2.equals("BYTELARGEOBJECT")) {
            object = "VARRAWC(6,100000)";
        } else if (string2.equals("DATE")) {
            object = " CHAR(10) DATE_FORMAT DATE MASK \"YYYY-MM-DD\"";
        } else if (string2.equals("ANSITIME")) {
            object = " CHAR(15) DATE_FORMAT TIMESTAMP MASK \"HH24:MI:SS.FF6\"";
        } else if (string2.equals("ANSITIMEWITHTIMEZONE")) {
            object = " CHAR(21) DATE_FORMAT TIMESTAMP WITH TIME ZONE MASK \"HH24:MI:SS.FF6TZH:TZM\"";
        } else if (string2.equals("TIMESTAMPWITHOUTTIMEZONE")) {
            object = " CHAR(26) DATE_FORMAT TIMESTAMP MASK \"YYYY-MM-DD HH24:MI:SS.FF6\"";
        } else if (string2.equals("TIMESTAMPWITHTIMEZONE")) {
            object = " CHAR(32) DATE_FORMAT TIMESTAMP WITH TIME ZONE MASK \"YYYY-MM-DD HH24:MI:SS.FF6TZH:TZM\"";
        } else {
            object = "XXX(" + string2 + ")XXX";
            System.out.println("UNHANDLED TYPE " + (String)object + (String)object2);
        }
        return (String)object + (String)object2;
    }

    protected void loadTemplates() {
        if (this.m_templateGroup == null) {
            RaptorGroupLoader raptorGroupLoader = new RaptorGroupLoader("oracle/dbtools/migration/workbench/plugin/teradata/templates", this.getClass().getClassLoader());
            StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)raptorGroupLoader);
            StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
            this.m_templateGroup = StringTemplateGroup.loadGroup((String)"OfflineCapturer");
        }
    }

    @Override
    public String getSQLLoaderCommand(TeradataMachine teradataMachine, String string, String string2, boolean bl) {
        this.loadTemplates();
        return "";
    }

    protected static String makeHexVARCHARC(int n, CharSequence charSequence, int n2) {
        if (charSequence == null || charSequence.length() == 0) {
            return Teradata12BTEQExternalSQLLoaderState.makeVARCHARC(n, charSequence, n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            int n3 = Character.getNumericValue(c);
            String string = Integer.toHexString(n3 & 0xFF);
            stringBuffer.append(string);
        }
        return Teradata12BTEQExternalSQLLoaderState.makeVARCHARC(n, stringBuffer.toString(), n2 * 2);
    }

    protected static String makeVARCHARC(int n, CharSequence charSequence, int n2) {
        int n3;
        int n4;
        int n5 = n4 = charSequence == null ? 0 : charSequence.length();
        if (n2 >= 0 && n4 > n2) {
            n4 = n2;
        }
        String string = Integer.toString(n4);
        StringBuffer stringBuffer = new StringBuffer();
        for (n3 = 0; n3 < n - string.length(); ++n3) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        for (n3 = 0; n3 < n4; ++n3) {
            stringBuffer.append(charSequence.charAt(n3));
        }
        return stringBuffer.toString();
    }

    public static String makeNumericFormat(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('-');
        for (int i = 0; i < n; ++i) {
            if (i == n - n2) {
                stringBuffer.append('.');
            }
            stringBuffer.append('9');
        }
        return stringBuffer.toString();
    }

    @Override
    public String getPostLoadSQL() {
        String string = this.postSQLBuf.toString();
        this.postSQLBuf.setLength(0);
        return string;
    }
}

