/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.node;

import ilog.views.IlvGrapher;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.event.SDMModelEvent;
import ilog.views.sdm.event.SDMModelListener;
import ilog.views.sdm.event.SDMPropertyChangeEvent;
import ilog.views.sdm.event.SDMPropertyChangeListener;
import ilog.views.sdm.model.IlvDefaultSDMModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import oracle.diagram.core.manager.CoreGrapher;
import oracle.diagram.core.util.PrettyPrintDriver;
import oracle.diagram.sdm.undo.ContextNodeUndoStateHelper;
import oracle.diagram.sdm.undo.SDMUndoFilter;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Attributes;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.vcs.VCSManager;
import oracle.xml.parser.v2.PrintDriver;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;

public class SDMEngineNode
extends Node
implements SDMModelListener,
SDMPropertyChangeListener {
    private IlvSDMEngine _engine = null;
    private boolean _loading = false;
    private final PropertyChangeListener _engineListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == SDMEngineNode.this._engine && "model".equals(evt.getPropertyName())) {
                IlvSDMModel oldModel = (IlvSDMModel)evt.getOldValue();
                IlvSDMModel newModel = (IlvSDMModel)evt.getNewValue();
                if (oldModel != null) {
                    oldModel.removeSDMModelListener((SDMModelListener)SDMEngineNode.this);
                    oldModel.removeSDMPropertyChangeListener((SDMPropertyChangeListener)SDMEngineNode.this);
                }
                if (newModel != null) {
                    newModel.addSDMModelListener((SDMModelListener)SDMEngineNode.this);
                    newModel.addSDMPropertyChangeListener((SDMPropertyChangeListener)SDMEngineNode.this);
                }
            }
        }
    };
    public static final String DEBUG_PROPERTY = "oracle.diagram.sdm.debugModel";

    public SDMEngineNode() {
        this.initializeAttributes();
        this.initialize();
    }

    public SDMEngineNode(URL url) {
        super(url);
        this.initializeAttributes();
        this.initialize();
    }

    public final IlvSDMEngine getEngine() throws IOException {
        this.open();
        return this.getEngineImpl();
    }

    protected final IlvSDMEngine getEngineImpl() {
        return this._engine;
    }

    protected void initializeAttributes() {
        Attributes attr = this.getAttributes();
        attr.set(ElementAttributes.SAVEABLE | ElementAttributes.SAVEABLE_AS | ElementAttributes.ERASEABLE | ElementAttributes.EDITOR_SAVEABLE_AS | ElementAttributes.CLOSEABLE | ElementAttributes.RENAMEABLE | ElementAttributes.PRINTABLE);
    }

    protected void initialize() {
    }

    protected void openImpl() throws IOException {
        try {
            this._loading = true;
            super.openImpl();
            if (this._engine == null) {
                this._engine = this.createEngine();
                this.installModelFilters(this._engine);
                this._engine.getModel().addSDMModelListener((SDMModelListener)this);
                this._engine.getModel().addSDMPropertyChangeListener((SDMPropertyChangeListener)this);
                this._engine.addPropertyChangeListener(this._engineListener);
            }
            if (!this.isNew()) {
                this.loadEngine(this._engine);
            }
        }
        finally {
            this._loading = false;
            CommandProcessor.getInstance().flush((Node)this);
        }
    }

    protected void loadEngine(IlvSDMEngine engine) throws IOException {
        try (InputStream is = null;){
            URL url = this.getURL();
            VCSManager.getVCSManager().validateStatus(url);
            is = VCSManager.getVCSManager().containsConflicts(url) ? VCSManager.getVCSManager().openConflictsStreamAsContributor(url) : this.getInputStream();
            engine.readXML(is, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveEngine(IlvSDMEngine engine) throws IOException {
        OutputStream os = null;
        PrettyPrintDriver ppd = null;
        try {
            os = URLFileSystem.openOutputStream((URL)this.getURL());
            ppd = new PrettyPrintDriver(new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, "UTF-8"))));
            XMLDocument doc = new XMLDocument();
            doc.setEncoding("UTF-8");
            doc.setVersion("1.0");
            engine.writeDOM((Document)doc);
            doc.print((PrintDriver)ppd);
            ppd.flush();
        }
        finally {
            if (ppd != null) {
                ppd.close();
                ppd = null;
            }
            if (os != null) {
                os.close();
                os = null;
            }
        }
    }

    protected void saveImpl() throws IOException {
        super.saveImpl();
        this.saveEngine(this._engine);
    }

    protected void closeImpl() throws IOException {
        super.closeImpl();
        if (this._engine != null) {
            this._engine.removePropertyChangeListener(this._engineListener);
            IlvSDMModel model = this._engine.getModel();
            if (model != null) {
                model.removeSDMModelListener((SDMModelListener)this);
                model.removeSDMPropertyChangeListener((SDMPropertyChangeListener)this);
            }
        }
        this._engine = null;
    }

    protected void revertImpl() throws IOException {
        if (this._engine != null && !this.isNew()) {
            try {
                this._loading = true;
                this.loadEngine(this._engine);
            }
            finally {
                this._loading = false;
            }
        } else {
            super.revertImpl();
        }
    }

    protected IlvSDMEngine createEngine() {
        IlvSDMEngine engine = new IlvSDMEngine(this.createGrapher(), this.createModel());
        if (this.shouldEnableMetadata()) {
            engine.setMetadataEnabled(true);
        } else {
            engine.setMetadataEnabled(false);
        }
        return engine;
    }

    protected boolean shouldEnableMetadata() {
        return true;
    }

    protected IlvGrapher createGrapher() {
        return new CoreGrapher();
    }

    protected IlvSDMModel createModel() {
        return new IlvDefaultSDMModel();
    }

    protected final boolean isLoading() {
        return this._loading;
    }

    protected void installModelFilters(IlvSDMEngine engine) {
        SDMUndoFilter filter = new SDMUndoFilter(engine.getModel());
        filter.addStateHelper(new ContextNodeUndoStateHelper());
        engine.setModel((IlvSDMModel)filter);
    }

    public void objectAdded(SDMModelEvent sDMModelEvent) {
        this.maybeMarkDirtyForEvent(sDMModelEvent);
    }

    public void objectRemoved(SDMModelEvent sDMModelEvent) {
        this.maybeMarkDirtyForEvent(sDMModelEvent);
    }

    public void linkSourceChanged(SDMModelEvent sDMModelEvent) {
        this.maybeMarkDirtyForEvent(sDMModelEvent);
    }

    public void linkDestinationChanged(SDMModelEvent sDMModelEvent) {
        this.maybeMarkDirtyForEvent(sDMModelEvent);
    }

    public void dataChanged(SDMModelEvent sDMModelEvent) {
        this.maybeMarkDirtyForEvent(sDMModelEvent);
    }

    public void adjustmentFinished(SDMModelEvent sDMModelEvent) {
    }

    public void propertyChanged(SDMPropertyChangeEvent SDMPropertyChangeEvent2) {
        this.maybeMarkDirtyForEvent((SDMModelEvent)SDMPropertyChangeEvent2);
    }

    private void maybeMarkDirtyForEvent(SDMModelEvent event) {
        if (this.isLoading()) {
            return;
        }
        this.markDirty(true);
    }
}

