/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.interaction;

import ilog.views.IlvLinkImage;
import ilog.views.IlvLinkImageEditInteractor;
import ilog.views.IlvManagerView;
import ilog.views.IlvObjectInteractorContext;
import ilog.views.IlvPoint;
import ilog.views.IlvPolyPointsInterface;
import ilog.views.sdm.IlvSDMEngine;
import java.util.ResourceBundle;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.context.IdeContextPlugin;
import oracle.diagram.core.interaction.IdeObjectInteractorContext;
import oracle.diagram.framework.readonly.ReadOnlyUtil;
import oracle.diagram.res.UndoResource;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.diagram.sdm.undo.SDMUndoUtil;
import oracle.ide.Context;
import oracle.ide.controller.CommandProcessor;

public class UndoableSDMLinkImageEditInteractor
extends IlvLinkImageEditInteractor {
    protected static final String ADD_POINT;
    protected static final String REMOVE_POINT;
    protected static final String MOVE_POINT;

    public UndoableSDMLinkImageEditInteractor() {
        this.setOpaqueMode(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePoint(final IlvPolyPointsInterface ppi, final IlvObjectInteractorContext context) {
        if (!UndoableSDMLinkImageEditInteractor.canWrite(context, (IlvLinkImage)ppi)) {
            return;
        }
        Context ideContext = UndoableSDMLinkImageEditInteractor.getIdeContext(context);
        if (ideContext != null) {
            CommandProcessor.getInstance().beginTrans(REMOVE_POINT);
            try {
                SDMUndoUtil.captureModelUndo(ideContext, UndoableSDMLinkImageEditInteractor.getEngine(context).getModel(), new Runnable(){

                    @Override
                    public void run() {
                        UndoableSDMLinkImageEditInteractor.super.removePoint(ppi, context);
                        UndoableSDMLinkImageEditInteractor.performLinkLayout(context);
                    }
                });
            }
            finally {
                CommandProcessor.getInstance().endTrans();
            }
        } else {
            super.removePoint(ppi, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void movePoint(final IlvPolyPointsInterface ppi, final IlvObjectInteractorContext context, final IlvPoint point) {
        if (!UndoableSDMLinkImageEditInteractor.canWrite(context, (IlvLinkImage)ppi)) {
            return;
        }
        Context ideContext = UndoableSDMLinkImageEditInteractor.getIdeContext(context);
        if (ideContext != null) {
            CommandProcessor.getInstance().beginTrans(MOVE_POINT);
            try {
                SDMUndoUtil.captureModelUndo(ideContext, UndoableSDMLinkImageEditInteractor.getEngine(context).getModel(), new Runnable(){

                    @Override
                    public void run() {
                        UndoableSDMLinkImageEditInteractor.super.movePoint(ppi, context, point);
                        UndoableSDMLinkImageEditInteractor.performLinkLayout(context);
                    }
                });
            }
            finally {
                CommandProcessor.getInstance().endTrans();
            }
        } else {
            super.movePoint(ppi, context, point);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertPoint(final IlvPolyPointsInterface ppi, final IlvPoint point, final IlvObjectInteractorContext context) {
        if (!UndoableSDMLinkImageEditInteractor.canWrite(context, (IlvLinkImage)ppi)) {
            return;
        }
        Context ideContext = UndoableSDMLinkImageEditInteractor.getIdeContext(context);
        if (ideContext != null) {
            CommandProcessor.getInstance().beginTrans(ADD_POINT);
            try {
                SDMUndoUtil.captureModelUndo(ideContext, UndoableSDMLinkImageEditInteractor.getEngine(context).getModel(), new Runnable(){

                    @Override
                    public void run() {
                        UndoableSDMLinkImageEditInteractor.super.insertPoint(ppi, point, context);
                        UndoableSDMLinkImageEditInteractor.performLinkLayout(context);
                    }
                });
            }
            finally {
                CommandProcessor.getInstance().endTrans();
            }
        } else {
            super.insertPoint(ppi, point, context);
        }
    }

    protected static final Context getIdeContext(IlvObjectInteractorContext context) {
        return UndoableSDMLinkImageEditInteractor.getDiagramContext(context).getPlugin(IdeContextPlugin.class).getContext();
    }

    protected static final DiagramContext getDiagramContext(IlvObjectInteractorContext context) {
        if (context instanceof IlvManagerView) {
            return DiagramContext.getDiagramContext((IlvManagerView)context);
        }
        if (context instanceof IdeObjectInteractorContext) {
            return DiagramContext.getDiagramContext(((IdeObjectInteractorContext)context).getView());
        }
        throw new IllegalStateException("Unable to determine view");
    }

    protected static boolean canWrite(IlvObjectInteractorContext context, IlvLinkImage link) {
        DiagramContext dc = UndoableSDMLinkImageEditInteractor.getDiagramContext(context);
        return ReadOnlyUtil.checkWritableReshapeLink(dc, link);
    }

    protected static final IlvSDMEngine getEngine(IlvObjectInteractorContext context) {
        DiagramContext dc = UndoableSDMLinkImageEditInteractor.getDiagramContext(context);
        return SDMDiagramContextUtil.getSDMEngine(dc);
    }

    protected static final void performLinkLayout(IlvObjectInteractorContext context) {
        IlvSDMEngine engine = UndoableSDMLinkImageEditInteractor.getEngine(context);
        if (engine.isLinkLayoutEnabled()) {
            engine.performLinkLayout();
        }
    }

    static {
        ResourceBundle rb = UndoResource.getBundle();
        ADD_POINT = rb.getString("addPoint.text");
        REMOVE_POINT = rb.getString("removePoint.text");
        MOVE_POINT = rb.getString("movePoint.text");
    }
}

