/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.interaction;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.renderer.IlvRendererUtil;
import java.util.Collection;
import oracle.diagram.core.context.IdeContextPlugin;
import oracle.diagram.framework.interaction.LabelInPlaceEditor;
import oracle.diagram.sdm.interaction.SDMEditInteractor;
import oracle.diagram.sdm.interaction.SDMInPlaceEditContext;
import oracle.diagram.sdm.undo.SDMUndoUtil;
import oracle.diagram.sdm.undo.StateHelper;
import oracle.diagram.sdm.undo.StatefulCommand;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;

public class SDMLabelInPlaceEditor
extends LabelInPlaceEditor {
    private final IlvSDMEngine _engine;

    public SDMLabelInPlaceEditor(SDMEditInteractor editInteractor, SDMInPlaceEditContext initialContext) {
        super(editInteractor, initialContext);
        this._engine = IlvSDMEngine.getSDMEngine((IlvGrapher)((IlvGrapher)initialContext.getManager()));
    }

    protected final IlvSDMEngine getSDMEngine() {
        return this._engine;
    }

    public String getLabelProperty() {
        return ((SDMInPlaceEditContext)this.getContext()).getLabelProperty();
    }

    @Override
    protected String getObjectLabel(IlvGraphic graphic) {
        graphic = this.getSDMEngine().getRenderer().getEncapsulatedGraphic(graphic);
        return super.getObjectLabel(graphic);
    }

    @Override
    protected boolean supportMultiline(IlvGraphic graphic) {
        graphic = this.getSDMEngine().getRenderer().getEncapsulatedGraphic(graphic);
        return super.supportMultiline(graphic);
    }

    @Override
    protected IlvRect getLabelBBox(IlvGraphic graphic, IlvTransformer tx) {
        graphic = this.getSDMEngine().getRenderer().getEncapsulatedGraphic(graphic);
        return super.getLabelBBox(graphic, tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setObjectLabelImpl(IlvSDMEngine engine, Object obj, String labelProperty, String newLabel) {
        engine.setAdjusting(true);
        try {
            IlvRendererUtil.updateObjectProperties((IlvSDMEngine)engine, (Object)obj, (String)labelProperty, (Object)newLabel, null);
            if (engine.isLabelLayoutEnabled()) {
                engine.performLabelLayout();
            }
        }
        finally {
            engine.setAdjusting(false);
        }
    }

    protected boolean isModelUndoRequired(IlvSDMModel model, Object obj) {
        return true;
    }

    protected String getOriginalLabelForUndo(IlvGraphic graphic) {
        return this.getObjectLabel(graphic);
    }

    protected Command createModelUndoCommand(final IlvSDMEngine engine, final Object obj, final String oldLabel, final String newLabel) {
        final String labelProperty = this.getLabelProperty();
        return new StatefulCommand(Ide.findOrCreateCmdID((String)"Model Set Label"), 0, this.getUndoTask()){

            @Override
            protected int doitImpl() throws Exception {
                SDMLabelInPlaceEditor.this.setObjectLabelImpl(engine, obj, labelProperty, newLabel);
                return 0;
            }

            @Override
            protected int undoImpl() throws Exception {
                SDMLabelInPlaceEditor.this.setObjectLabelImpl(engine, obj, labelProperty, oldLabel);
                return 0;
            }

            @Override
            protected Collection<StateHelper> getStateHelpers() {
                return SDMUndoUtil.getStateHelpers(engine.getModel());
            }
        };
    }

    @Override
    protected void beginUndo(IlvGraphic g, String newLabel, String taskName) {
        CommandProcessor.getInstance().beginTrans(taskName);
    }

    @Override
    protected void endUndo(IlvGraphic g, String newLabel, String taskName) {
        CommandProcessor.getInstance().endTrans();
    }

    @Override
    protected void abortUndo(IlvGraphic g, String newLabel, String taskName) {
        CommandProcessor.getInstance().abortTrans();
    }

    @Override
    protected boolean setObjectLabel(IlvGraphic graphic, String newLabel) {
        IlvSDMEngine engine = this.getSDMEngine();
        Object obj = engine.getObject(graphic);
        if (obj != null) {
            if (this.isModelUndoRequired(engine.getModel(), obj)) {
                Command cmd = this.createModelUndoCommand(engine, obj, this.getOriginalLabelForUndo(graphic), newLabel);
                cmd.setContext(this.getEditInteractor().getDiagramContext().getPlugin(IdeContextPlugin.class).getContext());
                try {
                    CommandProcessor.getInstance().invoke(cmd);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                this.setObjectLabelImpl(engine, obj, this.getLabelProperty(), newLabel);
            }
            return true;
        }
        return false;
    }
}

