/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvRect;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.model.IlvSDMNode;
import ilog.views.sdm.renderer.IlvRendererUtil;
import java.awt.Color;
import java.awt.Font;
import oracle.diagram.framework.graphic.NoteShape;
import oracle.diagram.framework.util.FontUtil;
import oracle.diagram.sdm.graphic.SizePersisted;

public class SDMNoteShape
extends NoteShape
implements SizePersisted {
    public static final String TAG = "note";
    public static final String DEFAULT_LABEL_PROPERTY_NAME = "label";
    private String _labelPropertyName;

    public SDMNoteShape() {
        this(new IlvRect(0.0f, 0.0f, 100.0f, 80.0f));
    }

    public SDMNoteShape(IlvRect r) {
        super(r);
    }

    @Override
    public float getWidth() {
        return this.boundingBox().width;
    }

    @Override
    public void setWidth(float width) {
        this.resize(width, this.boundingBox().height);
        this.doLayout();
    }

    @Override
    public float getHeight() {
        return this.boundingBox().height;
    }

    @Override
    public void setHeight(float height) {
        this.resize(this.boundingBox().width, height);
        this.doLayout();
    }

    public void setFillColor(String colorString) {
        if (colorString == null) {
            return;
        }
        Color c = Color.decode(colorString);
        if (c != null) {
            this.setShapeFillColor(c);
        }
    }

    public void setFontColor(String colorString) {
        if (colorString == null) {
            return;
        }
        Color c = Color.decode(colorString);
        if (c != null) {
            this.setFontColor(c);
        }
    }

    public void setLineColor(String colorString) {
        if (colorString == null) {
            return;
        }
        Color c = Color.decode(colorString);
        if (c != null) {
            this.setShapeLineColor(c);
        }
    }

    public void setFont(String fontString) {
        Font f = FontUtil.decodeFont(fontString);
        if (f != null) {
            this.setFont(f);
        }
    }

    public String getLabelPropertyName() {
        return this._labelPropertyName;
    }

    public void setLabelPropertyName(String labelPropertyName) {
        this._labelPropertyName = labelPropertyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalSetText(String text) {
        IlvSDMEngine engine = IlvSDMEngine.getSDMEngine((IlvGraphic)this);
        Object obj = engine.getObject((IlvGraphic)this);
        String labelPropertyName = this.getLabelPropertyName();
        if (labelPropertyName == null && obj instanceof IlvSDMNode) {
            String[] names;
            for (String name : names = ((IlvSDMNode)obj).getPropertyNames()) {
                if (!DEFAULT_LABEL_PROPERTY_NAME.equalsIgnoreCase(name)) continue;
                labelPropertyName = name;
                break;
            }
        }
        if (labelPropertyName == null) {
            labelPropertyName = DEFAULT_LABEL_PROPERTY_NAME;
        }
        engine.setAdjusting(true);
        try {
            IlvRendererUtil.updateObjectProperties((IlvSDMEngine)engine, (Object)obj, (String)labelPropertyName, (Object)text, null);
            if (engine.isLabelLayoutEnabled()) {
                engine.performLabelLayout();
            }
        }
        finally {
            engine.setAdjusting(false);
        }
    }
}

