/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.oppparse;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.bm.javatools.util.MultivaluedMap;
import oracle.diagram.oppparse.OPPArtifactAttributeProperty;
import oracle.diagram.oppparse.OPPArtifactCache;
import oracle.diagram.oppparse.OPPArtifactElementProperty;
import oracle.diagram.oppparse.OPPArtifactProperty;
import oracle.diagram.oppparse.OPPCID;
import oracle.diagram.oppparse.OPPParseConstants;
import oracle.diagram.oppparse.OPPParseUtil;
import oracle.diagram.oppparse.OPPXMLElementAdapter;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.NodeList;

public class OPPArtifact
extends OPPXMLElementAdapter
implements OPPParseConstants {
    private final OPPArtifactCache _cache;
    private final OPPArtifact _parent;
    private final MultivaluedMap<String, OPPArtifact> _ownedChildren = new MultivaluedMap();
    private final Map<String, OPPArtifactProperty> _ownedProperties = new HashMap<String, OPPArtifactProperty>();
    private final OPPCID _cid;
    private final String _type;

    public OPPArtifact(OPPArtifactCache cache, OPPArtifact parent, XMLElement source) {
        super(source);
        NodeList children;
        XMLElement artifact;
        NodeList properties;
        this._cache = cache;
        this._parent = parent;
        this._cid = new OPPCID(source.getAttribute("cid"));
        if (!"".equals(this._cid.getGuid())) {
            cache.cacheArtifact(this._cid, this);
        }
        this._type = source.getAttribute("type");
        this._ownedProperties.put("NAME", new OPPArtifactAttributeProperty("NAME", this.getXMLSource().getAttribute("name")));
        XMLElement property = OPPParseUtil.getSingleChild(source, "property");
        if (property != null && (properties = property.getChildNodes()) != null) {
            int isize = properties.getLength();
            for (int i = 0; i < isize; ++i) {
                XMLElement prop = (XMLElement)properties.item(i);
                this._ownedProperties.put(prop.getAttribute("name"), new OPPArtifactElementProperty(this, prop));
            }
        }
        if ((artifact = OPPParseUtil.getSingleChild(source, "children")) != null && (children = artifact.getChildrenByTagName("child")) != null) {
            int isize = children.getLength();
            for (int i = 0; i < isize; ++i) {
                XMLElement child = (XMLElement)children.item(i);
                NodeList artifacts = child.getChildrenByTagName("artifact");
                if (artifacts == null) continue;
                String refProperty = child.getAttribute("reference");
                String compProperty = child.getAttribute("type") + "." + refProperty;
                int jsize = artifacts.getLength();
                for (int j = 0; j < jsize; ++j) {
                    OPPArtifact compositeArtifact = new OPPArtifact(cache, this, (XMLElement)artifacts.item(j));
                    compositeArtifact.setProperty(new OPPArtifactAttributeProperty(refProperty, this.getCID()));
                    this._ownedChildren.put((Object)compProperty, (Object)compositeArtifact);
                }
            }
        }
    }

    public final OPPArtifact getOwner() {
        return this._parent;
    }

    public final Collection<OPPArtifact> getOwnedArtifacts(String reference) {
        Collection c = this._ownedChildren.get((Object)reference);
        if (c != null) {
            return Collections.unmodifiableCollection(c);
        }
        return Collections.EMPTY_LIST;
    }

    public final OPPCID getCID() {
        return this._cid;
    }

    public final String getType() {
        return this._type;
    }

    public final OPPArtifactProperty getProperty(String name) {
        return this._ownedProperties.get(name);
    }

    private void setProperty(OPPArtifactProperty property) {
        this._ownedProperties.put(property.getName(), property);
    }
}

