/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.testability;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLabelInterface;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.bm.util.DebugUtils;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.plugin.PluginUtil;
import oracle.diagram.core.util.CoreGraphicUtils;
import oracle.diagram.framework.accessibility.PresentableGraphicPlugin;
import oracle.diagram.framework.graphic.GraphicDescriptor;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.testability.JViewsComponent;
import oracle.diagram.framework.view.ViewUtil;

public final class IlvGraphicComponent
implements JViewsComponent {
    private final IlvGraphic graphic;

    public IlvGraphicComponent(IlvGraphic graphic) {
        if (graphic == null) {
            throw new IllegalArgumentException("Argument graphic must not be null");
        }
        this.graphic = graphic;
    }

    @Override
    public String getName() {
        return this.graphic.getName();
    }

    @Override
    public String getTestName() {
        return CoreGraphicUtils.getTestName(this.graphic);
    }

    @Override
    public String getPresentableName(DiagramContext diagramContext) {
        GraphicDescriptor gd;
        if (diagramContext == null) {
            return null;
        }
        PresentableGraphicPlugin plugin = PluginUtil.getPlugin(diagramContext, this.graphic, PresentableGraphicPlugin.class);
        if (plugin != null && (gd = plugin.getGraphicDescriptor(this.graphic)) != null) {
            String name = gd.getName();
            return name;
        }
        return null;
    }

    @Override
    public boolean isVisible(IlvManagerView view) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.graphic == null) {
            return false;
        }
        if (view == null) {
            return this.graphic.isVisible();
        }
        if (!this.graphic.isVisible()) {
            return false;
        }
        for (IlvGraphicBag bag : CoreGraphicUtils.getReverseGraphicBagIterator(this.graphic.getGraphicBag())) {
            IlvManager manager;
            if (!(bag instanceof IlvManager) || (manager = (IlvManager)bag).isVisible() && !manager.isCollapsed()) continue;
            return false;
        }
        if (!view.isShowing()) {
            return false;
        }
        if (this.graphic == view.getManager()) {
            return true;
        }
        IlvRect ilvRect = this.graphic.boundingBox();
        if (this.graphic.getGraphicBag() != null && this.graphic.getGraphicBag() instanceof IlvManager) {
            IlvTransformer dt = ((IlvManager)this.graphic.getGraphicBag()).getDrawingTransformer(view);
            assert (dt != null);
            dt.apply(ilvRect);
        } else {
            view.getTransformer().apply(ilvRect);
        }
        Rectangle rect = new Rectangle();
        rect.setRect((Rectangle2D)ilvRect);
        return view.visibleRect().contains(rect);
    }

    @Override
    public JViewsComponent getParent() {
        IlvGraphicBag bag = this.graphic.getGraphicBag();
        if (bag instanceof IlvGraphic) {
            return new IlvGraphicComponent((IlvGraphic)bag);
        }
        return null;
    }

    @Override
    public List<JViewsComponent> getChildren() {
        if (this.graphic instanceof IlvGraphicBag) {
            ArrayList<JViewsComponent> tn = new ArrayList<JViewsComponent>();
            IlvGraphicBag bag = (IlvGraphicBag)this.graphic;
            IlvGraphicEnumeration ge = bag.getObjects();
            while (ge.hasMoreElements()) {
                tn.add(new IlvGraphicComponent(ge.nextElement()));
            }
            return tn;
        }
        return Collections.emptyList();
    }

    public Class getComponentClass() {
        return this.graphic.getClass();
    }

    @Override
    public IlvRect getBounds() {
        return this.graphic.boundingBox();
    }

    @Override
    public IlvRect getBounds(IlvManagerView view) {
        IlvTransformer transformer;
        if (view == null) {
            throw new IllegalArgumentException("Argument view must not be null");
        }
        IlvRect rect = this.getBounds();
        assert (rect != null);
        IlvManager manager = this.getManager();
        IlvTransformer ilvTransformer = transformer = manager != null ? manager.getDrawingTransformer(view) : view.getTransformer();
        assert (transformer != null);
        transformer.apply(rect);
        return rect;
    }

    @Override
    public IlvManager getManager() {
        return ManagerUtil.getManager(this.graphic);
    }

    @Override
    public void ensureVisible(IlvManagerView view) {
        ViewUtil.ensureVisible(view, this.graphic, true);
    }

    @Override
    public String getToolTipText() {
        return this.graphic.getToolTipText();
    }

    @Override
    public String getLabel() {
        if (this.graphic instanceof IlvLabelInterface) {
            return ((IlvLabelInterface)this.graphic).getLabel();
        }
        return null;
    }

    public final IlvGraphic getGraphic() {
        return this.graphic;
    }

    @Override
    public IlvPoint toLocalPoint(IlvPoint viewPoint, IlvManagerView view) {
        if (viewPoint == null) {
            throw new IllegalArgumentException("Argument screenPoint must not be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("Argument view must not be null");
        }
        IlvManager owningManager = this.getManager();
        if (owningManager != null && owningManager.isCollapsed()) {
            return null;
        }
        IlvTransformer transformer = null;
        transformer = owningManager != null ? owningManager.getDrawingTransformer(view) : (this.getGraphic() instanceof IlvManager ? ((IlvManager)this.getGraphic()).getDrawingTransformer(view) : view.getTransformer());
        assert (transformer != null);
        if (transformer.isBad()) {
            assert (DebugUtils.warning((String)"Transformation is not inversible"));
            return null;
        }
        IlvPoint p = new IlvPoint(viewPoint.x, viewPoint.y);
        transformer.inverse(p);
        IlvPoint localPoint = null;
        localPoint = owningManager != null ? new IlvPoint((float)(p.getX() - this.getBounds().getX()), (float)(p.getY() - this.getBounds().getY())) : p;
        return localPoint;
    }

    @Override
    public IlvPoint toViewPoint(IlvPoint localPoint, IlvManagerView view) {
        if (localPoint == null) {
            throw new IllegalArgumentException("Argument localPoint must not be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("Argument view must not be null");
        }
        IlvManager owningManager = this.getManager();
        if (owningManager != null && owningManager.isCollapsed()) {
            return null;
        }
        IlvTransformer transformer = null;
        transformer = owningManager != null ? owningManager.getDrawingTransformer(view) : (this.getGraphic() instanceof IlvManager ? ((IlvManager)this.getGraphic()).getDrawingTransformer(view) : view.getTransformer());
        assert (transformer != null);
        IlvPoint viewPoint = null;
        viewPoint = owningManager != null ? new IlvPoint((float)(localPoint.getX() + this.getBounds().getX()), (float)(localPoint.getY() + this.getBounds().getY())) : new IlvPoint(localPoint);
        transformer.apply(viewPoint);
        return viewPoint;
    }
}

