/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.testability;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.TreePath;
import oracle.diagram.framework.testability.AbstractDepthFirstSearch;
import oracle.diagram.framework.testability.DefaultJViewsTestabilityChecker;
import oracle.diagram.framework.testability.IComponentNameLookup;
import oracle.diagram.framework.testability.ISearchGoal;
import oracle.diagram.framework.testability.ISearchSolution;
import oracle.diagram.framework.testability.ISearchStrategy;
import oracle.diagram.framework.testability.JViewsComponent;
import oracle.diagram.framework.testability.TestabilityChecker;

final class DefaultJViewsDepthFirstSearch
extends AbstractDepthFirstSearch<JViewsComponent> {
    private final IComponentNameLookup nameLookup;

    DefaultJViewsDepthFirstSearch(IComponentNameLookup nameLookup) {
        if (nameLookup == null) {
            throw new IllegalArgumentException("Argument nameLookup must not be null");
        }
        this.nameLookup = nameLookup;
    }

    JViewsComponent search(JViewsComponent startNode, TreePath path) {
        if (startNode == null) {
            return null;
        }
        if (path == null || path.getPathCount() == 0) {
            return null;
        }
        DefaultSearchGoal searchGoal = new DefaultSearchGoal(path, this.nameLookup);
        DefaultSearchStrategy searchStrategy = new DefaultSearchStrategy(this.nameLookup, searchGoal);
        DefaultSearchSolution searchSolution = new DefaultSearchSolution();
        boolean b = this.search(startNode, searchGoal, searchStrategy, searchSolution);
        if (b) {
            return searchSolution.getSolution();
        }
        return null;
    }

    private static class DefaultSearchSolution
    implements ISearchSolution<JViewsComponent> {
        private volatile JViewsComponent solution;

        @Override
        public void found(JViewsComponent node) {
            this.solution = node;
        }

        public JViewsComponent getSolution() {
            return this.solution;
        }
    }

    private static class DefaultSearchStrategy
    implements ISearchStrategy<JViewsComponent> {
        private final IComponentNameLookup nameService;
        private final DefaultSearchGoal searchGoal;
        private final TestabilityChecker testabilityChecker;

        public DefaultSearchStrategy(IComponentNameLookup nameService, DefaultSearchGoal searchGoal) {
            if (nameService == null) {
                throw new IllegalArgumentException("Argument nameService must not be null");
            }
            if (searchGoal == null) {
                throw new IllegalArgumentException("Argument searchGoal must not be null");
            }
            this.nameService = nameService;
            this.searchGoal = searchGoal;
            this.testabilityChecker = new DefaultJViewsTestabilityChecker(nameService);
        }

        @Override
        public List<JViewsComponent> expand(JViewsComponent node) {
            List<JViewsComponent> children = node.getChildren();
            if (children.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<JViewsComponent> fringe = new ArrayList<JViewsComponent>();
            for (JViewsComponent tn : children) {
                assert (tn != null);
                if (!this.isAdmissible(tn)) continue;
                fringe.add(tn);
            }
            return fringe;
        }

        private boolean isAdmissible(JViewsComponent comp) {
            if (!comp.isVisible(null)) {
                return false;
            }
            if (!this.testabilityChecker.isTestable(comp)) {
                return true;
            }
            String name = this.nameService.getName(comp);
            assert (name != null);
            return name.equals(this.searchGoal.getNextPathElement());
        }
    }

    private static class DefaultSearchGoal
    implements ISearchGoal<JViewsComponent> {
        private final IComponentNameLookup nameService;
        private final LinkedList<String> path = new LinkedList();

        public DefaultSearchGoal(TreePath treePath, IComponentNameLookup nameService) {
            if (treePath == null || treePath.getPathCount() == 0) {
                throw new IllegalArgumentException("Argument path must not be null or empty");
            }
            if (nameService == null) {
                throw new IllegalArgumentException("Argument nameService must not be null");
            }
            this.nameService = nameService;
            for (Object pathElement : treePath.getPath()) {
                if (pathElement == null) {
                    throw new IllegalArgumentException("A component name in the path is null: " + treePath.toString());
                }
                this.path.add((String)pathElement);
            }
        }

        @Override
        public boolean evaluate(JViewsComponent node) {
            String testName;
            assert (!this.path.isEmpty());
            String nextElement = this.path.peek();
            if (nextElement.equals(testName = this.nameService.getName(node))) {
                this.path.pop();
            }
            return this.path.isEmpty();
        }

        String getNextPathElement() {
            return this.path.peek();
        }
    }
}

