/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.testability;

import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import oracle.diagram.framework.testability.JViewsComponent;

public final class CoordinateTransformationUtils {
    private CoordinateTransformationUtils() {
    }

    public static IlvPoint toLocalPoint(IlvPoint viewPoint, JViewsComponent comp, IlvManagerView view) {
        if (viewPoint == null) {
            throw new IllegalArgumentException("Argument screenPoint must not be null");
        }
        if (comp == null) {
            throw new IllegalArgumentException("Argument comp must not be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("Argument view must not be null");
        }
        return comp.toLocalPoint(viewPoint, view);
    }

    public static IlvPoint toViewPoint(IlvPoint localPoint, JViewsComponent comp, IlvManagerView view) {
        if (localPoint == null) {
            throw new IllegalArgumentException("Argument localPoint must not be null");
        }
        if (comp == null) {
            throw new IllegalArgumentException("Argument comp must not be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("Argument view must not be null");
        }
        return comp.toViewPoint(localPoint, view);
    }

    public static IlvPoint toNormalizedLocalPoint(IlvPoint viewPoint, JViewsComponent comp, IlvManagerView view) {
        if (viewPoint == null) {
            throw new IllegalArgumentException("Argument screenPoint must not be null");
        }
        if (comp == null) {
            throw new IllegalArgumentException("Argument comp must not be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("Argument view must not be null");
        }
        IlvPoint localPoint = CoordinateTransformationUtils.toLocalPoint(viewPoint, comp, view);
        if (localPoint == null) {
            return null;
        }
        IlvPoint p = new IlvPoint((float)(localPoint.getX() / comp.getBounds().getWidth()), (float)(localPoint.getY() / comp.getBounds().getHeight()));
        return p;
    }

    public static IlvPoint toViewPointFromNormalizedLocalPoint(IlvPoint normalizedLocalPoint, JViewsComponent comp, IlvManagerView view) {
        if (normalizedLocalPoint == null) {
            throw new IllegalArgumentException("Argument localPoint must not be null");
        }
        if (comp == null) {
            throw new IllegalArgumentException("Argument comp must not be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("Argument view must not be null");
        }
        IlvPoint p = new IlvPoint((float)(normalizedLocalPoint.getX() * comp.getBounds().getWidth()), (float)(normalizedLocalPoint.getY() * comp.getBounds().getHeight()));
        IlvPoint vp = CoordinateTransformationUtils.toViewPoint(p, comp, view);
        return vp;
    }

    public static IlvPoint getCenterInViewCoordinates(JViewsComponent comp, IlvManagerView view) {
        if (comp == null) {
            throw new IllegalArgumentException("Argument comp must not be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("Argument view must not be null");
        }
        return CoordinateTransformationUtils.toViewPointFromNormalizedLocalPoint(new IlvPoint(0.5f, 0.5f), comp, view);
    }

    public static IlvPoint toAbsoluteFromNormalized(IlvPoint normalized, IlvManagerView view) {
        if (normalized == null) {
            throw new IllegalArgumentException("Argument normalized must not be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("Argument view must not be null");
        }
        IlvPoint p = new IlvPoint((float)(normalized.getX() * (double)view.getWidth()), (float)(normalized.getY() * (double)view.getHeight()));
        return p;
    }

    public static IlvPoint toNormalizedFromAbsolute(IlvPoint absolute, IlvManagerView view) {
        if (absolute == null) {
            throw new IllegalArgumentException("Argument absolute must not be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("Argument view must not be null");
        }
        IlvPoint p = new IlvPoint((float)(absolute.getX() / (double)view.getWidth()), (float)(absolute.getY() / (double)view.getHeight()));
        assert (0.0 <= p.getX() && p.getX() <= 1.0) : p.getX();
        assert (0.0 <= p.getY() && p.getY() <= 1.0) : p.getY();
        return p;
    }
}

