/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.swimlanes.interaction;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvRect;
import java.util.HashSet;
import java.util.Iterator;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.interaction.SelectionHandles;
import oracle.diagram.core.util.IlvGraphicEnumerationFromIterator;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.graphic.ExtendedGraphic;
import oracle.diagram.framework.graphic.layout.column.ColumnContainer;
import oracle.diagram.framework.graphic.layout.row.RowContainer;
import oracle.diagram.framework.interaction.ReshapeSelectionHelper;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.swimlanes.SwimlanesPlugin;
import oracle.diagram.framework.swimlanes.graphic.PoolGraphic;
import oracle.diagram.framework.swimlanes.graphic.SwimlaneGraphic;
import oracle.diagram.framework.undo.UndoableStep;

public class SwimlanesReshapeSelectionHelper
implements ReshapeSelectionHelper,
SelectionHandles {
    private DiagramContext _context;
    private SwimlanesPlugin _plugin;
    private SwimlaneGraphic _sg;
    private IlvRect _originalSgBBox;
    private float _trailingOffset;
    private IlvRect _sgBBox;
    private IlvRect _sgIntBBox;

    public SwimlanesReshapeSelectionHelper(DiagramContext context) {
        this._context = context;
    }

    @Override
    public void reshapeInitiated(IlvGraphic graphic) {
        this._plugin = this._context.getPlugin(SwimlanesPlugin.class);
        if (this._plugin != null) {
            IlvManager topManager = ManagerUtil.getTopManager(graphic);
            SwimlaneGraphic sg = this._plugin.getSwimlaneForGraphic(graphic);
            if (sg != null) {
                this._sg = sg;
                this._originalSgBBox = new IlvRect(this._sg.boundingBox(null));
                this._sgBBox = new IlvRect(this._originalSgBBox);
                this._sgIntBBox = this._sg.getInteriorBoundingBox(null);
                SwimlaneGraphic topSwimlane = this._sg.getTopSwimlane();
                if (topSwimlane.isAutoExpand()) {
                    int flowDirection = topSwimlane.getFlowDirection();
                    if (flowDirection == 8) {
                        this._trailingOffset = this._originalSgBBox.x + this._originalSgBBox.width - graphic.boundingBox(null).x;
                    } else if (flowDirection == 2) {
                        this._trailingOffset = this._originalSgBBox.y + this._originalSgBBox.height - graphic.boundingBox(null).y;
                    }
                }
            }
        }
    }

    @Override
    public void reshapeComplete(IlvGraphic graphic) {
        this._sg = null;
        this._originalSgBBox = null;
        this._plugin = null;
    }

    private void nonExpandableConstrain(SwimlaneGraphic sg, IlvGraphic graphic, int handle, boolean isPivotAllowed, IlvRect originalRect, IlvRect reshapeRect) {
        IlvRect sgBBox = sg.getInteriorBoundingBox(null);
        float minX = sgBBox.x;
        float minY = sgBBox.y;
        if (reshapeRect.x < minX) {
            reshapeRect.width = reshapeRect.x + reshapeRect.width - minX;
            reshapeRect.x = minX;
        }
        if (reshapeRect.y < minY) {
            reshapeRect.height = reshapeRect.y + reshapeRect.height - minY;
            reshapeRect.y = minY;
        }
        float maxHeight = sgBBox.y + sgBBox.height - reshapeRect.y - 1.0f;
        float maxWidth = sgBBox.x + sgBBox.width - reshapeRect.x - 1.0f;
        reshapeRect.width = Math.min(reshapeRect.width, maxWidth);
        reshapeRect.height = Math.min(reshapeRect.height, maxHeight);
        reshapeRect.width = reshapeRect.widthFloor();
        reshapeRect.height = reshapeRect.heightFloor();
    }

    private void expandableConstrain(SwimlaneGraphic sg, IlvGraphic graphic, int handle, boolean isPivotAllowed, IlvRect originalRect, IlvRect reshapeRect) {
        IlvRect sgBBox = sg.getInteriorBoundingBox(null);
        SwimlaneGraphic topSwimlane = sg.getTopSwimlane();
        int flowDirection = topSwimlane.getFlowDirection();
        if (flowDirection == 8) {
            float minY = sgBBox.y;
            if (reshapeRect.y < minY) {
                reshapeRect.height = reshapeRect.y + reshapeRect.height - minY;
                reshapeRect.y = minY;
            }
            float maxHeight = sgBBox.y + sgBBox.height - reshapeRect.y - 1.0f;
            reshapeRect.height = Math.min(reshapeRect.height, maxHeight);
        } else if (flowDirection == 2) {
            float minX = sgBBox.x;
            if (reshapeRect.x < minX) {
                reshapeRect.width = reshapeRect.x + reshapeRect.width - minX;
                reshapeRect.x = minX;
            }
            float maxWidth = sgBBox.x + sgBBox.width - reshapeRect.x - 1.0f;
            reshapeRect.width = Math.min(reshapeRect.width, maxWidth);
        }
        reshapeRect.width = reshapeRect.widthFloor();
        reshapeRect.height = reshapeRect.heightFloor();
    }

    protected DimensionFloat getMinimumSize(IlvGraphic g) {
        return g instanceof ExtendedGraphic ? ((ExtendedGraphic)g).getMinimumSize(new DimensionFloat()) : new DimensionFloat(10.0f, 10.0f);
    }

    @Override
    public void constrainReshapeRect(IlvGraphic graphic, int handle, boolean isPivotAllowed, IlvRect originalRect, IlvRect reshapeRect) {
        if (this._sg != null) {
            SwimlaneGraphic topSwimlane;
            if (!isPivotAllowed) {
                DimensionFloat minimumSize = this.getMinimumSize(graphic);
                switch (handle) {
                    case 0: 
                    case 1: 
                    case 2: {
                        reshapeRect.y = Math.min(reshapeRect.y, originalRect.y + originalRect.height - minimumSize.height);
                        reshapeRect.height = originalRect.y + originalRect.height - reshapeRect.y;
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        float bottom = Math.max(reshapeRect.y + reshapeRect.height, originalRect.y + minimumSize.height);
                        reshapeRect.y = originalRect.y;
                        reshapeRect.height = bottom - reshapeRect.y;
                        break;
                    }
                }
                switch (handle) {
                    case 0: 
                    case 3: 
                    case 5: {
                        reshapeRect.x = Math.min(reshapeRect.x, originalRect.x + originalRect.width - minimumSize.width);
                        reshapeRect.width = originalRect.x + originalRect.width - reshapeRect.x;
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 7: {
                        float right = Math.max(reshapeRect.x + reshapeRect.width, originalRect.x + minimumSize.width);
                        reshapeRect.x = originalRect.x;
                        reshapeRect.width = right - reshapeRect.x;
                        break;
                    }
                }
            }
            if ((topSwimlane = this._sg.getTopSwimlane()).isAutoExpand()) {
                this.expandableConstrain(this._sg, graphic, handle, isPivotAllowed, originalRect, reshapeRect);
            } else {
                this.nonExpandableConstrain(this._sg, graphic, handle, isPivotAllowed, originalRect, reshapeRect);
            }
        }
    }

    @Override
    public void preReshapeObject(IlvGraphic graphic, int handle, boolean isPivotAllowed, IlvRect originalRect, IlvRect newRect) {
        block11: {
            int flowDirection;
            block12: {
                SwimlaneGraphic topSwimlane;
                if (this._sg == null || !(topSwimlane = this._sg.getTopSwimlane()).isAutoExpand()) break block11;
                flowDirection = topSwimlane.getFlowDirection();
                if (flowDirection != 8) break block12;
                switch (handle) {
                    case 0: 
                    case 3: 
                    case 5: {
                        if (newRect.x < this._sgIntBBox.x) {
                            float newWidth = this._sgBBox.x + this._sgBBox.width - (newRect.x - (1.0f + this._sg.getShapeLineThickness().floatValue()));
                            float delta = this._sgBBox.width - newWidth;
                            ColumnContainer container = (ColumnContainer)this._sg.getGraphicBag();
                            int index = container.getColumnGraphicIndex(this._sg);
                            container.resizeColumn(index, newWidth);
                            this._sgBBox.width += delta * -1.0f;
                            this._sgIntBBox.width += delta * -1.0f;
                            IlvManager topManager = this._context.getManagerView().getManager();
                            HashSet<IlvGraphic> others = new HashSet<IlvGraphic>(this._plugin.getGraphicsInSwimlane(this._sg));
                            others.remove(graphic);
                            Iterator<IlvGraphic> i = others.iterator();
                            topManager.translateObjects((IlvGraphicEnumeration)new IlvGraphicEnumerationFromIterator(i), delta * -1.0f, 0.0f, null);
                            originalRect.x = this._sgBBox.x + this._sgBBox.width - this._trailingOffset;
                            newRect.width = originalRect.x + originalRect.width - newRect.x;
                            break;
                        }
                        break block11;
                    }
                    case 2: 
                    case 4: 
                    case 7: {
                        if (this._sgIntBBox.x + this._sgIntBBox.width <= newRect.x + newRect.width) {
                            float newWidth = newRect.x + newRect.width + 1.0f + this._sg.getShapeLineThickness().floatValue() - this._sgBBox.x;
                            float delta = this._sgBBox.width - newWidth;
                            ColumnContainer container = (ColumnContainer)this._sg.getGraphicBag();
                            int index = container.getColumnGraphicIndex(this._sg);
                            container.resizeColumn(index, newWidth);
                            this._sgBBox.width += delta * -1.0f;
                            this._sgIntBBox.width += delta * -1.0f;
                            break;
                        }
                        break block11;
                    }
                }
                break block11;
            }
            if (flowDirection == 2) {
                switch (handle) {
                    case 0: 
                    case 1: 
                    case 2: {
                        if (!(newRect.y < this._sgIntBBox.y)) break;
                        float newHeight = this._sgBBox.y + this._sgBBox.height - (newRect.y - (1.0f + this._sg.getShapeLineThickness().floatValue()));
                        float delta = this._sgBBox.height - newHeight;
                        RowContainer container = (RowContainer)this._sg.getGraphicBag();
                        int index = container.getRowGraphicIndex(this._sg);
                        container.resizeRow(index, newHeight);
                        this._sgBBox.height += delta * -1.0f;
                        this._sgIntBBox.height += delta * -1.0f;
                        IlvManager topManager = this._context.getManagerView().getManager();
                        HashSet<IlvGraphic> others = new HashSet<IlvGraphic>(this._plugin.getGraphicsInSwimlane(this._sg));
                        others.remove(graphic);
                        Iterator<IlvGraphic> i = others.iterator();
                        topManager.translateObjects((IlvGraphicEnumeration)new IlvGraphicEnumerationFromIterator(i), 0.0f, delta * -1.0f, null);
                        originalRect.y = this._sgBBox.y + this._sgBBox.height - this._trailingOffset;
                        newRect.height = originalRect.y + originalRect.height - newRect.y;
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        if (!(this._sgIntBBox.y + this._sgIntBBox.height <= newRect.y + newRect.height)) break;
                        float newHeight = newRect.y + newRect.height + 1.0f + this._sg.getShapeLineThickness().floatValue() - this._sgBBox.y;
                        float delta = this._sgBBox.height - newHeight;
                        RowContainer container = (RowContainer)this._sg.getGraphicBag();
                        int index = container.getRowGraphicIndex(this._sg);
                        container.resizeRow(index, newHeight);
                        this._sgBBox.height += delta * -1.0f;
                        this._sgIntBBox.height += delta * -1.0f;
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void postReshapeObject(IlvGraphic graphic, int handle, boolean isPivotAllowed, IlvRect originalRect, IlvRect oldRect) {
        block8: {
            int flowDirection;
            IlvRect newRect;
            IlvRect currentRect;
            block9: {
                SwimlaneGraphic topSwimlane;
                if (this._sg == null || !(topSwimlane = this._sg.getTopSwimlane()).isAutoExpand()) break block8;
                currentRect = new IlvRect(graphic.boundingBox(null));
                newRect = new IlvRect(currentRect);
                flowDirection = topSwimlane.getFlowDirection();
                if (flowDirection != 8) break block9;
                switch (handle) {
                    case 0: 
                    case 3: 
                    case 5: {
                        if (newRect.x < this._sgIntBBox.x) {
                            newRect.x = this._sgIntBBox.x;
                            newRect.width = originalRect.x + originalRect.width - newRect.x;
                            ManagerUtil.getManager(graphic).reshapeObject(graphic, newRect, false);
                            this._context.getManagerView().translate((newRect.x - currentRect.x) * -1.0f, 0.0f, false);
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block8;
            }
            if (flowDirection == 2) {
                switch (handle) {
                    case 0: 
                    case 1: 
                    case 2: {
                        if (!(newRect.y < this._sgIntBBox.y)) break;
                        newRect.y = this._sgIntBBox.y;
                        newRect.height = originalRect.y + originalRect.height - newRect.y;
                        ManagerUtil.getManager(graphic).reshapeObject(graphic, newRect, false);
                        this._context.getManagerView().translate(0.0f, (newRect.y - currentRect.y) * -1.0f, false);
                        break;
                    }
                }
            }
        }
    }

    @Override
    public UndoableStep createUndoableStep(IlvGraphic graphic) {
        SwimlaneGraphic topSwimlane;
        if (this._sg != null && (topSwimlane = this._sg.getTopSwimlane()).isAutoExpand()) {
            return ((PoolGraphic)this._sg.getGraphicBag()).createLaneGraphicUndoableStep(this._sg);
        }
        return null;
    }
}

